/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes.pool;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodeGeneratorInstance_Base;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.IPaymentCodeGenerator;
import pt.ist.fenixframework.FenixFramework;

@Deprecated
public class PaymentCodeGeneratorInstance
extends PaymentCodeGeneratorInstance_Base {
    public PaymentCodeGeneratorInstance() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public PaymentCodeGeneratorInstance(String name, String implementationClassName) {
        this();
        this.setName(name);
        this.setImplementationClassName(implementationClassName);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.PaymentCodeGeneratorInstance.domainRoot.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new TreasuryDomainException("error.PaymentCodeGeneratorInstance.name.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getImplementationClassName())) {
            throw new TreasuryDomainException("error.PaymentCodeGeneratorInstance.implementationClassName.required", new String[0]);
        }
        if (PaymentCodeGeneratorInstance.findByImplementationClassName(this.getImplementationClassName()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentCodeGeneratorInstance.implementationClassName.already.created", new String[0]);
        }
    }

    public IPaymentCodeGenerator getPaymentCodeGenerator(PaymentCodePool paymentCodePool) {
        try {
            return (IPaymentCodeGenerator)Class.forName(this.getImplementationClassName()).getConstructor(PaymentCodePool.class).newInstance(new Object[]{paymentCodePool});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static PaymentCodeGeneratorInstance create(String name, String implementationClassName) {
        return new PaymentCodeGeneratorInstance(name, implementationClassName);
    }

    public static Stream<PaymentCodeGeneratorInstance> findAll() {
        return FenixFramework.getDomainRoot().getPaymentCodeGeneratorInstancesSet().stream();
    }

    public static Stream<PaymentCodeGeneratorInstance> findByImplementationClassName(String implementationClassName) {
        return PaymentCodeGeneratorInstance.findAll().filter(e -> e.getImplementationClassName().toLowerCase().equals(implementationClassName.toLowerCase()));
    }

    public static Optional<PaymentCodeGeneratorInstance> findUniqueByImplementationClassName(String implementationClassName) {
        return PaymentCodeGeneratorInstance.findByImplementationClassName(implementationClassName).findFirst();
    }
}

