/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan$callable$annul;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan$callable$close;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan$callable$nonCompliance;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanStateType;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.PaymentPlanBean;
import org.fenixedu.treasury.dto.PendingDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentPlan
extends PaymentPlan_Base {
    public static final Advice advice$annul = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$close = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$nonCompliance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaymentPlan() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private PaymentPlan(PaymentPlanBean paymentPlanBean) {
        this();
        DebtAccount debtAccount = paymentPlanBean.getDebtAccount();
        this.setFinantialEntity(paymentPlanBean.getFinantialEntity());
        if (this.getFinantialEntity() == null) {
            if (FinantialEntity.find(debtAccount.getFinantialInstitution()).count() != 1L) {
                throw new RuntimeException("not supported for more than one finantial entity by finantial institution");
            }
            this.setFinantialEntity((FinantialEntity)((Object)FinantialEntity.find(debtAccount.getFinantialInstitution()).iterator().next()));
        }
        this.setCreationDate(paymentPlanBean.getCreationDate());
        this.setReason(paymentPlanBean.getReason());
        this.setDebtAccount(debtAccount);
        this.setState(PaymentPlanStateType.OPEN);
        this.setStateReason(null);
        this.setPaymentPlanId(paymentPlanBean.getPaymentPlanConfigurator().getNumberGenerators().generateNumber());
        this.setInterestChangeReason(paymentPlanBean.getInterestChangeReason());
        if (paymentPlanBean.getPaymentPlanValidator() != null) {
            this.getPaymentPlanValidatorsSet().add(paymentPlanBean.getPaymentPlanValidator());
        }
        Map<ISettlementInvoiceEntryBean, DebitEntry> createdEntries = this.createDebitEntriesMap(paymentPlanBean);
        this.createInstallments(paymentPlanBean, createdEntries);
        this.annulPaymentReferenceCodeFromDebitEntries(paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(bean -> bean.isForDebitEntry()).map(bean -> ((SettlementDebitEntryBean)bean).getDebitEntry()).collect(Collectors.toList()));
        this.checkRules();
    }

    public static PaymentPlan createPaymentPlan(PaymentPlanBean paymentPlanBean) {
        PaymentPlan paymentPlan;
        try {
            paymentPlan = (PaymentPlan)((Object)FenixFramework.atomic(() -> new PaymentPlan(paymentPlanBean)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (Boolean.TRUE.equals(paymentPlanBean.getPaymentPlanConfigurator().getCreatePaymentCode())) {
            paymentPlan.createPaymentReferenceCode();
        }
        return paymentPlan;
    }

    public void annul(String string) {
        Object object = advice$annul.perform((Callable)new PaymentPlan$callable$annul(this, string));
    }

    static /* synthetic */ void advised$annul(PaymentPlan this_, String reason) {
        this_.setState(PaymentPlanStateType.ANNULED);
        this_.setStateReason(reason);
    }

    public void close(String string) {
        Object object = advice$close.perform((Callable)new PaymentPlan$callable$close(this, string));
    }

    static /* synthetic */ void advised$close(PaymentPlan this_, String reason) {
        this_.setState(PaymentPlanStateType.CLOSED);
        this_.setStateReason(reason);
    }

    public void nonCompliance(LocalDate localDate) {
        Object object = advice$nonCompliance.perform((Callable)new PaymentPlan$callable$nonCompliance(this, localDate));
    }

    static /* synthetic */ void advised$nonCompliance(PaymentPlan this_, LocalDate date) {
        this_.setState(PaymentPlanStateType.NON_COMPLIANCE);
        this_.setStateReason(TreasuryConstants.treasuryBundle("label.PaymentPlan.paymentPlan.nonCompliance", date.toString("yyyy-MM-dd")));
    }

    public Map<String, String> getPropertiesMap() {
        return TreasuryConstants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public void editPropertiesMap(Map<String, String> propertiesMap) {
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
    }

    public void checkRules() {
        if (this.getReason() == null) {
            throw new TreasuryDomainException("error.paymentPlan.reason.required", new String[0]);
        }
        if (this.getCreationDate() == null) {
            throw new TreasuryDomainException("error.paymentPlan.creationDate.required", new String[0]);
        }
        if (this.getState() == null) {
            throw new TreasuryDomainException("error.paymentPlan.creationDate.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.paymentPlan.creationDate.required", new String[0]);
        }
        if (this.getInstallmentsSet() == null || this.getInstallmentsSet().isEmpty()) {
            throw new TreasuryDomainException("error.paymentPlan.installments.required", new String[0]);
        }
        if (this.getDebtAccount().getActivePaymentPlansSet().size() > TreasurySettings.getInstance().getNumberOfPaymentPlansActivesPerStudent()) {
            throw new TreasuryDomainException("error.paymentPlan.max.active.plans.reached", new String[0]);
        }
        if (this.getCustomers().size() > 1) {
            throw new TreasuryDomainException("error.paymentPlan.multiple.customers", new String[0]);
        }
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.hasDebitEntriesExportedInLegacyERP()) {
            throw new TreasuryDomainException("error.PaymentPlan.debitEntries.exported.in.legacyERP.not.supported.in.restrictedPaymentMode", new String[0]);
        }
        if (this.getInstallmentsSet().stream().flatMap(i -> i.getInstallmentEntriesSet().stream()).anyMatch(e -> e.getDebitEntry().getDebtAccount() != this.getDebtAccount())) {
            throw new TreasuryDomainException("error.PaymentPlan.some.debitEntries.not.from.debtAccount", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new TreasuryDomainException("error.PaymentPlan.finantialEntity.required", new String[0]);
        }
    }

    private boolean hasDebitEntriesExportedInLegacyERP() {
        return this.getInstallmentsSet().stream().flatMap(i -> i.getInstallmentEntriesSet().stream()).map(i -> i.getDebitEntry()).anyMatch(d -> d.getFinantialDocument() != null && d.getFinantialDocument().isExportedInLegacyERP());
    }

    private Set<Customer> getCustomers() {
        Set debitEntries = this.getInstallmentsSet().stream().flatMap(i -> i.getInstallmentEntriesSet().stream()).map(ie -> ie.getDebitEntry()).collect(Collectors.toSet());
        return debitEntries.stream().map(entry -> entry.getFinantialDocument() != null && ((Invoice)((Object)((Object)((Object)entry.getFinantialDocument())))).isForPayorDebtAccount() ? ((Invoice)((Object)((Object)((Object)entry.getFinantialDocument())))).getPayorDebtAccount().getCustomer() : entry.getDebtAccount().getCustomer()).collect(Collectors.toSet());
    }

    private static DebitNote createDebitNote(PaymentPlanBean paymentPlanBean, PaymentPlan result) {
        DocumentNumberSeries defaultDocumentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), paymentPlanBean.getDebtAccount().getFinantialInstitution()).get();
        return DebitNote.create(paymentPlanBean.getFinantialEntity(), paymentPlanBean.getDebtAccount(), null, defaultDocumentNumberSeries, result.getCreationDate().toDateTimeAtStartOfDay(), result.getCreationDate(), null, Collections.emptyMap(), null, null);
    }

    private static DebitEntry createDebitEntry(FinantialEntity finantialEntity, DebtAccount debtAccount, String description, BigDecimal amount, LocalDate creationDate, LocalDate endDate, Product product, Vat vat, DebitNote debitNote) {
        return DebitEntry.create(finantialEntity, debtAccount, null, vat, amount, endDate, Maps.newHashMap(), product, description, BigDecimal.ONE, null, creationDate.toDateTimeAtStartOfDay(), false, false, debitNote);
    }

    private Map<ISettlementInvoiceEntryBean, DebitEntry> createDebitEntriesMap(PaymentPlanBean paymentPlanBean) {
        HashMap<ISettlementInvoiceEntryBean, DebitEntry> result = new HashMap<ISettlementInvoiceEntryBean, DebitEntry>();
        DebtAccount debtAccount = paymentPlanBean.getDebtAccount();
        LocalDate creationDate = paymentPlanBean.getCreationDate();
        LocalDate endDate = paymentPlanBean.getEndDate();
        paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(pendingBean -> pendingBean.isForDebitEntry()).forEach(debitEntryBean -> result.put((ISettlementInvoiceEntryBean)debitEntryBean, (DebitEntry)((Object)((Object)((Object)debitEntryBean.getInvoiceEntry())))));
        paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(pendingBean -> pendingBean.isForPendingDebitEntry()).forEach(bean -> {
            PendingDebitEntryBean debitEntryBean = (PendingDebitEntryBean)bean;
            DebitNote debitNote = PaymentPlan.createDebitNote(paymentPlanBean, this);
            Product product = debitEntryBean.getProduct();
            Vat vat = Vat.findActiveUnique(product.getVatType(), debtAccount.getFinantialInstitution(), new DateTime()).orElse(null);
            DebitEntry debitEntry = PaymentPlan.createDebitEntry(this.getFinantialEntity(), debtAccount, debitEntryBean.getDescription(), debitEntryBean.getSettledAmount(), creationDate, endDate, product, vat, debitNote);
            result.put((ISettlementInvoiceEntryBean)bean, debitEntry);
        });
        paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(pendingBean -> pendingBean.isForPendingInterest()).forEach(bean -> {
            SettlementInterestEntryBean interestEntryBean = (SettlementInterestEntryBean)bean;
            DebitNote debitNote = PaymentPlan.createDebitNote(paymentPlanBean, this);
            Product product = TreasurySettings.getInstance().getInterestProduct();
            Vat vat = Vat.findActiveUnique(product.getVatType(), debtAccount.getFinantialInstitution(), new DateTime()).orElse(null);
            DebitEntry debitEntry = PaymentPlan.createDebitEntry(this.getFinantialEntity(), debtAccount, interestEntryBean.getDescription(), interestEntryBean.getSettledAmount(), creationDate, endDate, product, vat, debitNote);
            interestEntryBean.getDebitEntry().addInterestDebitEntries(debitEntry);
            result.put((ISettlementInvoiceEntryBean)bean, debitEntry);
        });
        paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(pendingBean -> pendingBean.isForPaymentPenalty()).forEach(bean -> {
            PaymentPenaltyEntryBean penaltyBean = (PaymentPenaltyEntryBean)bean;
            DebitEntry debitEntry = PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax(penaltyBean.getDebitEntry(), penaltyBean.getDueDate(), paymentPlanBean.getCreationDate(), null, true);
            result.put((ISettlementInvoiceEntryBean)bean, debitEntry);
        });
        return result;
    }

    private void createInstallments(PaymentPlanBean paymentPlanBean, Map<ISettlementInvoiceEntryBean, DebitEntry> createdEntries) {
        for (InstallmentBean installmentBean : paymentPlanBean.getInstallmentsBean()) {
            Installment installment = Installment.create(installmentBean.getDescription(), installmentBean.getDueDate(), this);
            for (InstallmentEntryBean installmentEntryBean : installmentBean.getInstallmentEntries()) {
                DebitEntry debitEntry = createdEntries.get(installmentEntryBean.getInvoiceEntry());
                InstallmentEntry.create(debitEntry, installmentEntryBean.getAmount(), installment);
            }
        }
    }

    public void createPaymentReferenceCode() {
        ISibsPaymentCodePoolService paymentCodePool = ISibsPaymentCodePoolService.getDefaultDigitalPaymentPlatform(this.getFinantialEntity());
        if (paymentCodePool == null) {
            throw new IllegalArgumentException(TreasuryConstants.treasuryBundle("error.paymentPlan.paymentCodePool.required", new String[0]));
        }
        for (Installment installment : this.getInstallmentsSet()) {
            if (installment.getPaymentRequestsSet().stream().filter(request -> request instanceof SibsPaymentRequest).count() != 0L) continue;
            paymentCodePool.createSibsPaymentRequest(this.getDebtAccount(), Collections.emptySet(), Set.of(installment));
        }
    }

    private void annulPaymentReferenceCodeFromDebitEntries(List<DebitEntry> list) {
        for (DebitEntry entry : list) {
            Set paymentCodesSet = entry.getSibsPaymentRequests().stream().filter(s -> !s.isInPaidState()).collect(Collectors.toSet());
            for (SibsPaymentRequest paymentCode : paymentCodesSet) {
                if (paymentCode.getDebitEntriesSet().size() != 1 || !paymentCode.getInstallmentsSet().isEmpty()) continue;
                paymentCode.anull();
            }
        }
    }

    public List<DebitEntry> getSortEntriesList(Collection<DebitEntry> collection) {
        return collection.stream().sorted(DebitEntry.COMPARE_DEBIT_ENTRY_IN_SAME_PAYMENT_PLAN).collect(Collectors.toList());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPlan$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPlan this_) {
        this_.setDomainRoot(null);
        this_.getEmolument().delete();
        this_.getInstallmentsSet().forEach(i -> i.delete());
        this_.deleteDomainObject();
    }

    public List<Installment> getSortedOpenInstallments() {
        return super.getInstallmentsSet().stream().filter(inst -> !inst.isPaid()).sorted(Installment.COMPARE_BY_DUEDATE).collect(Collectors.toList());
    }

    public List<Installment> getSortedInstallments() {
        return super.getInstallmentsSet().stream().sorted(Installment.COMPARE_BY_DUEDATE).collect(Collectors.toList());
    }

    public BigDecimal getTotalDebitEntry(DebitEntry debitEntry) {
        return this.getInstallmentsSet().stream().flatMap(inst -> inst.getInstallmentEntriesSet().stream()).filter(ent -> ent.getDebitEntry() == debitEntry).map(i -> i.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public boolean isCompliant() {
        return this.isCompliant(LocalDate.now());
    }

    public boolean isCompliant(LocalDate date) {
        return this.getPaymentPlanValidatorsSet().stream().allMatch(v -> v.validate(date, this.getSortedInstallments()));
    }

    public void tryClosePaymentPlanByPaidOff() {
        if (this.getSortedOpenInstallments().isEmpty()) {
            this.close(TreasuryConstants.treasuryBundle("label.PaymentPlan.paymentPlan.paidOff", new String[0]) + " [" + new LocalDate().toString("yyyy-MM-dd") + "]");
        }
    }

    public static Stream<PaymentPlan> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPlansSet().stream();
    }

    public static Stream<PaymentPlan> findByPaymentPlanId(String paymentPlanId) {
        return PaymentPlan.findAll().filter(p -> paymentPlanId.equals(p.getPaymentPlanId()));
    }

    public static Optional<PaymentPlan> findUniqueByPaymentPlanId(String paymentPlanId) {
        return PaymentPlan.findByPaymentPlanId(paymentPlanId).findFirst();
    }

    public static void validatePaymentPlanInNonCompliance() {
        for (PaymentPlan paymentPlan : FenixFramework.getDomainRoot().getPaymentPlansSet()) {
            if (!paymentPlan.getState().isOpen() || paymentPlan.isCompliant()) continue;
            paymentPlan.nonCompliance(LocalDate.now());
        }
    }
}

