/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Base64;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.IntegrationOperation$callable$appendLog;
import org.fenixedu.treasury.domain.integration.IntegrationOperation$callable$delete;
import org.fenixedu.treasury.domain.integration.IntegrationOperation_Base;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class IntegrationOperation
extends IntegrationOperation_Base {
    private static final String ERROR_LOG_TXT_FILENAME = "errorLog.txt";
    private static final String INTEGRATION_LOG_TXT_FILENAME = "integrationLog.txt";
    private static final String SOAP_OUTBOUND_MESSAGE_TXT_FILENAME = "soapOutboundMessage.txt";
    private static final String SOAP_INBOUND_MESSAGE_TXT_FILENAME = "soapInboundMessage.txt";
    public static final Advice advice$appendLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected IntegrationOperation() {
    }

    protected void init(String erpOperationId, DateTime executionDate, boolean processed, boolean success, String errorLog) {
        this.setErpOperationId(erpOperationId);
        this.setExecutionDate(executionDate);
        this.setProcessed(processed);
        this.setSuccess(success);
        this.setErrorLog(errorLog);
        this.checkRules();
    }

    private void checkRules() {
        if (!Strings.isNullOrEmpty((String)this.getErrorLog())) {
            this.setSuccess(false);
        }
    }

    public void appendLog(String string, String string2, String string3, String string4) {
        Object object = advice$appendLog.perform((Callable)new IntegrationOperation$callable$appendLog(this, string, string2, string3, string4));
    }

    static /* synthetic */ void advised$appendLog(IntegrationOperation this_, String errorLog, String integrationLog, String soapInboundMessage, String soapOutboundMessage) {
        if (errorLog == null) {
            errorLog = "";
        }
        if (integrationLog == null) {
            integrationLog = "";
        }
        if (soapInboundMessage == null) {
            soapInboundMessage = "";
        }
        if (soapOutboundMessage == null) {
            soapOutboundMessage = "";
        }
        if (!Strings.isNullOrEmpty((String)this_.getErrorLog())) {
            errorLog = this_.getErrorLog() + (String)errorLog;
        }
        if (!Strings.isNullOrEmpty((String)this_.getIntegrationLog())) {
            integrationLog = this_.getIntegrationLog() + (String)integrationLog;
        }
        if (!Strings.isNullOrEmpty((String)this_.getSoapInboundMessage())) {
            soapInboundMessage = this_.getSoapInboundMessage() + (String)soapInboundMessage;
        }
        if (!Strings.isNullOrEmpty((String)this_.getSoapOutboundMessage())) {
            soapOutboundMessage = this_.getSoapOutboundMessage() + (String)soapOutboundMessage;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            zos.putNextEntry(new ZipEntry(ERROR_LOG_TXT_FILENAME));
            zos.write(((String)errorLog).getBytes("UTF-8"));
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(INTEGRATION_LOG_TXT_FILENAME));
            zos.write(((String)integrationLog).getBytes("UTF-8"));
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(SOAP_INBOUND_MESSAGE_TXT_FILENAME));
            zos.write(((String)soapInboundMessage).getBytes("UTF-8"));
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(SOAP_OUTBOUND_MESSAGE_TXT_FILENAME));
            zos.write(((String)soapOutboundMessage).getBytes("UTF-8"));
            zos.closeEntry();
            zos.close();
            baos.close();
            byte[] contents = baos.toByteArray();
            if (this_.getLogFile() != null) {
                this_.getLogFile().delete();
            }
            OperationFile.createLog(String.format("integrationOperationLogs-%s.zip", this_.getExternalId()), contents, this_);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new IntegrationOperation$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(IntegrationOperation this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.IntegrationOperation.cannot.delete", new String[0]);
        }
        this_.setFinantialInstitution(null);
        if (this_.getFile() != null) {
            this_.getFile().delete();
        }
        this_.setFile(null);
        if (this_.getLogFile() != null) {
            this_.getLogFile().delete();
        }
        this_.deleteDomainObject();
    }

    private String unzip(String possibleZippedString) {
        String value = possibleZippedString;
        if (value != null) {
            try {
                GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(possibleZippedString)));
                value = IOUtils.toString((InputStream)gzipInputStream);
                gzipInputStream.close();
            }
            catch (Throwable t) {
                value = possibleZippedString;
            }
        }
        return value;
    }

    public String getSoapInboundMessage() {
        String soapInboundMessage = this.readLogZipFile(SOAP_INBOUND_MESSAGE_TXT_FILENAME);
        if (!Strings.isNullOrEmpty((String)soapInboundMessage)) {
            return soapInboundMessage;
        }
        return this.unzip(super.getSoapInboundMessage());
    }

    public String getSoapOutboundMessage() {
        String soapOutboundMessage = this.readLogZipFile(SOAP_OUTBOUND_MESSAGE_TXT_FILENAME);
        if (!Strings.isNullOrEmpty((String)soapOutboundMessage)) {
            return soapOutboundMessage;
        }
        return this.unzip(super.getSoapOutboundMessage());
    }

    public String getIntegrationLog() {
        String integrationLog = this.readLogZipFile(INTEGRATION_LOG_TXT_FILENAME);
        if (!Strings.isNullOrEmpty((String)integrationLog)) {
            return integrationLog;
        }
        return this.unzip(super.getIntegrationLog());
    }

    public String getErrorLog() {
        String errorLog = this.readLogZipFile(ERROR_LOG_TXT_FILENAME);
        if (!Strings.isNullOrEmpty((String)errorLog)) {
            return errorLog;
        }
        return this.unzip(super.getErrorLog());
    }

    private String readLogZipFile(String zipFilename) {
        try {
            if (this.getLogFile() != null) {
                ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.getLogFile().getContent()));
                ZipEntry zipEntry = null;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (!zipFilename.equals(zipEntry.getName())) continue;
                    return new String(IOUtils.toByteArray((InputStream)zis), "UTF-8");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

