/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.debt.balancetransfer;

import java.math.BigDecimal;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.debt.balancetransfer.StandardBalanceTransferServiceForSAPAndSINGAP;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class BalanceTransferForSAPAndSINGAPWithCompensationForAdvancePaymentCredits
extends StandardBalanceTransferServiceForSAPAndSINGAP {
    public BalanceTransferForSAPAndSINGAPWithCompensationForAdvancePaymentCredits(DebtAccount fromDebtAccount, DebtAccount destinyDebtAccount) {
        super(fromDebtAccount, destinyDebtAccount);
    }

    @Override
    protected void transferCreditEntry(CreditEntry creditEntry) {
        if (this.isAdvancedPaymentCredit(creditEntry)) {
            BigDecimal creditOpenAmount = creditEntry.getOpenAmount();
            this.reimburseAdvancePaymentCredit(creditEntry, creditOpenAmount);
            this.createAdvancePaymentCreditInDestinyDebtAccount(creditEntry, creditOpenAmount);
        } else {
            super.transferCreditEntry(creditEntry);
        }
    }

    private void createAdvancePaymentCreditInDestinyDebtAccount(CreditEntry creditEntry, BigDecimal creditOpenAmount) {
        FinantialInstitution finantialInstitution = this.destinyDebtAccount.getFinantialInstitution();
        Series defaultSeries = Series.findUniqueDefault(finantialInstitution).get();
        DocumentNumberSeries settlementNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), defaultSeries);
        FinantialEntity finantialEntity = creditEntry.getFinantialEntity();
        SettlementNoteBean settlementNoteBean = new SettlementNoteBean(this.destinyDebtAccount, false, false);
        settlementNoteBean.setDate(new DateTime());
        settlementNoteBean.setDocNumSeries(settlementNoteSeries);
        settlementNoteBean.setAdvancePayment(true);
        settlementNoteBean.setFinantialEntity(finantialEntity);
        settlementNoteBean.getPaymentEntries().add(new SettlementNoteBean.PaymentEntryBean(creditOpenAmount, finantialInstitution.getErpIntegrationConfiguration().getBalanceCompensationPaymentMethod(), null));
        SettlementNote settlementNote = SettlementNote.createSettlementNote(settlementNoteBean);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            settlementNote.setExportedInLegacyERP(true);
            settlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            settlementNote.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
            settlementNote.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
    }

    private void reimburseAdvancePaymentCredit(CreditEntry creditEntry, BigDecimal creditOpenAmount) {
        FinantialInstitution finantialInstitution = this.fromDebtAccount.getFinantialInstitution();
        Series defaultSeries = Series.findUniqueDefault(finantialInstitution).get();
        DocumentNumberSeries reimbursementNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForReimbursementNote(), defaultSeries);
        DateTime entryDateTime = new DateTime();
        FinantialEntity finantialEntity = creditEntry.getFinantialEntity();
        SettlementNoteBean settlementNoteBean = new SettlementNoteBean(this.fromDebtAccount, true, true);
        settlementNoteBean.setDate(entryDateTime);
        settlementNoteBean.setDocNumSeries(reimbursementNoteSeries);
        settlementNoteBean.setFinantialEntity(finantialEntity);
        settlementNoteBean.getCreditEntries().stream().filter(ce -> ce.getInvoiceEntry() == creditEntry).forEach(ce -> ce.setIncluded(true));
        settlementNoteBean.getPaymentEntries().add(new SettlementNoteBean.PaymentEntryBean(creditOpenAmount, finantialInstitution.getErpIntegrationConfiguration().getBalanceCompensationPaymentMethod(), null));
        SettlementNote reimbursementNote = SettlementNote.createSettlementNote(settlementNoteBean);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            reimbursementNote.setExportedInLegacyERP(true);
            reimbursementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            reimbursementNote.getSettlemetEntriesSet().stream().forEach(se -> se.setEntryDateTime(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1)));
        }
    }

    private boolean isAdvancedPaymentCredit(CreditEntry invoiceEntry) {
        return invoiceEntry.getFinantialDocument() != null && invoiceEntry.getFinantialDocument() instanceof AdvancedPaymentCreditNote;
    }

    public static LocalizedString getPresentationName() {
        return TreasuryConstants.treasuryBundleI18N("label.BalanceTransferForSAPAndSINGAPWithCompensationForAdvancePaymentCredits.presentationName", new String[0]);
    }
}

