/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import eu.europa.ec.taxud.tin.algorithm.TINValid;
import java.util.List;
import java.util.regex.Pattern;
import org.fenixedu.treasury.util.TreasuryConstants;

public class FiscalCodeValidation {
    private static final List<String> VALIDATED_COUNTRIES = Lists.newArrayList((Object[])new String[]{"PT", "AT", "BE", "BG", "CY", "DE", "DK", "EE", "ES", "FI", "FR", "HR", "HU", "IE", "IT", "LT", "LU", "NL", "PL", "SE", "SI", "GB"});

    public static boolean isValidationAppliedToFiscalCountry(String countryCode) {
        return VALIDATED_COUNTRIES.contains(countryCode.toUpperCase());
    }

    public static boolean isValidFiscalNumber(String countryCode, String fiscalNumber) {
        if (Strings.isNullOrEmpty((String)countryCode)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            return false;
        }
        if (!TreasuryConstants.isDefaultCountry(countryCode) && "999999990".equals(fiscalNumber)) {
            return false;
        }
        if (VALIDATED_COUNTRIES.contains(countryCode.toUpperCase())) {
            if (FiscalCodeValidation.customValidation(countryCode, fiscalNumber)) {
                return true;
            }
            int checkTIN = TINValid.checkTIN((String)FiscalCodeValidation.translateCountry(countryCode.toUpperCase()), (String)fiscalNumber);
            return checkTIN == 0 || checkTIN == 2;
        }
        return true;
    }

    private static boolean customValidation(String countryCode, String fiscalNumber) {
        return "DE".equals(countryCode.toUpperCase()) && Pattern.matches("\\d{9}", fiscalNumber);
    }

    private static String translateCountry(String countryCode) {
        if ("GB".equals(countryCode)) {
            return "UK";
        }
        return countryCode;
    }
}

