/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports;

import com.qubit.terra.docs.core.DocumentGenerator;
import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.core.IDocumentTemplate;
import com.qubit.terra.docs.core.IDocumentTemplateService;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.util.List;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.services.reports.DocumentPrinterConfiguration;
import org.fenixedu.treasury.services.reports.dataproviders.CustomerDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.DebtAccountDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.FinantialInstitutionDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.InvoiceDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.SettlementNoteDataProvider;
import org.fenixedu.treasury.services.reports.helpers.DateHelper;
import org.fenixedu.treasury.services.reports.helpers.EnumerationHelper;
import org.fenixedu.treasury.services.reports.helpers.LanguageHelper;
import org.fenixedu.treasury.services.reports.helpers.MoneyHelper;
import org.fenixedu.treasury.services.reports.helpers.NumbersHelper;
import org.fenixedu.treasury.services.reports.helpers.StringsHelper;

public class DocumentPrinter {
    public static final String PDF = "application/pdf";
    public static final String ODT = "application/vnd.oasis.opendocument.text";

    private static void registerService() {
        DocumentPrinterConfiguration service = new DocumentPrinterConfiguration();
        DocumentTemplateEngine.registerServiceImplementations((IDocumentTemplateService)service);
    }

    private static void registerHelpers(DocumentGenerator generator) {
        generator.registerHelper("dates", (IDocumentHelper)new DateHelper());
        generator.registerHelper("lang", (IDocumentHelper)new LanguageHelper());
        generator.registerHelper("numbers", (IDocumentHelper)new NumbersHelper());
        generator.registerHelper("enumeration", (IDocumentHelper)new EnumerationHelper());
        generator.registerHelper("strings", (IDocumentHelper)new StringsHelper());
        generator.registerHelper("money", (IDocumentHelper)new MoneyHelper());
    }

    public static byte[] printDebtAccountPaymentPlan(DebtAccount debtAccount, String outputMimeType) {
        return DocumentPrinter.printDebitNotesPaymentPlan(debtAccount, null, outputMimeType);
    }

    public static byte[] printDebitNotesPaymentPlan(DebtAccount debtAccount, List<DebitNote> documents, String outputMimeType) {
        DocumentGenerator generator = null;
        generator = DocumentGenerator.create((String)"F:\\O\\fenixedu\\fenixedu-academic-treasury\\src\\main\\resources\\templates\\tuitionsPaymentPlan.odt", (String)outputMimeType);
        Customer customer = debtAccount.getCustomer();
        FinantialInstitution finst = debtAccount.getFinantialInstitution();
        DocumentPrinter.registerHelpers(generator);
        generator.registerDataProvider((IReportDataProvider)new DebtAccountDataProvider(debtAccount, documents));
        generator.registerDataProvider((IReportDataProvider)new CustomerDataProvider(customer, "customer"));
        generator.registerDataProvider((IReportDataProvider)new FinantialInstitutionDataProvider(finst));
        byte[] outputReport = generator.generateReport();
        return outputReport;
    }

    public static byte[] printFinantialDocument(FinantialDocument document, String outputMimeType) {
        TreasuryDocumentTemplate templateInEntity = TreasuryDocumentTemplate.findByFinantialDocumentTypeAndFinantialEntity(document.getFinantialDocumentType(), (FinantialEntity)((Object)document.getDebtAccount().getFinantialInstitution().getFinantialEntitiesSet().iterator().next())).filter(x -> x.isActive()).findFirst().orElse(null);
        DocumentGenerator generator = null;
        generator = templateInEntity != null ? DocumentGenerator.create((IDocumentTemplate)templateInEntity, (String)outputMimeType) : DocumentGenerator.create((String)"F:\\O\\fenixedu\\fenixedu-treasury\\src\\main\\resources\\document_templates\\settlementNote.odt", (String)outputMimeType);
        DocumentPrinter.registerHelpers(generator);
        if (document.isInvoice()) {
            generator.registerDataProvider((IReportDataProvider)new InvoiceDataProvider((Invoice)((Object)document)));
        } else if (document.isSettlementNote()) {
            generator.registerDataProvider((IReportDataProvider)new SettlementNoteDataProvider((SettlementNote)((Object)document)));
        }
        generator.registerDataProvider((IReportDataProvider)new DebtAccountDataProvider(document.getDebtAccount()));
        generator.registerDataProvider((IReportDataProvider)new CustomerDataProvider(document.getDebtAccount().getCustomer(), "customer"));
        generator.registerDataProvider((IReportDataProvider)new FinantialInstitutionDataProvider(document.getDebtAccount().getFinantialInstitution()));
        if (document.isInvoice()) {
            Invoice invoice = (Invoice)((Object)document);
            Customer payorCustomer = invoice.getPayorDebtAccount() != null ? invoice.getPayorDebtAccount().getCustomer() : invoice.getDebtAccount().getCustomer();
            generator.registerDataProvider((IReportDataProvider)new CustomerDataProvider(payorCustomer, "payorCustomer"));
        } else if (document.isSettlementNote()) {
            SettlementNote settlementNote = (SettlementNote)((Object)document);
            Customer payorCustomer = settlementNote.getReferencedCustomers().iterator().next();
            generator.registerDataProvider((IReportDataProvider)new CustomerDataProvider(payorCustomer, "payorCustomer"));
        }
        byte[] outputReport = generator.generateReport();
        return outputReport;
    }

    static {
        DocumentPrinter.registerService();
    }
}

