/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.model;

import java.math.BigDecimal;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayResponseInquiry;
import org.joda.time.DateTime;

public class SibsPayResponseInquiryWrapper
implements DigitalPlatformResultBean {
    private SibsPayResponseInquiry responseInquiry;
    private String requestLog;
    private String responseLog;

    public SibsPayResponseInquiryWrapper(SibsPayResponseInquiry responseInquiry, String requestLog, String responseLog) {
        this.responseInquiry = responseInquiry;
        this.requestLog = requestLog;
        this.responseLog = responseLog;
    }

    public BigDecimal getAmount() {
        return this.responseInquiry.getAmount().getValue();
    }

    public String getMerchantTransactionId() {
        return this.responseInquiry.getMerchant().getMerchantTransactionId();
    }

    public String getPaymentBrand() {
        return this.responseInquiry.getPaymentMethod();
    }

    public DateTime getPaymentDate() {
        return null;
    }

    public String getPaymentResultCode() {
        return this.responseInquiry.getPaymentStatus();
    }

    public String getPaymentResultDescription() {
        return this.responseInquiry.getPaymentStatus();
    }

    public String getPaymentType() {
        return this.responseInquiry.getPaymentType();
    }

    public String getTimestamp() {
        return null;
    }

    public String getTransactionId() {
        return this.responseInquiry.getTransactionID();
    }

    public String getReferenceCode() {
        return this.responseInquiry.getPaymentReference().getReference();
    }

    public boolean isOperationSuccess() {
        return SibsPayAPIService.isOperationSuccess(this.responseInquiry.getReturnStatus().getStatusCode());
    }

    public String getOperationStatusCode() {
        return this.responseInquiry.getReturnStatus().getStatusCode();
    }

    public String getOperationStatusMessage() {
        return this.responseInquiry.getReturnStatus().getStatusMsg();
    }

    public String getOperationStatusDescription() {
        return this.responseInquiry.getReturnStatus().getStatusDescription();
    }

    public boolean isPaid() {
        return SibsPayAPIService.isPaid(this.responseInquiry.getPaymentStatus());
    }

    public boolean isPending() {
        return SibsPayAPIService.isPending(this.responseInquiry.getPaymentStatus());
    }

    public boolean isDeclined() {
        return SibsPayAPIService.isDeclined(this.responseInquiry.getPaymentStatus());
    }

    public boolean isExpired() {
        return SibsPayAPIService.isExpired(this.responseInquiry.getPaymentStatus());
    }

    public String getRequestLog() {
        return this.requestLog;
    }

    public String getResponseLog() {
        return this.responseLog;
    }
}

