/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayWebhookController$callable$createLog;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotification;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotificationResponse;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotificationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/sibspaywebhook")
public class SibsPayWebhookController {
    private static final Logger logger;
    private static final String NOTIFICATION_URI = "/";
    public static final Advice advice$createLog;

    @POST
    @Path(value="/")
    @Consumes(value={"text/plain"})
    public Response notification(String encryptedBody, @Context HttpServletRequest httpRequest, @Context HttpServletResponse response) {
        PaymentRequestLog log2 = this.createLog();
        String iv = httpRequest.getHeader("X-Initialization-Vector");
        String authTag = httpRequest.getHeader("X-Authentication-Tag");
        FenixFramework.atomic(() -> log2.saveWebhookNotificationData(iv, authTag, encryptedBody));
        Optional<Object> configurationToUseOptional = Optional.empty();
        Optional<Object> webhookNotificationWrapperOptional = Optional.empty();
        try {
            for (SibsPayPlatform configuration : SibsPayPlatform.findAllActive().collect(Collectors.toList())) {
                try {
                    String jsonBody = this.decrypt(configuration.getSecretKey(), iv, authTag, encryptedBody);
                    FenixFramework.atomic(() -> log2.saveRequest(jsonBody));
                    SibsPayWebhookNotification webhookNotificationObj = SibsPayAPIService.deserializeWebhookNotification(jsonBody);
                    if (!StringUtils.isNotEmpty((String)webhookNotificationObj.getNotificationID())) continue;
                    webhookNotificationWrapperOptional = Optional.of(new SibsPayWebhookNotificationWrapper(webhookNotificationObj));
                    configurationToUseOptional = Optional.of(configuration);
                    break;
                }
                catch (UnableToDecryptException jsonBody) {
                }
            }
            if (configurationToUseOptional.isEmpty() || webhookNotificationWrapperOptional.isEmpty()) {
                throw new RuntimeException("the system was not able to decrypt or integration is down");
            }
            SibsPayPlatform configurationToUse = (SibsPayPlatform)configurationToUseOptional.get();
            SibsPayWebhookNotificationWrapper webhookNotificationWrapper = (SibsPayWebhookNotificationWrapper)webhookNotificationWrapperOptional.get();
            FenixFramework.atomic(() -> {
                log2.setExternalTransactionId(webhookNotificationWrapper.getTransactionId());
                log2.setStatusCode(webhookNotificationWrapper.getOperationStatusCode());
                log2.setStatusMessage(webhookNotificationWrapper.getOperationStatusMessage());
                log2.setTransactionWithPayment(webhookNotificationWrapper.isPaid());
                log2.setOperationSuccess(webhookNotificationWrapper.isOperationSuccess());
                log2.savePaymentTypeAndBrand(webhookNotificationWrapper.getPaymentType(), webhookNotificationWrapper.getPaymentBrand());
            });
            Optional<PaymentRequest> paymentRequestOptional = configurationToUse.getPaymentRequestsSet().stream().filter(p -> webhookNotificationWrapper.getTransactionId().equals(p.getTransactionId())).findFirst();
            if (!paymentRequestOptional.isPresent()) {
                return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
            }
            PaymentRequest paymentRequest = paymentRequestOptional.get();
            FenixFramework.atomic(() -> {
                log2.setInternalMerchantTransactionId(paymentRequest.getMerchantTransactionId());
                log2.setPaymentRequest(paymentRequest);
                log2.setStateCode(paymentRequest.getCurrentState().getCode());
                log2.setStateDescription(paymentRequest.getCurrentState().getLocalizedName());
            });
            if (!paymentRequest.isInCreatedState() && !paymentRequest.isInRequestedState()) {
                return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
            }
            if (webhookNotificationWrapper.isPending()) {
                return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
            }
            if (webhookNotificationWrapper.isPaid()) {
                if (paymentRequest instanceof ForwardPaymentRequest) {
                    configurationToUse.processForwardPaymentFromWebhook(log2, webhookNotificationWrapper);
                    return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
                }
                if (paymentRequest instanceof SibsPaymentRequest) {
                    configurationToUse.processPaymentReferenceCodeTransaction(log2, webhookNotificationWrapper);
                    return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
                }
                if (paymentRequest instanceof MbwayRequest) {
                    configurationToUse.processMbwayTransaction(log2, webhookNotificationWrapper);
                    return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
                }
                throw new RuntimeException("unknown payment request type");
            }
            if (webhookNotificationWrapper.isExpired() || webhookNotificationWrapper.isDeclined()) {
                FenixFramework.atomic(() -> configurationToUse.rejectRequest(paymentRequest, log2, webhookNotificationWrapper));
                return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
            }
            return Response.ok((Object)this.response(webhookNotificationWrapper), (String)"application/json").build();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            FenixFramework.atomic(() -> log2.logException(e));
            if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)((Object)e);
                FenixFramework.atomic(() -> {
                    log2.saveRequest(oe.getRequestLog());
                    log2.saveResponse(oe.getResponseLog());
                });
            }
            return Response.serverError().build();
        }
    }

    private SibsPayWebhookNotificationResponse response(SibsPayWebhookNotificationWrapper webhookNotificationWrapper) {
        return new SibsPayWebhookNotificationResponse(200, "Success", webhookNotificationWrapper.getNotificationID());
    }

    private String decrypt(String aesSecretKey, String ivFromHttpHeader, String authTagFromHttpHeader, String encryptedBody) throws UnableToDecryptException {
        byte[] key = Base64.getDecoder().decode(aesSecretKey);
        byte[] iv = Base64.getDecoder().decode(ivFromHttpHeader);
        byte[] authTag = Base64.getDecoder().decode(authTagFromHttpHeader);
        byte[] encryptedText = Base64.getDecoder().decode(encryptedBody);
        byte[] cipherText = ArrayUtils.addAll((byte[])encryptedText, (byte[])authTag);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, 0, 32, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            byte[] bytes = cipher.doFinal(cipherText);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new UnableToDecryptException((Throwable)e);
        }
    }

    private PaymentRequestLog createLog() {
        return (PaymentRequestLog)((Object)advice$createLog.perform((Callable)new SibsPayWebhookController$callable$createLog(this)));
    }

    static /* synthetic */ PaymentRequestLog advised$createLog(SibsPayWebhookController this_) {
        return new PaymentRequestLog("webhookNotification");
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(SibsPayWebhookController.class);
    }

    private class UnableToDecryptException
    extends Exception {
        public UnableToDecryptException(Throwable e) {
            super(e);
        }
    }
}

