/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp;

import java.util.List;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.joda.time.DateTime;

public interface IERPExporter {
    public ERPExportOperation exportFinantialDocumentToIntegration(FinantialInstitution var1, List<FinantialDocument> var2);

    public String exportFinantialDocumentToXML(FinantialInstitution var1, List<FinantialDocument> var2);

    public void checkIntegrationDocumentStatus(FinantialDocument var1);

    public String exportsProductsToXML(FinantialInstitution var1);

    public String exportsCustomersToXML(FinantialInstitution var1);

    public String exportCustomerToXML(DebtAccount var1);

    public ERPExportOperation exportProductsToIntegration(FinantialInstitution var1);

    public ERPExportOperation exportCustomersToIntegration(FinantialInstitution var1);

    public ERPExportOperation exportCustomerToIntegration(DebtAccount var1);

    public void testExportToIntegration(FinantialInstitution var1);

    public void requestPendingDocumentStatus(FinantialInstitution var1);

    public byte[] downloadCertifiedDocumentPrint(FinantialDocument var1);

    public ReimbursementStateBean checkReimbursementState(SettlementNote var1);

    public String saftEncoding();

    public boolean isCustomerWithFinantialDocumentsIntegratedInPreviousERP(Customer var1);

    public boolean isCustomerWithFinantialDocumentsIntegratedInERP(Customer var1);

    public List<FinantialDocument> filterDocumentsToExport(Stream<? extends FinantialDocument> var1);

    public void processReimbursementStateChange(SettlementNote var1, ReimbursementProcessStatusType var2, String var3, DateTime var4);

    public List<FinantialDocument> processCreditNoteSettlementsInclusion(List<FinantialDocument> var1);
}

