/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.math.BigDecimal;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode_Base;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class SibsReferenceCode
extends SibsReferenceCode_Base {
    public SibsReferenceCode() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public SibsReferenceCode(SibsPaymentCodePool sibsPaymentCodePool, String referenceCode, LocalDate validFrom, LocalDate validTo, BigDecimal minAmount, BigDecimal maxAmount) {
        this();
        this.setDigitalPaymentPlatform((DigitalPaymentPlatform)((Object)sibsPaymentCodePool));
        this.setEntityReferenceCode(sibsPaymentCodePool.castToSibsPaymentCodePoolService().getEntityReferenceCode());
        this.setReferenceCode(referenceCode);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
        this.setMinAmount(minAmount);
        this.setMaxAmount(maxAmount);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.SibsReferenceCode.domainRoot.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getReferenceCode())) {
            throw new TreasuryDomainException("error.SibsReferenceCode.referenceCode.required", new String[0]);
        }
        if (this.getValidFrom() == null) {
            throw new TreasuryDomainException("error.SibsReferenceCode.validFrom.required", new String[0]);
        }
        if (this.getValidTo() == null) {
            throw new TreasuryDomainException("error.SibsReferenceCode.validTo.required", new String[0]);
        }
        if (this.getMinAmount() == null) {
            throw new TreasuryDomainException("error.SibsReferenceCode.minAmount.required", new String[0]);
        }
        if (this.getMaxAmount() == null) {
            throw new TreasuryDomainException("error.SibsReferenceCode.maxAmount.required", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(this.getMinAmount(), this.getMaxAmount())) {
            throw new TreasuryDomainException("error.SibsReferenceCode.minAmount.maxAmount.invalid", new String[0]);
        }
    }

    public String getFormattedCode() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (char character : this.getReferenceCode().toCharArray()) {
            result.append(character);
            if (i % 3 == 0) {
                result.append(" ");
            }
            ++i;
        }
        return result.charAt(result.length() - 1) == ' ' ? result.deleteCharAt(result.length() - 1).toString() : result.toString();
    }

    public PaymentReferenceCodeStateType getState() {
        if (this.getSibsPaymentRequest() == null) {
            return PaymentReferenceCodeStateType.UNUSED;
        }
        return this.getSibsPaymentRequest().getState();
    }

    public boolean isInCreatedState() {
        return this.getSibsPaymentRequest() == null || this.getSibsPaymentRequest().isInCreatedState();
    }

    public boolean isInRequestedState() {
        return this.getSibsPaymentRequest() != null && this.getSibsPaymentRequest().isInRequestedState();
    }

    public boolean isInAnnuledState() {
        return this.getSibsPaymentRequest() != null && this.getSibsPaymentRequest().isInAnnuledState();
    }

    public boolean isInPaidState() {
        return this.getSibsPaymentRequest() != null && this.getSibsPaymentRequest().isInPaidState();
    }

    public Interval getValidInterval() {
        DateTime validFromDateTime = this.getValidFrom().toDateTimeAtStartOfDay();
        DateTime validToDateTime = this.getValidTo().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
        return new Interval((ReadableInstant)validFromDateTime, (ReadableInstant)validToDateTime);
    }

    public SibsPaymentCodePool getDigitalPaymentPlatform() {
        return (SibsPaymentCodePool)((Object)super.getDigitalPaymentPlatform());
    }

    public DebtAccount getDebtAccount() {
        if (this.getSibsPaymentRequest() != null) {
            return this.getSibsPaymentRequest().getDebtAccount();
        }
        return null;
    }

    public void delete() {
        if (!this.isDeletable()) {
            throw new RuntimeException("error.SibsReferenceCode.delete.not.possible");
        }
        super.setDomainRoot(null);
        super.setDigitalPaymentPlatform(null);
        super.deleteDomainObject();
    }

    public boolean isDeletable() {
        return this.getSibsPaymentRequest() == null;
    }

    public void changeDates(LocalDate validFrom, LocalDate validTo) {
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
        this.checkRules();
    }

    public static Stream<SibsReferenceCode> findAll() {
        return FenixFramework.getDomainRoot().getSibsReferenceCodesSet().stream();
    }

    public static Stream<SibsReferenceCode> findByReferenceCode(String entityReferenceCode, String referenceCode) {
        return SibsReferenceCode.findAll().filter(p -> entityReferenceCode.equals(p.getEntityReferenceCode())).filter(p -> referenceCode.equals(p.getReferenceCode()));
    }

    public static SibsReferenceCode create(SibsPaymentCodePool sibsPaymentCodePool, String referenceCode, LocalDate validFrom, LocalDate validTo, BigDecimal minAmount, BigDecimal maxAmount) {
        return new SibsReferenceCode(sibsPaymentCodePool, referenceCode, validFrom, validTo, minAmount, maxAmount);
    }
}

