/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.implementations;

import com.google.common.base.Strings;
import com.google.gson.GsonBuilder;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAInvocationUtil;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementationPlatform$callable$postProcessPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementationPlatform$callable$processPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementationPlatform_Base;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class TPAVirtualImplementationPlatform
extends TPAVirtualImplementationPlatform_Base
implements IForwardPaymentPlatformService {
    static final String A030 = "A030";
    static final String TPA_VIRTUAL_ID_FIELD = "A001";
    static final String REFERENCE_CODE_FIELD = "C007";
    static final String CURRENCY_FIELD = "A105";
    static final String AMOUNT_FIELD = "A061";
    static final String PAN_FIELD = "C003";
    static final String EXPIRATION_FIELD = "C004";
    static final String OPERATION_STATUS_FIELD = "C016";
    static final String SECURE_HASH_CODE_FIELD = "C013";
    static final String A037 = "A037";
    public static final String AUTHENTICATION_REQUEST_MESSAGE = "H3D0";
    static final String AUTHENTICATION_RESPONSE_MESSAGE = "MH05";
    static final String C016_AUTHENTICATION_REGISTERED_CODE = "01";
    static final String C016_AUTHORIZATION_ACCEPTED_CODE = "02";
    static final String C016_PAYMENT_ACCEPTED_CODE = "03";
    static final String C016_AUTHORIZATION_CANCELLED = "04";
    static final String C016_UNABLE_TO_CONTACT_HOST_RESPONSE_CODE = "99";
    static final String A038 = "A038";
    static final String A038_SUCCESS = "000";
    static final String M020 = "M020";
    static final String M120 = "M120";
    static final String C016 = "C016";
    static final String C016_POS_RESP = "0X";
    static final String C016_NEG_RESP = "99";
    static final int C016_AUTHENTICATED_STATE = 1;
    static final int C016_AUTHORIZED = 2;
    static final int C016_PAYED = 3;
    static final int C016_AUTHORIZED_CANCELLED = 4;
    static final String C026 = "C026";
    static final String M001 = "M001";
    static final String M101 = "M101";
    static final String M002 = "M002";
    static final String M102 = "M102";
    static final String A077 = "A077";
    static final String A078 = "A078";
    static final String A085 = "A085";
    static final String A086 = "A086";
    public static final String EURO_CODE = "9782";
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TPAVirtualImplementationPlatform() {
    }

    protected TPAVirtualImplementationPlatform(FinantialInstitution finantialInstitution, String name) {
        this();
        super.init(finantialInstitution, name, false);
    }

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest forwardPayment) {
        return IForwardPaymentController.getForwardPaymentController((PaymentRequest)((Object)forwardPayment));
    }

    public boolean processPayment(ForwardPaymentRequest forwardPaymentRequest, Map<String, String> map) {
        return (Boolean)advice$processPayment.perform((Callable)new TPAVirtualImplementationPlatform$callable$processPayment(this, forwardPaymentRequest, map));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ boolean advised$processPayment(TPAVirtualImplementationPlatform this_, ForwardPaymentRequest forwardPayment, Map responseMap) {
        throw new RuntimeException("deprecated");
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest forwardPayment) {
        throw new RuntimeException("deprecated");
    }

    private String errorMessage(Map<String, String> responseData) {
        throw new RuntimeException("deprecated");
    }

    public Map<String, String> mapAuthenticationRequest(ForwardPaymentRequest forwardPayment) {
        TPAInvocationUtil tpa = null;
        return tpa.mapAuthenticationRequest();
    }

    private BigDecimal payedAmount(Map<String, String> responseMap) {
        if (!Strings.isNullOrEmpty((String)responseMap.get(AMOUNT_FIELD))) {
            return new BigDecimal(responseMap.get(AMOUNT_FIELD));
        }
        return null;
    }

    private String transactionId(Map<String, String> responseMap) {
        if (!Strings.isNullOrEmpty((String)responseMap.get(C026))) {
            return responseMap.get(C026);
        }
        return null;
    }

    private DateTime authorizationSibsDate(Map<String, String> responseMap) {
        if (!responseMap.containsKey(A037)) {
            return null;
        }
        return DateTimeFormat.forPattern((String)"YYYYMMddHHmmss").parseDateTime(responseMap.get(A037));
    }

    private boolean isResponseSuccess(Map<String, String> responseMap) {
        if (responseMap.get(A038) == null) {
            return false;
        }
        try {
            return Integer.parseInt(responseMap.get(A038)) == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPaymentStatusSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.get(A030) != null && M120.equals(responseMap.get(A030));
    }

    private boolean isAuthorizationSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.containsKey(A030) && M101.equals(responseMap.get(A030));
    }

    private boolean isPaymentSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.containsKey(A030) && M102.equals(responseMap.get(A030));
    }

    private boolean isAuthenticationResponseMessage(Map<String, String> responseMap) {
        return responseMap.containsKey(A030) && AUTHENTICATION_RESPONSE_MESSAGE.equals(responseMap.get(A030));
    }

    private String responseCode(Map<String, String> responseMap) {
        if (!responseMap.containsKey(A038)) {
            return null;
        }
        return responseMap.get(A038);
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest forwardPayment) {
        throw new RuntimeException("deprecated");
    }

    public String getReturnURL(ForwardPaymentRequest forwardPayment) {
        return String.format("%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), forwardPayment.getExternalId());
    }

    private String json(Object obj) {
        GsonBuilder builder = new GsonBuilder();
        return builder.create().toJson(obj);
    }

    @Override
    public String getLogosJspPage() {
        return "implementations/tpavirtual/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return null;
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPaymentRequest, String string, Optional<String> optional) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new TPAVirtualImplementationPlatform$callable$postProcessPayment(this, forwardPaymentRequest, string, optional));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(TPAVirtualImplementationPlatform this_, ForwardPaymentRequest forwardPayment, String justification, Optional specificTransactionId) {
        throw new TreasuryDomainException("label.ManageForwardPayments.postProcessPayment.not.supported.yet", new String[0]);
    }

    public static final TPAVirtualImplementationPlatform create(FinantialInstitution finantialInstitution, String name) {
        throw new RuntimeException("deprecated");
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        throw new RuntimeException("Not implemented");
    }

    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        throw new RuntimeException("not implemented");
    }
}

