/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry$callable$create;
import org.fenixedu.treasury.domain.document.SettlementEntry$callable$create$1;
import org.fenixedu.treasury.domain.document.SettlementEntry$callable$create$2;
import org.fenixedu.treasury.domain.document.SettlementEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SettlementEntry
extends SettlementEntry_Base {
    public static final Comparator<SettlementEntry> COMPARATOR_BY_ENTRY_DATE_TIME;
    public static final Comparator<SettlementEntry> COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION;
    public static final Comparator<SettlementEntry> COMPARATOR_BY_ENTRY_ORDER;
    public static final Advice advice$create;
    public static final Advice advice$create$1;
    public static final Advice advice$create$2;

    protected SettlementEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCloseDate(new DateTime());
    }

    public void delete() {
        TreasuryDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setInvoiceEntry(null);
        super.delete();
    }

    protected SettlementEntry(InvoiceEntry invoiceEntry, SettlementNote finantialDocument, BigDecimal amount, String description, DateTime entryDateTime, boolean createInterestIfNeeded) {
        this();
        this.init(invoiceEntry, (FinantialDocument)((Object)finantialDocument), amount, description, entryDateTime);
        if (invoiceEntry.isDebitNoteEntry() && TreasuryConstants.isEqual(invoiceEntry.getOpenAmount(), amount) && createInterestIfNeeded) {
            DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
            List<InterestRateBean> undebitedInterestRateBeansList = debitEntry.calculateUndebitedInterestValue(entryDateTime.toLocalDate());
            for (InterestRateBean undebitedInterestValue : undebitedInterestRateBeansList) {
                if (!TreasuryConstants.isPositive(undebitedInterestValue.getInterestAmount())) continue;
                DateTime whenInterestDebitEntryDateTime = undebitedInterestValue.getInterestDebitEntryDateTime() != null ? undebitedInterestValue.getInterestDebitEntryDateTime() : entryDateTime;
                DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), debitEntry.getDebtAccount().getFinantialInstitution()).filter(x -> Boolean.TRUE.equals(x.getSeries().getDefaultSeries())).findFirst().orElse(null);
                DebitNote interestDebitNote = DebitNote.create(debitEntry.getDebtAccount(), debitNoteSeries, new DateTime());
                interestDebitNote.setPayorDebtAccount(debitEntry.getDebitNote().getPayorDebtAccount());
                debitEntry.createInterestRateDebitEntry(undebitedInterestValue, whenInterestDebitEntryDateTime, interestDebitNote);
            }
        }
    }

    protected void init(DebtAccount debtAccount, FinantialDocument finantialDocument, FinantialEntryType finantialEntryType, BigDecimal amount, String description, DateTime entryDateTime) {
        throw new RuntimeException("error.SettlementEntry.use.init.without.finantialEntryType");
    }

    protected void init(InvoiceEntry invoiceEntry, FinantialDocument finantialDocument, BigDecimal amount, String description, DateTime entryDateTime) {
        super.init(finantialDocument.getDebtAccount(), finantialDocument, FinantialEntryType.SETTLEMENT_ENTRY, amount, description, entryDateTime);
        this.setInvoiceEntry(invoiceEntry);
        this.setFinantialEntity(invoiceEntry.getFinantialEntity());
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (!(this.getFinantialDocument() instanceof SettlementNote)) {
            throw new TreasuryDomainException("error.SettlementEntry.finantialDocument.not.settlement.note.type", new String[0]);
        }
        if (this.getInvoiceEntry().isCreditNoteEntry() && !TreasuryConstants.isEqual(this.getAmount(), this.getTotalAmount())) {
            throw new TreasuryDomainException("error.SettlementEntry.creditNoteEntry.total.amount.not.equal", new String[0]);
        }
        if (!TreasuryConstants.isPositive(this.getAmount())) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.amount.less.than.zero", new String[0]);
        }
    }

    public BigDecimal getTotalAmount() {
        return this.getAmount();
    }

    @Deprecated
    public BigDecimal getNetAmount() {
        return this.getAmount();
    }

    public BigDecimal getUiAmount() {
        if (this.getInvoiceEntry().isCreditNoteEntry() && Boolean.TRUE.equals(TreasurySettings.getInstance().getDisplayNegativeAmountsForCreditEntries())) {
            return this.getAmount().negate();
        }
        return this.getAmount();
    }

    public BigDecimal getUiTotalAmount() {
        if (this.getInvoiceEntry().isCreditNoteEntry() && Boolean.TRUE.equals(TreasurySettings.getInstance().getDisplayNegativeAmountsForCreditEntries())) {
            return this.getTotalAmount().negate();
        }
        return this.getTotalAmount();
    }

    public String getInvoiceEntryAmountSignal() {
        if (this.getInvoiceEntry().isDebitNoteEntry()) {
            return "";
        }
        return "-";
    }

    public SettlementNote getSettlementNote() {
        return (SettlementNote)((Object)this.getFinantialDocument());
    }

    public Set<InstallmentSettlementEntry> getSortedInstallmentSettlementEntries() {
        TreeSet result = new TreeSet((o1, o2) -> InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR.compare(o1.getInstallmentEntry(), o2.getInstallmentEntry()));
        return super.getInstallmentSettlementEntriesSet().stream().collect(Collectors.toCollection(() -> result));
    }

    public static Stream<SettlementEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof SettlementEntry).map(SettlementEntry.class::cast);
    }

    public static SettlementEntry create(InvoiceEntry invoiceEntry, SettlementNote settlementNote, BigDecimal bigDecimal, String string, DateTime dateTime, boolean bl) {
        return (SettlementEntry)((Object)advice$create.perform((Callable)new SettlementEntry$callable$create(invoiceEntry, settlementNote, bigDecimal, string, dateTime, bl)));
    }

    static /* synthetic */ SettlementEntry advised$create(InvoiceEntry invoiceEntry, SettlementNote finantialDocument, BigDecimal amount, String description, DateTime entryDateTime, boolean createInterestIfNeeded) {
        return new SettlementEntry(invoiceEntry, finantialDocument, amount, description, entryDateTime, createInterestIfNeeded);
    }

    public static SettlementEntry create(DebitEntry debitEntry, BigDecimal bigDecimal, SettlementNote settlementNote, DateTime dateTime) {
        return (SettlementEntry)((Object)advice$create$1.perform((Callable)new SettlementEntry$callable$create$1(debitEntry, bigDecimal, settlementNote, dateTime)));
    }

    static /* synthetic */ SettlementEntry advised$create(DebitEntry debitEntry, BigDecimal debtAmount, SettlementNote settlementNote, DateTime entryDate) {
        boolean createInterestIfNeeded = true;
        if (TreasuryDebtProcessMainService.isInterestCreationWhenTotalSettledPrevented((InvoiceEntry)((Object)debitEntry))) {
            createInterestIfNeeded = false;
        }
        return new SettlementEntry((InvoiceEntry)((Object)debitEntry), settlementNote, debtAmount, debitEntry.getDescription(), entryDate, createInterestIfNeeded);
    }

    public static SettlementEntry create(CreditEntry creditEntry, BigDecimal bigDecimal, String string, SettlementNote settlementNote, DateTime dateTime) {
        return (SettlementEntry)((Object)advice$create$2.perform((Callable)new SettlementEntry$callable$create$2(creditEntry, bigDecimal, string, settlementNote, dateTime)));
    }

    static /* synthetic */ SettlementEntry advised$create(CreditEntry creditEntry, BigDecimal creditAmount, String creditDescription, SettlementNote settlementNote, DateTime entryDate) {
        return new SettlementEntry((InvoiceEntry)((Object)creditEntry), settlementNote, creditAmount, creditDescription, entryDate, false);
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_ENTRY_DATE_TIME = (o1, o2) -> {
            int c = o1.getEntryDateTime().compareTo((ReadableInstant)o2.getEntryDateTime());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION = (o1, o2) -> {
            if (o1.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() != 0 && o2.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() != 0) {
                int c1 = Integer.compare(o1.getInvoiceEntry().getProduct().getTuitionInstallmentOrder(), o2.getInvoiceEntry().getProduct().getTuitionInstallmentOrder());
                return c1 != 0 ? c1 : o1.getExternalId().compareTo(o2.getExternalId());
            }
            if (o1.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() != 0 && o2.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() == 0) {
                return -1;
            }
            if (o1.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() == 0 && o2.getInvoiceEntry().getProduct().getTuitionInstallmentOrder() != 0) {
                return 1;
            }
            int c2 = o1.getDescription().compareTo(o2.getDescription());
            return c2 != 0 ? c2 : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_ENTRY_ORDER = (o1, o2) -> {
            if (o1.getEntryOrder() == null || o2.getEntryOrder() == null) {
                throw new RuntimeException("error");
            }
            int c = o1.getEntryOrder().compareTo(o2.getEntryOrder());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

