/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public abstract class InvoiceEntry
extends InvoiceEntry_Base {
    public static final int UNIT_PRICE_SCALE = 4;
    public static final Comparator<InvoiceEntry> COMPARE_BY_DUE_DATE = (o1, o2) -> {
        int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
        return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
    };
    public static final Comparator<InvoiceEntry> COMPARE_BY_ENTRY_DATE = (o1, o2) -> {
        int c = o1.getEntryDateTime().compareTo((ReadableInstant)o2.getEntryDateTime());
        return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
    };
    public static final Comparator<InvoiceEntry> COMPARE_BY_AMOUNT_AND_DUE_DATE = (o1, o2) -> {
        int c = -o1.getOpenAmount().compareTo(o2.getOpenAmount());
        if (c != 0) {
            return c;
        }
        c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
        if (c != 0) {
            return c;
        }
        return o1.getExternalId().compareTo(o2.getExternalId());
    };
    public static final Comparator<InvoiceEntry> COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION = (o1, o2) -> {
        if (o1.getProduct().getTuitionInstallmentOrder() != 0 && o2.getProduct().getTuitionInstallmentOrder() != 0) {
            int c1 = Integer.compare(o1.getProduct().getTuitionInstallmentOrder(), o2.getProduct().getTuitionInstallmentOrder());
            return c1 != 0 ? c1 : o1.getExternalId().compareTo(o2.getExternalId());
        }
        if (o1.getProduct().getTuitionInstallmentOrder() != 0 && o2.getProduct().getTuitionInstallmentOrder() == 0) {
            return -1;
        }
        if (o1.getProduct().getTuitionInstallmentOrder() == 0 && o2.getProduct().getTuitionInstallmentOrder() != 0) {
            return 1;
        }
        int c2 = o1.getDescription().compareTo(o2.getDescription());
        return c2 != 0 ? c2 : o1.getExternalId().compareTo(o2.getExternalId());
    };
    public static final Comparator<InvoiceEntry> COMPARATOR_BY_ENTRY_ORDER_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION = (o1, o2) -> {
        if (o1.getEntryOrder() != null && o2.getEntryOrder() != null) {
            int c = o1.getEntryOrder().compareTo(o2.getEntryOrder());
            if (c != 0) {
                return c;
            }
        } else {
            if (o1.getEntryOrder() != null && o2.getEntryOrder() == null) {
                return -1;
            }
            if (o1.getEntryOrder() == null && o2.getEntryOrder() != null) {
                return 1;
            }
        }
        return COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION.compare((InvoiceEntry)((Object)o1), (InvoiceEntry)((Object)o2));
    };
    public static final int MAX_DESCRIPTION_LENGTH = 200;

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getFinantialDocument() != null && !this.getFinantialDocument().isPreparing()) {
            blockers.add(TreasuryConstants.treasuryBundle("error.invoiceentry.cannot.be.deleted.document.is.not.preparing", new String[0]));
        }
        if (!this.getSettlementEntriesSet().isEmpty()) {
            blockers.add(TreasuryConstants.treasuryBundle("error.invoiceentry.cannot.be.deleted.settlemententries.is.not.empty", new String[0]));
        }
    }

    public boolean isDebitNoteEntry() {
        return false;
    }

    public boolean isCreditNoteEntry() {
        return false;
    }

    public boolean isProcessedInDebitNote() {
        return this.getFinantialDocument() != null;
    }

    public boolean isProcessedInClosedDebitNote() {
        return this.isProcessedInDebitNote() && this.getFinantialDocument().isClosed();
    }

    public void delete() {
        TreasuryDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setCurrency(null);
        this.setDebtAccount(null);
        this.setVat(null);
        this.setProduct(null);
        super.delete();
    }

    protected void init(DebtAccount debtAccount, FinantialDocument finantialDocument, FinantialEntryType finantialEntryType, BigDecimal amount, String description, DateTime entryDateTime) {
        throw new RuntimeException("error.InvoiceEntry.use.init.with.product");
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal unitAmount, String description, BigDecimal quantity, DateTime entryDateTime) {
        super.init(debtAccount, finantialDocument, finantialEntryType, unitAmount, description, entryDateTime);
        if (debtAccount.getClosed()) {
            throw new TreasuryDomainException("error.InvoiceEntry.debtAccount.closed", new String[0]);
        }
        this.setCalculatedAmountsOverriden(false);
        this.setQuantity(quantity);
        this.setNetExemptedAmount(BigDecimal.ZERO);
        this.setCurrency(debtAccount.getFinantialInstitution().getCurrency());
        this.setDebtAccount(debtAccount);
        this.setProduct(product);
        this.setVat(vat);
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getQuantity() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.quantity.required", new String[0]);
        }
        if (this.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.quantity.less.than.zero", new String[0]);
        }
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof Invoice)) {
            throw new TreasuryDomainException("error.InvoiceEntry.finantialDocument.not.invoice.type", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.product.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.debtAccount.required", new String[0]);
        }
        if (this.getCurrency() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.currency.required", new String[0]);
        }
        if (this.getVat() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.vat.required", new String[0]);
        }
        if (this.getFinantialDocument() != null && this.getFinantialDocument().getDebtAccount() != this.getDebtAccount()) {
            throw new TreasuryDomainException("error.InvoiceEntry.invalidDebtAccount", new String[0]);
        }
        if (!this.checkAmountValues()) {
            throw new TreasuryDomainException("error.InvoiceEntry.amount.invalid.consistency", new String[0]);
        }
    }

    protected boolean checkAmountValues() {
        if (this.getNetAmount() != null && this.getVatAmount() != null && this.getAmountWithVat() != null) {
            BigDecimal netAmount = this.calculateNetAmount();
            this.getCurrency();
            BigDecimal vatAmount = Currency.getValueWithScale(this.getNetAmount().multiply(TreasuryConstants.rationalVatRate(this)));
            this.getCurrency();
            BigDecimal amountWithVat = Currency.getValueWithScale(this.getNetAmount().multiply(BigDecimal.ONE.add(TreasuryConstants.rationalVatRate(this))));
            return netAmount.compareTo(this.getNetAmount()) == 0 && vatAmount.compareTo(this.getVatAmount()) == 0 && amountWithVat.compareTo(this.getTotalAmount()) == 0;
        }
        return true;
    }

    protected void recalculateAmountValues() {
        if (this.getVatRate() == null) {
            this.setVatRate(super.getVat().getTaxRate());
        }
        BigDecimal netAmount = this.calculateNetAmount();
        this.setNetAmount(netAmount);
        BigDecimal rationalVatRate = TreasuryConstants.rationalVatRate(this);
        BigDecimal vatAmount = Currency.getValueWithScale(netAmount.multiply(rationalVatRate));
        BigDecimal amountWithVat = netAmount.add(vatAmount);
        this.setVatAmount(vatAmount);
        this.setAmountWithVat(Currency.getValueWithScale(amountWithVat));
        if (this.getNetAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netAmount has scale above the currency decimal places for cents");
        }
        if (this.getVatAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The vatAmount has scale above the currency decimal places for cents");
        }
        if (this.getAmountWithVat().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The amountWithVat has scale above the currency decimal places for cents");
        }
    }

    protected BigDecimal calculateNetAmount() {
        BigDecimal netAmount = Currency.getValueWithScale(this.getQuantity().multiply(this.getAmount()));
        return netAmount;
    }

    public static Stream<? extends InvoiceEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof InvoiceEntry).map(InvoiceEntry.class::cast);
    }

    public boolean isPendingForPayment() {
        if (this.getFinantialDocument() != null && this.getFinantialDocument().getState().isAnnuled()) {
            return false;
        }
        return this.getOpenAmount().compareTo(BigDecimal.ZERO) != 0;
    }

    public boolean hasPreparingSettlementEntries() {
        return this.getSettlementEntriesSet().stream().anyMatch(se -> se.getFinantialDocument().isPreparing());
    }

    public BigDecimal getTotalAmount() {
        return this.getAmountWithVat();
    }

    public BigDecimal getPayedAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlementEntriesSet()) {
            if (entry.getFinantialDocument() == null || !entry.getFinantialDocument().isClosed()) continue;
            amount = amount.add(entry.getTotalAmount());
        }
        return amount;
    }

    public BigDecimal getOpenAmount() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal openAmount = this.getAmountWithVat().subtract(this.getPayedAmount());
        this.getCurrency();
        return Currency.getValueWithScale(this.isPositive(openAmount) ? openAmount : BigDecimal.ZERO);
    }

    public void overrideCalculatedAmounts(BigDecimal netAmount, BigDecimal vatRate, BigDecimal vatAmount, BigDecimal amountWithVat) {
        this.setCalculatedAmountsOverriden(true);
        if (!TreasuryConstants.isPositive(netAmount)) {
            throw new TreasuryDomainException("error.DebitEntry.overrideCalculatedAmounts.invalid.netAmount", new String[0]);
        }
        if (TreasuryConstants.isLessThan(vatRate, BigDecimal.ZERO) || TreasuryConstants.isGreaterThan(vatRate, TreasuryConstants.HUNDRED_PERCENT)) {
            throw new TreasuryDomainException("error.DebitEntry.overrideCalculatedAmounts.invalid.vatRate", new String[0]);
        }
        if (TreasuryConstants.isNegative(vatAmount)) {
            throw new TreasuryDomainException("error.DebitEntry.overrideCalculatedAmounts.invalid.vatAmount", new String[0]);
        }
        if (!TreasuryConstants.isPositive(amountWithVat)) {
            throw new TreasuryDomainException("error.DebitEntry.overrideCalculatedAmounts.invalid.amountWithVat", new String[0]);
        }
        this.setNetAmount(netAmount);
        this.setVatRate(vatRate);
        this.setVatAmount(vatAmount);
        this.setAmountWithVat(amountWithVat);
        if (this.getNetAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netAmount has scale above the currency decimal places for cents");
        }
        if (this.getVatAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The vatAmount has scale above the currency decimal places for cents");
        }
        if (this.getAmountWithVat().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The amountWithVat has scale above the currency decimal places for cents");
        }
    }

    public void disableOverrideCalculatedAmounts() {
        this.setCalculatedAmountsOverriden(false);
        this.recalculateAmountValues();
    }

    public abstract BigDecimal getOpenAmountWithInterests();

    public abstract LocalDate getDueDate();

    public BigDecimal openAmountAtDate(DateTime when) {
        Currency currency = this.getDebtAccount().getFinantialInstitution().getCurrency();
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal openAmount = this.getAmountWithVat().subtract(this.payedAmountAtDate(when));
        return Currency.getValueWithScale(this.isPositive(openAmount) ? openAmount : BigDecimal.ZERO);
    }

    public BigDecimal payedAmountAtDate(DateTime when) {
        BigDecimal amount = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlementEntriesSet()) {
            if (entry.getEntryDateTime().isAfter((ReadableInstant)when) || entry.getFinantialDocument() == null || !entry.getFinantialDocument().isClosed()) continue;
            amount = amount.add(entry.getTotalAmount());
        }
        return amount;
    }

    @Deprecated
    public void addPaymentCodes(MultipleEntriesPaymentCode paymentCodes) {
        super.addPaymentCodes(paymentCodes);
    }

    @Deprecated
    public void removePaymentCodes(MultipleEntriesPaymentCode paymentCodes) {
        super.removePaymentCodes(paymentCodes);
    }

    @Deprecated
    public Set<MultipleEntriesPaymentCode> getPaymentCodesSet() {
        return super.getPaymentCodesSet();
    }

    @Deprecated
    public void addMbwayPaymentRequests(MbwayPaymentRequest mbwayPaymentRequests) {
        super.addMbwayPaymentRequests(mbwayPaymentRequests);
    }

    @Deprecated
    public void removeMbwayPaymentRequests(MbwayPaymentRequest mbwayPaymentRequests) {
        super.removeMbwayPaymentRequests(mbwayPaymentRequests);
    }

    @Deprecated
    public Set<MbwayPaymentRequest> getMbwayPaymentRequestsSet() {
        return super.getMbwayPaymentRequestsSet();
    }

    public BigDecimal getUiTotalAmount() {
        return this.getTotalAmount();
    }

    public BigDecimal getUiOpenAmount() {
        return this.getOpenAmount();
    }

    public BigDecimal getUiOpenAmountWithInterests() {
        return this.getOpenAmountWithInterests();
    }
}

