/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$clearDocumentToExport;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$clearDocumentToExportAndSaveERPCertificationData;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$closeDocument;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$closeDocument$1;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$delete;
import org.fenixedu.treasury.domain.document.FinantialDocument$callable$markDocumentToExport;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocument_Base;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.integration.ERPImportOperation;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class FinantialDocument
extends FinantialDocument_Base {
    protected static final Comparator<FinantialDocument> COMPARE_BY_DOCUMENT_DATE;
    protected static final Comparator<String> COMPARE_BY_DOCUMENT_NUMBER_STRING;
    protected static final Comparator<FinantialDocument> COMPARE_BY_DOCUMENT_NUMBER;
    public static final Advice advice$closeDocument;
    public static final Advice advice$closeDocument$1;
    public static final Advice advice$markDocumentToExport;
    public static final Advice advice$clearDocumentToExport;
    public static final Advice advice$clearDocumentToExportAndSaveERPCertificationData;
    public static final Advice advice$delete;

    protected FinantialDocument() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setState(FinantialDocumentStateType.PREPARING);
    }

    protected void init(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        this.setDebtAccount(debtAccount);
        this.setFinantialDocumentType(documentNumberSeries.getFinantialDocumentType());
        this.setDocumentNumberSeries(documentNumberSeries);
        this.setDocumentNumber("000000000");
        this.setDocumentDate(documentDate);
        this.setDocumentDueDate(documentDate.toLocalDate());
        this.setCurrency(debtAccount.getFinantialInstitution().getCurrency());
        this.setState(FinantialDocumentStateType.PREPARING);
        this.setAddress(debtAccount.getCustomer().getAddress());
        super.setCode(String.format("FF-%s-FD-%d", debtAccount.getCustomer().getCode(), debtAccount.getCustomer().nextFinantialDocumentNumber()));
        this.checkRules();
    }

    protected void checkRules() {
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.debtAccount.required", new String[0]);
        }
        if (this.getFinantialDocumentType() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.finantialDocumentType.required", new String[0]);
        }
        if (this.getDocumentNumberSeries() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.documentNumber.required", new String[0]);
        }
        if (this.getDocumentDate() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.documentDate.required", new String[0]);
        }
        if (this.getDocumentDueDate() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.documentDueDate.required", new String[0]);
        }
        if (this.getCurrency() == null) {
            throw new TreasuryDomainException("error.FinantialDocument.currency.required", new String[0]);
        }
        if (!this.getDocumentNumberSeries().getSeries().getFinantialInstitution().equals((Object)this.getDebtAccount().getFinantialInstitution())) {
            throw new TreasuryDomainException("error.FinantialDocument.finantialinstitution.mismatch", new String[0]);
        }
        if (!this.getDocumentNumberSeries().getSeries().getLegacy() && this.getDocumentDueDate().isBefore((ReadablePartial)this.getDocumentDate().toLocalDate())) {
            throw new TreasuryDomainException("error.FinantialDocument.documentDueDate.invalid", new String[0]);
        }
        if (this.isClosed() && this.isDocumentEmpty()) {
            throw new TreasuryDomainException("error.FinantialDocument.closed.but.empty.entries", new String[0]);
        }
        if (!this.isClosed() || this.getDocumentNumberSeries().getSeries().getCertificated()) {
            // empty if block
        }
        if (this.getDocumentDate().isAfterNow()) {
            throw new TreasuryDomainException("error.FinantialDocument.documentDate.cannot.be.after.now", new String[0]);
        }
        if (!Strings.isNullOrEmpty((String)this.getOriginDocumentNumber()) && !TreasuryConstants.isOriginDocumentNumberValid(this.getOriginDocumentNumber())) {
            throw new TreasuryDomainException("error.FinantialDocument.originDocumentNumber.invalid", new String[0]);
        }
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            if (!(entry instanceof InvoiceEntry) || ((InvoiceEntry)((Object)entry)).getDebtAccount() == this.getDebtAccount()) continue;
            throw new TreasuryDomainException("error.FinantialDocument.entries.belongs.different.debt.account", new String[0]);
        }
    }

    protected boolean isDocumentEmpty() {
        return this.getFinantialDocumentEntriesSet().isEmpty();
    }

    public String getUiDocumentNumber() {
        return String.format("%s %s/%s", this.getDocumentNumberSeries().documentNumberSeriesPrefix(), this.getDocumentNumberSeries().getSeries().getCode(), Strings.padStart((String)this.getDocumentNumber(), (int)7, (char)'0'));
    }

    public BigDecimal getTotalAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            amount = amount.add(entry.getTotalAmount());
        }
        this.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }

    public String getUiTotalAmount() {
        return this.getDebtAccount().getFinantialInstitution().getCurrency().getValueFor(this.getTotalAmount());
    }

    public BigDecimal getTotalNetAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            amount = amount.add(entry.getNetAmount());
        }
        this.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }

    public String getUiTotalNetAmount() {
        return this.getDebtAccount().getFinantialInstitution().getCurrency().getValueFor(this.getTotalNetAmount());
    }

    public boolean isClosed() {
        return this.getState().isClosed();
    }

    public boolean isInvoice() {
        return false;
    }

    public boolean isDebitNote() {
        return false;
    }

    public boolean isCreditNote() {
        return false;
    }

    public boolean isSettlementNote() {
        return false;
    }

    public boolean isDeletable() {
        return this.isPreparing() && this.getPaymentCodesSet().isEmpty();
    }

    public boolean isAnnulled() {
        return this.getState().equals((Object)FinantialDocumentStateType.ANNULED);
    }

    public boolean isPreparing() {
        return this.getState().equals((Object)FinantialDocumentStateType.PREPARING);
    }

    public Map<String, String> getPropertiesMap() {
        return TreasuryConstants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public void editPropertiesMap(Map<String, String> propertiesMap) {
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
    }

    public final void closeDocument() {
        Object object = advice$closeDocument.perform((Callable)new FinantialDocument$callable$closeDocument(this));
    }

    static final /* synthetic */ void advised$closeDocument(FinantialDocument this_) {
        this_.closeDocument(true);
    }

    public abstract Comparator<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderComparator();

    public abstract List<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription();

    public void closeDocument(boolean bl) {
        Object object = advice$closeDocument$1.perform((Callable)new FinantialDocument$callable$closeDocument$1(this, bl));
    }

    static /* synthetic */ void advised$closeDocument(FinantialDocument this_, boolean markDocumentToExport2) {
        if (this_.isPreparing()) {
            this_.setDocumentNumber("" + this_.getDocumentNumberSeries().getSequenceNumberAndIncrement());
            this_.orderInvoiceEntries();
            this_.setState(FinantialDocumentStateType.CLOSED);
            this_.setAddress(this_.getDebtAccount().getCustomer().getAddress() + this_.getDebtAccount().getCustomer().getZipCode());
            if (markDocumentToExport2) {
                this_.markDocumentToExport();
            }
        } else {
            throw new TreasuryDomainException("error.FinantialDocumentState.invalid.state.change.request", new String[0]);
        }
        if (this_.getCloseDate() == null) {
            this_.setCloseDate(new DateTime());
        }
        this_.checkRules();
    }

    public void orderInvoiceEntries() {
        if (!this.isPreparing()) {
            throw new TreasuryDomainException("error.FinantialDocument.orderInvoiceEntries.document.not.preparing", new String[0]);
        }
        List<? extends FinantialDocumentEntry> orderedEntries = this.getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription();
        int order = 1;
        for (FinantialDocumentEntry finantialDocumentEntry : orderedEntries) {
            finantialDocumentEntry.setEntryOrder(order);
            ++order;
        }
    }

    public void markDocumentToExport() {
        Object object = advice$markDocumentToExport.perform((Callable)new FinantialDocument$callable$markDocumentToExport(this));
    }

    static /* synthetic */ void advised$markDocumentToExport(FinantialDocument this_) {
        if (this_.getInstitutionForExportation() == null) {
            this_.setInstitutionForExportation(this_.getDocumentNumberSeries().getSeries().getFinantialInstitution());
        }
        if (this_.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration().getActive()) {
            ERPExporterManager.scheduleSingleDocument(this_);
        }
    }

    public void clearDocumentToExport(String string) {
        Object object = advice$clearDocumentToExport.perform((Callable)new FinantialDocument$callable$clearDocumentToExport(this, string));
    }

    static /* synthetic */ void advised$clearDocumentToExport(FinantialDocument this_, String reason) {
        if (this_.getInstitutionForExportation() != null) {
            this_.setInstitutionForExportation(null);
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            String username = StringUtils.isNotEmpty((String)loggedUsername) ? loggedUsername : "unknown";
            DateTime now = new DateTime();
            super.setClearDocumentToExportReason(String.format("%s - [%s] %s", reason, username, now.toString("YYYY-MM-dd HH:mm:ss")));
            super.setClearDocumentToExportDate(now);
        }
    }

    public void clearDocumentToExportAndSaveERPCertificationData(String string, LocalDate localDate, String string2) {
        Object object = advice$clearDocumentToExportAndSaveERPCertificationData.perform((Callable)new FinantialDocument$callable$clearDocumentToExportAndSaveERPCertificationData(this, string, localDate, string2));
    }

    static /* synthetic */ void advised$clearDocumentToExportAndSaveERPCertificationData(FinantialDocument this_, String reason, LocalDate erpCertificationDate, String erpCertificateDocumentReference) {
        if (this_.getInstitutionForExportation() != null) {
            this_.setInstitutionForExportation(null);
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            String username = StringUtils.isNotEmpty((String)loggedUsername) ? loggedUsername : "unknown";
            DateTime now = new DateTime();
            super.setClearDocumentToExportReason(String.format("%s - [%s] %s", reason, username, now.toString("YYYY-MM-dd HH:mm:ss")));
            super.setClearDocumentToExportDate(now);
            this_.editERPCertificationData(erpCertificationDate, erpCertificateDocumentReference);
        }
    }

    private void editERPCertificationData(LocalDate erpCertificationDate, String erpCertificateDocumentReference) {
        if (erpCertificationDate == null) {
            throw new TreasuryDomainException("error.FinantialDocument.erpCertificationDate.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)erpCertificateDocumentReference)) {
            throw new TreasuryDomainException("error.FinantialDocument.erpCertificateDocumentReference.required", new String[0]);
        }
        this.setErpCertificationDate(erpCertificationDate);
        this.setErpCertificateDocumentReference(erpCertificateDocumentReference);
    }

    public boolean isDocumentToExport() {
        return this.getInstitutionForExportation() != null;
    }

    public boolean isExportedInLegacyERP() {
        return this.getExportedInLegacyERP();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new FinantialDocument$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(FinantialDocument this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FinantialDocument.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setDocumentNumberSeries(null);
        this_.setCurrency(null);
        this_.setDebtAccount(null);
        this_.setFinantialDocumentType(null);
        this_.setInstitutionForExportation(null);
        for (FinantialDocumentEntry entry : this_.getFinantialDocumentEntriesSet()) {
            this_.removeFinantialDocumentEntries(entry);
            if (deleteEntries) {
                entry.delete();
                continue;
            }
            entry.setFinantialDocument(null);
        }
        for (Object oper : this_.getErpExportOperationsSet()) {
            this_.removeErpExportOperations((ERPExportOperation)((Object)oper));
            ((ERPExportOperation)((Object)oper)).delete();
        }
        for (Object oper : this_.getErpImportOperationsSet()) {
            this_.removeErpImportOperations((ERPImportOperation)((Object)oper));
            ((ERPImportOperation)((Object)oper)).delete();
        }
        this_.deleteDomainObject();
    }

    public abstract Set<FinantialDocument> findRelatedDocuments(Set<FinantialDocument> var1, Boolean var2);

    public Boolean getClosed() {
        return this.getState().equals((Object)FinantialDocumentStateType.CLOSED);
    }

    public BigDecimal getOpenAmount() {
        if (this.getState().isPreparing() || this.getState().isClosed()) {
            return this.getTotalAmount();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getOpenAmountWithInterests() {
        if (this.getState().isPreparing() || this.getState().isClosed()) {
            return this.getTotalAmount();
        }
        return BigDecimal.ZERO;
    }

    public boolean isDocumentSeriesNumberSet() {
        return Long.parseLong(this.getDocumentNumber()) != 0L;
    }

    public boolean isCertifiedPrintedDocumentAvailable() {
        if (!this.isClosed()) {
            return false;
        }
        if (this.isExportedInLegacyERP()) {
            return false;
        }
        if (this.isDocumentToExport()) {
            return false;
        }
        if (this.isSettlementNote() && ((SettlementNote)((Object)this)).isReimbursement()) {
            return false;
        }
        if (this.getDocumentNumberSeries().getSeries().isRegulationSeries()) {
            return false;
        }
        return !this.isCreditNote() || !((CreditNote)((Object)this)).isAdvancePayment();
    }

    public Optional<ERPExportOperation> getLastERPExportOperation() {
        if (this.getErpExportOperationsSet().isEmpty()) {
            return Optional.empty();
        }
        return this.getErpExportOperationsSet().stream().sorted(ERPExportOperation.COMPARE_BY_VERSIONING_CREATION_DATE.reversed()).findFirst();
    }

    public String getUiLastERPExportationErrorMessage() {
        try {
            Optional<ERPExportOperation> lastERPExportOperation = this.getLastERPExportOperation();
            if (!lastERPExportOperation.isPresent()) {
                return "";
            }
            if (lastERPExportOperation.get().getSuccess()) {
                return "";
            }
            String[] lines = lastERPExportOperation.get().getErrorLog().replaceAll("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z", "").split("\n");
            if (lines.length > 0) {
                return lines[0].trim();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public void updateOverrideCertificationDateWithCloseDate(boolean overrideCertificationDateWithCloseDate, DateTime closeDate) {
        super.setOverrideCertificationDateWithCloseDate(Boolean.valueOf(overrideCertificationDateWithCloseDate));
        super.setCloseDate(closeDate);
    }

    public static Stream<? extends FinantialDocument> findAll() {
        return FenixFramework.getDomainRoot().getFinantialDocumentsSet().stream();
    }

    public static Stream<? extends FinantialDocument> find(FinantialDocumentType finantialDocumentType) {
        return finantialDocumentType.getFinantialDocumentsSet().stream();
    }

    public static Stream<? extends FinantialDocument> find(DocumentNumberSeries documentNumberSeries) {
        return documentNumberSeries.getFinantialDocumentsSet().stream();
    }

    public static Optional<? extends FinantialDocument> findUniqueByDocumentNumber(String documentNumber) {
        return FinantialDocument.findAll().filter(x -> documentNumber.equals(x.getUiDocumentNumber())).findFirst();
    }

    protected static Stream<? extends FinantialDocument> findClosedUntilDocumentNumberExclusive(DocumentNumberSeries documentNumberSeries, String documentNumber) {
        return FinantialDocument.find(documentNumberSeries).filter(d -> d.isClosed() && COMPARE_BY_DOCUMENT_NUMBER_STRING.compare(d.getDocumentNumber(), documentNumber) < 0);
    }

    public static FinantialDocument findByUiDocumentNumber(FinantialInstitution finantialInstitution, String docNumber) {
        block9: {
            if (finantialInstitution == null || Strings.isNullOrEmpty((String)docNumber)) {
                return null;
            }
            try {
                List values = Splitter.on((char)' ').splitToList((CharSequence)docNumber);
                List values2 = Splitter.on((char)'/').splitToList((CharSequence)values.get(1));
                String documentType = (String)values.get(0);
                String seriesNumber = (String)values2.get(0);
                FinantialDocumentType type = FinantialDocumentType.findByCode(documentType);
                if (type != null) {
                    DocumentNumberSeries dns;
                    Series series = Series.findByCode(finantialInstitution, seriesNumber);
                    if (series != null && (dns = DocumentNumberSeries.find(type, series)) != null) {
                        return dns.getFinantialDocumentsSet().stream().filter(x -> x.getUiDocumentNumber().equals(docNumber)).findFirst().orElse(null);
                    }
                    break block9;
                }
                Set docs = FinantialDocument.findAll().filter(d -> d.getDebtAccount().getFinantialInstitution() == finantialInstitution).filter(d -> d.getUiDocumentNumber().equals(docNumber)).collect(Collectors.toSet());
                if (docs.isEmpty()) {
                    return null;
                }
                if (docs.size() > 1) {
                    throw new TreasuryDomainException("error.FinantialDocument.findByUiDocumentNumber.found.more.than.one", new String[0]);
                }
                FinantialDocument finantialDocument = (FinantialDocument)((Object)docs.iterator().next());
                if (!finantialDocument.getDocumentNumberSeries().isReplacePrefix()) {
                    throw new TreasuryDomainException("error.FinantialDocument.findByUiDocumentNumber.not.from.replacing.prefix", new String[0]);
                }
                if (!documentType.equals(finantialDocument.getDocumentNumberSeries().getReplacingPrefix())) {
                    throw new TreasuryDomainException("error.FinantialDocument.findByUiDocumentNumber.documentType.not.equal", new String[0]);
                }
                return finantialDocument;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCode(String code) {
        super.setCode(code);
    }

    public static Stream<FinantialDocument> findByCode(String code) {
        return FenixFramework.getDomainRoot().getFinantialDocumentsSet().stream().filter(document -> document.getCode() != null && document.getCode().equals(code));
    }

    public static Optional<FinantialDocument> findUniqueByCode(String code) {
        return FinantialDocument.findByCode(code).findFirst();
    }

    public static Stream<FinantialDocument> findByCode(DebtAccount debtAccount, String code) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(document -> document.getCode() != null).filter(document -> document.getCode().equals(code));
    }

    public static Optional<FinantialDocument> findUniqueByCode(DebtAccount debtAccount, String code) {
        return FinantialDocument.findByCode(debtAccount, code).findFirst();
    }

    static {
        advice$closeDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$closeDocument$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markDocumentToExport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$clearDocumentToExport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$clearDocumentToExportAndSaveERPCertificationData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DOCUMENT_DATE = new Comparator<FinantialDocument>(){

            @Override
            public int compare(FinantialDocument o1, FinantialDocument o2) {
                int c = o1.getDocumentDate().compareTo((ReadableInstant)o2.getDocumentDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_DOCUMENT_NUMBER_STRING = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Ordering.natural().compare((Object)o1, (Object)o2);
            }
        };
        COMPARE_BY_DOCUMENT_NUMBER = new Comparator<FinantialDocument>(){

            @Override
            public int compare(FinantialDocument o1, FinantialDocument o2) {
                int c = Ordering.natural().compare((Object)o1.getDocumentNumber(), (Object)o2.getDocumentNumber());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

