/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.document.DebitNote$callable$addDebitNoteEntries;
import org.fenixedu.treasury.domain.document.DebitNote$callable$anullDebitNoteWithCreditNote;
import org.fenixedu.treasury.domain.document.DebitNote$callable$closeDocument;
import org.fenixedu.treasury.domain.document.DebitNote$callable$create;
import org.fenixedu.treasury.domain.document.DebitNote$callable$create$1;
import org.fenixedu.treasury.domain.document.DebitNote$callable$create$2;
import org.fenixedu.treasury.domain.document.DebitNote$callable$createDebitNoteForDebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote$callable$createEquivalentCreditNote;
import org.fenixedu.treasury.domain.document.DebitNote$callable$delete;
import org.fenixedu.treasury.domain.document.DebitNote$callable$edit;
import org.fenixedu.treasury.domain.document.DebitNote$callable$updateAllDueDates;
import org.fenixedu.treasury.domain.document.DebitNote$callable$updatePayorDebtAccount;
import org.fenixedu.treasury.domain.document.DebitNote_Base;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.InvoiceSourceBillingType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebitNote
extends DebitNote_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$closeDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDebitNoteForDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addDebitNoteEntries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$anullDebitNoteWithCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createEquivalentCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updatePayorDebtAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateAllDueDates = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DebitNote(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        this.init(debtAccount, documentNumberSeries, documentDate);
    }

    protected DebitNote(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        this.init(debtAccount, payorDebtAccount, documentNumberSeries, documentDate);
    }

    public boolean isDebitNote() {
        return true;
    }

    protected void checkRules() {
        if (!this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.DEBIT_NOTE)) {
            throw new TreasuryDomainException("error.DebitNote.finantialDocumentType.invalid", new String[0]);
        }
        if (this.getPayorDebtAccount() != null && !this.getPayorDebtAccount().getFinantialInstitution().equals((Object)this.getDebtAccount().getFinantialInstitution())) {
            throw new TreasuryDomainException("error.DebitNote.finantialinstitution.mismatch", new String[0]);
        }
        super.checkRules();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new DebitNote$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(DebitNote this_, boolean deleteEntries) {
        super.delete(deleteEntries);
    }

    public BigDecimal getOpenAmount() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            amount = amount.add(debitEntry.getOpenAmount());
        }
        this.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }

    public BigDecimal getOpenAmountWithInterests() {
        if (this.getState().isPreparing() || this.getState().isClosed()) {
            if (TreasuryConstants.isEqual(this.getOpenAmount(), BigDecimal.ZERO)) {
                return BigDecimal.ZERO;
            }
            this.getDebtAccount().getFinantialInstitution().getCurrency();
            return Currency.getValueWithScale(this.getOpenAmount().add(this.getPendingInterestAmount()));
        }
        return BigDecimal.ZERO;
    }

    public Stream<? extends DebitEntry> getDebitEntries() {
        return DebitEntry.find(this);
    }

    public Set<? extends DebitEntry> getDebitEntriesSet() {
        return this.getDebitEntries().collect(Collectors.toSet());
    }

    public BigDecimal getDebitAmount() {
        return this.getTotalAmount();
    }

    public BigDecimal getCreditAmount() {
        return BigDecimal.ZERO;
    }

    public void edit(LocalDate localDate, LocalDate localDate2, String string, String string2, String string3, String string4) {
        Object object = advice$edit.perform((Callable)new DebitNote$callable$edit(this, localDate, localDate2, string, string2, string3, string4));
    }

    static /* synthetic */ void advised$edit(DebitNote this_, LocalDate documentDate, LocalDate documentDueDate, String originDocumentNumber, String documentObservations, String documentTermsAndConditions, String legacyERPCertificateDocumentReference) {
        if (this_.isPreparing()) {
            this_.setDocumentDate(documentDate.toDateTimeAtStartOfDay());
            this_.setDocumentDueDate(documentDueDate);
        }
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setDocumentObservations(documentObservations);
        this_.setDocumentTermsAndConditions(documentTermsAndConditions);
        this_.setLegacyERPCertificateDocumentReference(legacyERPCertificateDocumentReference);
        this_.checkRules();
    }

    public void closeDocument(boolean bl) {
        Object object = advice$closeDocument.perform((Callable)new DebitNote$callable$closeDocument(this, bl));
    }

    static /* synthetic */ void advised$closeDocument(DebitNote this_, boolean markDocumentToExport2) {
        this_.setDocumentDueDate(this_.maxDebitEntryDueDate());
        if (!this_.isManuallyIssuedDocument()) {
            this_.getDebitEntriesSet().stream().filter(de -> Boolean.TRUE.equals(de.getCalculatedAmountsOverriden())).forEach(de -> de.disableOverrideCalculatedAmounts());
        }
        super.closeDocument(markDocumentToExport2);
        TreasuryPlataformDependentServicesFactory.implementation().certifyDocument((FinantialDocument)((Object)this_));
    }

    public boolean isManuallyIssuedDocument() {
        return Boolean.TRUE.equals(this.getCertificationCopyFromCertifiedDocument()) && this.getCertificationOriginalDocumentInvoiceSourceBillingType() == InvoiceSourceBillingType.M && Boolean.TRUE.equals(this.getCertificationOriginalDocumentManual());
    }

    private LocalDate maxDebitEntryDueDate() {
        LocalDate maxDate = this.getDebitEntries().max(DebitEntry.COMPARE_BY_DUE_DATE).map(DebitEntry_Base::getDueDate).orElse(this.getDocumentDueDate());
        return maxDate.isAfter((ReadablePartial)this.getDocumentDate().toLocalDate()) ? maxDate : this.getDocumentDate().toLocalDate();
    }

    public static Stream<DebitNote> findAll() {
        return FinantialDocument.findAll().filter(x -> x instanceof DebitNote).map(DebitNote.class::cast);
    }

    public static Stream<DebitNote> find(DebtAccount debtAccount) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(x -> x instanceof DebitNote).map(DebitNote.class::cast);
    }

    public static DebitNote create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime dateTime) {
        return (DebitNote)((Object)advice$create.perform((Callable)new DebitNote$callable$create(debtAccount, documentNumberSeries, dateTime)));
    }

    static /* synthetic */ DebitNote advised$create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        DebitNote note = new DebitNote(debtAccount, documentNumberSeries, documentDate);
        note.setFinantialDocumentType(FinantialDocumentType.findForDebitNote());
        note.setOriginDocumentNumber("");
        note.setDocumentDueDate(documentDate.toLocalDate());
        note.checkRules();
        return note;
    }

    public static DebitNote create(DebtAccount debtAccount, DebtAccount debtAccount2, DocumentNumberSeries documentNumberSeries, DateTime dateTime, LocalDate localDate, String string) {
        return (DebitNote)((Object)advice$create$1.perform((Callable)new DebitNote$callable$create$1(debtAccount, debtAccount2, documentNumberSeries, dateTime, localDate, string)));
    }

    static /* synthetic */ DebitNote advised$create(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, LocalDate documentDueDate, String originNumber) {
        DebitNote note = new DebitNote(debtAccount, payorDebtAccount, documentNumberSeries, documentDate);
        note.setFinantialDocumentType(FinantialDocumentType.findForDebitNote());
        note.setOriginDocumentNumber(originNumber);
        note.setDocumentDueDate(documentDueDate);
        note.checkRules();
        return note;
    }

    public static DebitNote create(DebtAccount debtAccount, DebtAccount debtAccount2, DocumentNumberSeries documentNumberSeries, DateTime dateTime, LocalDate localDate, String string, Map<String, String> map, String string2, String string3) {
        return (DebitNote)((Object)advice$create$2.perform((Callable)new DebitNote$callable$create$2(debtAccount, debtAccount2, documentNumberSeries, dateTime, localDate, string, map, string2, string3)));
    }

    static /* synthetic */ DebitNote advised$create(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, LocalDate documentDueDate, String originNumber, Map<String, String> propertiesMap, String documentObservations, String documentTermsAndConditions) {
        DebitNote note = DebitNote.create(debtAccount, payorDebtAccount, documentNumberSeries, documentDate, documentDueDate, originNumber);
        note.setDocumentObservations(documentObservations);
        note.setDocumentTermsAndConditions(documentTermsAndConditions);
        note.editPropertiesMap(propertiesMap);
        note.checkRules();
        return note;
    }

    public static DebitNote createDebitNoteForDebitEntry(DebitEntry debitEntry, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime dateTime, LocalDate localDate, String string, String string2, String string3) {
        return (DebitNote)((Object)advice$createDebitNoteForDebitEntry.perform((Callable)new DebitNote$callable$createDebitNoteForDebitEntry(debitEntry, debtAccount, documentNumberSeries, dateTime, localDate, string, string2, string3)));
    }

    static /* synthetic */ DebitNote advised$createDebitNoteForDebitEntry(DebitEntry debitEntry, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, LocalDate documentDueDate, String originDocumentNumber, String documentObservations, String documentTermsAndConditions) {
        if (debitEntry.getFinantialDocument() != null) {
            throw new IllegalStateException("error.DebitNote.createDebitNoteForDebitEntry.debitEntry.already.is.attached.to.finantialDocument");
        }
        DebitNote debitNote = DebitNote.create(debitEntry.getDebtAccount(), payorDebtAccount, documentNumberSeries, documentDate, documentDueDate, originDocumentNumber);
        debitNote.setDocumentObservations(documentObservations);
        debitNote.setDocumentTermsAndConditions(documentTermsAndConditions);
        debitEntry.setFinantialDocument((FinantialDocument)((Object)debitNote));
        return debitNote;
    }

    public void addDebitNoteEntries(List<DebitEntry> list) {
        Object object = advice$addDebitNoteEntries.perform((Callable)new DebitNote$callable$addDebitNoteEntries(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$addDebitNoteEntries(DebitNote this_, List debitEntries) {
        if (!this_.isPreparing()) {
            throw new IllegalStateException("debit note is not in preparing state");
        }
        debitEntries.forEach(d -> {
            if (d.getFinantialDocument() != null && !d.getFinantialDocument().isPreparing()) {
                throw new IllegalArgumentException("debit entry with finantial document that is not in preparing state");
            }
            if (d.getFinantialDocument() != null && d.getDebitNote().getPayorDebtAccount() != this.getPayorDebtAccount()) {
                throw new IllegalArgumentException("debit entry with preparing debit note, but payor debt account mismatch");
            }
            this.addFinantialDocumentEntries((FinantialDocumentEntry)((Object)((Object)d)));
        });
        this_.checkRules();
    }

    public Set<FinantialDocument> findRelatedDocuments(Set<FinantialDocument> documentsBaseList, Boolean includeAnulledDocuments) {
        documentsBaseList.add((FinantialDocument)((Object)this));
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            for (CreditEntry creditEntry : debitEntry.getCreditEntriesSet()) {
                if (creditEntry.getFinantialDocument() == null || creditEntry.getFinantialDocument().isPreparing() || !includeAnulledDocuments.booleanValue() && this.isAnnulled() || documentsBaseList.contains((Object)creditEntry.getFinantialDocument())) continue;
                documentsBaseList.addAll(creditEntry.getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
            }
        }
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            for (SettlementEntry settlementEntry : debitEntry.getSettlementEntriesSet()) {
                if (settlementEntry.getFinantialDocument() == null || settlementEntry.getFinantialDocument().isPreparing() || !includeAnulledDocuments.booleanValue() && settlementEntry.getFinantialDocument().isAnnulled() || documentsBaseList.contains((Object)settlementEntry.getFinantialDocument())) continue;
                documentsBaseList.addAll(settlementEntry.getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
            }
        }
        return documentsBaseList;
    }

    public BigDecimal getPendingInterestAmount() {
        return this.getPendingInterestAmount(new LocalDate());
    }

    public BigDecimal getPendingInterestAmount(LocalDate whenToCalculate) {
        BigDecimal interest = BigDecimal.ZERO;
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            List<InterestRateBean> undebitedInterestRateBeansList = debitEntry.calculateUndebitedInterestValue(whenToCalculate);
            BigDecimal interestAmount = undebitedInterestRateBeansList.stream().map(bean -> bean.getInterestAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            interest = interest.add(interestAmount);
        }
        return interest;
    }

    public void anullDebitNoteWithCreditNote(String string, boolean bl) {
        Object object = advice$anullDebitNoteWithCreditNote.perform((Callable)new DebitNote$callable$anullDebitNoteWithCreditNote(this, string, bl));
    }

    static /* synthetic */ void advised$anullDebitNoteWithCreditNote(DebitNote this_, String reason, boolean anullGeneratedInterests) {
        if (this_.getDebitEntriesSet().stream().anyMatch(d -> d.getOpenPaymentPlan() != null)) {
            throw new TreasuryDomainException("error.DebitNote.anullDebitNoteWithCreditNote.cannot.anull.debt.with.open.paymentPlan", new String[0]);
        }
        if (TreasuryDebtProcessMainService.isFinantialDocumentAnnullmentActionBlocked((FinantialDocument)((Object)this_))) {
            throw new TreasuryDomainException("error.DebitNote.cannot.annull.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (this_.getFinantialDocumentEntriesSet().size() > 0 && this_.isClosed()) {
            DateTime now = new DateTime();
            if (anullGeneratedInterests) {
                this_.getDebitEntries().flatMap(entry -> entry.getInterestDebitEntriesSet().stream()).filter(interest -> interest.getFinantialDocument() == null || interest.getFinantialDocument().isPreparing()).forEach(interest -> {
                    if (interest.getFinantialDocument() == null) {
                        interest.annulDebitEntry(reason);
                    } else {
                        interest.getDebitNote().anullDebitNoteWithCreditNote(reason, false);
                    }
                });
            }
            this_.createEquivalentCreditNote(now, reason, null, anullGeneratedInterests);
            for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
                for (SibsPaymentRequest paymentCode : debitEntry.getSibsPaymentRequests()) {
                    if (!paymentCode.isInCreatedState() && !paymentCode.isInRequestedState()) continue;
                    paymentCode.anull();
                }
                debitEntry.clearInterestRate();
                if (debitEntry.getTreasuryEvent() != null) {
                    debitEntry.annulOnEvent();
                }
                debitEntry.getCreditEntriesSet().stream().filter(e -> !e.isAnnulled()).forEach(c -> debitEntry.closeCreditEntryIfPossible(reason, now, (CreditEntry)((Object)((Object)c))));
            }
            this_.setAnnulledReason(reason);
            this_.setAnnullmentDate(new DateTime());
            String string = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            this_.setAnnullmentResponsible(!Strings.isNullOrEmpty((String)string) ? string : "unknown");
        } else if (this_.isPreparing()) {
            if (!this_.getCreditNoteSet().isEmpty()) {
                throw new TreasuryDomainException("error.DebitNote.creditNote.not.empty", new String[0]);
            }
            if (anullGeneratedInterests) {
                this_.getDebitEntries().flatMap(entry -> entry.getInterestDebitEntriesSet().stream()).filter(interest -> !interest.isAnnulled() && TreasuryConstants.isPositive(interest.getAvailableNetAmountForCredit())).forEach(interest -> interest.annulOnlyThisDebitEntryAndInterestsInBusinessContext(reason));
            }
            for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
                if (debitEntry.getTreasuryEvent() != null) {
                    debitEntry.annulOnEvent();
                }
                for (SibsPaymentRequest paymentCode : debitEntry.getSibsPaymentRequests()) {
                    if (!paymentCode.isInCreatedState() && !paymentCode.isInRequestedState()) continue;
                    paymentCode.anull();
                }
            }
            this_.setState(FinantialDocumentStateType.ANNULED);
            this_.setAnnulledReason(reason);
            this_.setAnnullmentDate(new DateTime());
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            this_.setAnnullmentResponsible(!Strings.isNullOrEmpty((String)loggedUsername) ? loggedUsername : "unknown");
        } else {
            throw new TreasuryDomainException("error.DebitNote.cannot.anull.is.empty", new String[0]);
        }
    }

    public void createEquivalentCreditNote(DateTime dateTime, String string, String string2, boolean bl) {
        Object object = advice$createEquivalentCreditNote.perform((Callable)new DebitNote$callable$createEquivalentCreditNote(this, dateTime, string, string2, bl));
    }

    static /* synthetic */ void advised$createEquivalentCreditNote(DebitNote this_, DateTime documentDate, String documentObservations, String documentTermsAndConditions, boolean createForInterestRateEntries) {
        boolean isToCloseCreditNoteWhenCreated = this_.getDebtAccount().getFinantialInstitution().isToCloseCreditNoteWhenCreated();
        boolean isInvoiceRegistrationByTreasuryCertification = this_.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification();
        CreditNote creditNote = null;
        if (isInvoiceRegistrationByTreasuryCertification) {
            DocumentNumberSeries documentNumberSeries = this_.inferCreditNoteDocumentNumberSeries();
            creditNote = CreditNote.create(this_.getDebtAccount(), documentNumberSeries, documentDate, this_, this_.getUiDocumentNumber());
        }
        for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
            BigDecimal amountForCreditWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(debitEntry.getAvailableAmountWithVatForCredit(), BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)debitEntry)))));
            if (TreasuryConstants.isZero(amountForCreditWithoutVat) && !debitEntry.getTreasuryExemptionsSet().isEmpty()) continue;
            if (Boolean.TRUE.equals(debitEntry.getCalculatedAmountsOverriden())) {
                amountForCreditWithoutVat = debitEntry.getAvailableNetAmountForCredit();
            }
            CreditEntry creditEntry = debitEntry.createCreditEntry(documentDate, debitEntry.getDescription(), documentObservations, documentTermsAndConditions, amountForCreditWithoutVat, null, creditNote);
            if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() || !this_.isExportedInLegacyERP()) continue;
            creditEntry.getFinantialDocument().setExportedInLegacyERP(true);
            creditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        if (isInvoiceRegistrationByTreasuryCertification && isToCloseCreditNoteWhenCreated) {
            creditNote.closeDocument();
        }
        if (!createForInterestRateEntries) {
            return;
        }
        for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
            for (DebitEntry interestEntry : debitEntry.getInterestDebitEntriesSet()) {
                BigDecimal amountForCreditWithoutVat;
                if (!interestEntry.getFinantialDocument().isClosed() || TreasuryConstants.isZero(amountForCreditWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(interestEntry.getAvailableAmountWithVatForCredit(), BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)interestEntry)))))) && !interestEntry.getTreasuryExemptionsSet().isEmpty()) continue;
                CreditEntry interestsCreditEntry = interestEntry.createCreditEntry(documentDate, interestEntry.getDescription(), documentObservations, documentTermsAndConditions, amountForCreditWithoutVat, null, null);
                if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() || interestEntry.getFinantialDocument() == null || !interestEntry.getFinantialDocument().isExportedInLegacyERP()) continue;
                interestsCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
                interestsCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            }
        }
    }

    public DocumentNumberSeries inferCreditNoteDocumentNumberSeries() {
        boolean isInvoiceRegistrationByTreasuryCertification = this.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification();
        if (isInvoiceRegistrationByTreasuryCertification && this.getDocumentNumberSeries().getSeries().isLegacy()) {
            return DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), Series.findUniqueDefault(this.getDebtAccount().getFinantialInstitution()).get());
        }
        return DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), this.getDocumentNumberSeries().getSeries());
    }

    public void annulCertifiedDebitNote(String reason) {
        if (!this.isCertifiedDebitNoteAnnulable()) {
            throw new TreasuryDomainException("error.DebitNote.annulCertifiedDebitNote.not.possible.due.existing.active.credits.or.settlements", new String[0]);
        }
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            if (debitEntry.getTreasuryEvent() != null) {
                debitEntry.annulOnEvent();
            }
            for (SibsPaymentRequest paymentCode : debitEntry.getSibsPaymentRequests()) {
                if (!paymentCode.isInCreatedState() && !paymentCode.isInRequestedState()) continue;
                paymentCode.anull();
            }
        }
        this.setState(FinantialDocumentStateType.ANNULED);
        this.setAnnulledReason(reason);
        this.setAnnullmentDate(new DateTime());
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        this.setAnnullmentResponsible(!Strings.isNullOrEmpty((String)loggedUsername) ? loggedUsername : "unknown");
        TreasuryPlataformDependentServicesFactory.implementation().annulCertifiedDocument((FinantialDocument)((Object)this));
    }

    public boolean isCertifiedDebitNoteAnnulable() {
        if (!this.isClosed()) {
            return false;
        }
        boolean withAllCreditNotesAnnuled = this.getCreditNoteSet().stream().allMatch(c -> c.isAnnulled());
        boolean withAllSettlementNotesAnnuled = this.getDebitEntriesSet().stream().allMatch(de -> de.getSettlementEntriesSet().stream().allMatch(se -> se.getFinantialDocument().isAnnulled()));
        boolean withAllInterestsAnnuled = this.getDebitEntriesSet().stream().allMatch(de -> de.getInterestDebitEntriesSet().stream().allMatch(i -> i.isAnnulled()));
        return withAllCreditNotesAnnuled && withAllSettlementNotesAnnuled && withAllInterestsAnnuled;
    }

    public Set<CreditEntry> getRelatedCreditEntriesSet() {
        HashSet<CreditEntry> result = new HashSet<CreditEntry>();
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            result.addAll(debitEntry.getCreditEntriesSet());
        }
        return result;
    }

    public DebitNote updatePayorDebtAccount(DebtAccount debtAccount) {
        return (DebitNote)((Object)advice$updatePayorDebtAccount.perform((Callable)new DebitNote$callable$updatePayorDebtAccount(this, debtAccount)));
    }

    static /* synthetic */ DebitNote advised$updatePayorDebtAccount(DebitNote this_, DebtAccount payorDebtAccount) {
        if (!this_.isPreparing() && !this_.isClosed()) {
            throw new TreasuryDomainException("error.DebitNote.updatePayorDebtAccount.not.preparing.nor.closed", new String[0]);
        }
        if (this_.getPayorDebtAccount() == payorDebtAccount) {
            throw new TreasuryDomainException("error.DebitNote.updatePayorDebtAccount.payor.not.changed", new String[0]);
        }
        if (payorDebtAccount == this_.getDebtAccount()) {
            throw new TreasuryDomainException("error.DebitNote.updatePayorDebtAccount.payor.same.as.debt.account", new String[0]);
        }
        if (this_.getDebitEntriesSet().stream().anyMatch(entry -> entry.isInOpenPaymentPlan())) {
            throw new TreasuryDomainException("error.DebitNote.updatePayorDebtAccount.debitEntry.in.active.paymentPlan", new String[0]);
        }
        if (this_.isClosed()) {
            for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
                if (debitEntry.getSettlementEntriesSet().stream().filter(s -> !s.isAnnulled()).count() <= 0L) continue;
                throw new TreasuryDomainException("error.DebitNote.updatePayorDebtAccount.debit.entries.has.settlements", new String[0]);
            }
        }
        DebitNote updatingDebitNote = this_.isPreparing() ? this_ : this_.anullAndCopyDebitNote(TreasuryConstants.treasuryBundle("label.DebitNote.updatePayorDebtAccount.anull.reason", new String[0]));
        updatingDebitNote.setPayorDebtAccount(payorDebtAccount);
        for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
            for (PaymentRequest paymentRequest : debitEntry.getSibsPaymentRequests()) {
                if (!paymentRequest.isInCreatedState() && !paymentRequest.isInRequestedState()) continue;
                ((SibsPaymentRequest)((Object)paymentRequest)).anull();
            }
        }
        return updatingDebitNote;
    }

    private DebitNote anullAndCopyDebitNote(String reason) {
        if (!this.isClosed()) {
            throw new TreasuryDomainException("error.DebitNote.anullAndCopyDebitNote.copy.only.on.closed.debit.note", new String[0]);
        }
        DebitNote newDebitNote = DebitNote.create(this.getDebtAccount(), this.getDocumentNumberSeries(), new DateTime());
        newDebitNote.setOriginDocumentNumber(this.getOriginDocumentNumber());
        for (FinantialDocumentEntry finantialDocumentEntry : this.getFinantialDocumentEntriesSet()) {
            DebitEntry debitEntry = (DebitEntry)((Object)finantialDocumentEntry);
            DebitEntry newDebitEntry = DebitEntry.create(debitEntry.getFinantialEntity(), debitEntry.getDebtAccount(), debitEntry.getTreasuryEvent(), debitEntry.getVat(), debitEntry.getAmount().add(debitEntry.getNetExemptedAmount()), debitEntry.getDueDate(), debitEntry.getPropertiesMap(), debitEntry.getProduct(), debitEntry.getDescription(), debitEntry.getQuantity(), debitEntry.getInterestRate(), debitEntry.getEntryDateTime(), debitEntry.isAcademicalActBlockingSuspension(), debitEntry.isBlockAcademicActsOnDebt(), newDebitNote);
            DebitEntry.applyAdditionalRelationConnectionsOfDebitEntry(debitEntry, newDebitEntry);
            debitEntry.getTreasuryExemptionsSet().forEach(treasuryExemption -> TreasuryExemption.create(treasuryExemption.getTreasuryExemptionType(), treasuryExemption.getReason(), treasuryExemption.getNetAmountToExempt(), newDebitEntry));
        }
        this.anullDebitNoteWithCreditNote(reason, false);
        return newDebitNote;
    }

    public void updateAllDueDates(LocalDate localDate) {
        Object object = advice$updateAllDueDates.perform((Callable)new DebitNote$callable$updateAllDueDates(this, localDate));
    }

    static /* synthetic */ void advised$updateAllDueDates(DebitNote this_, LocalDate newDueDate) {
        this_.setDocumentDueDate(newDueDate);
        this_.getDebitEntries().forEach(entry -> entry.updateDueDate(newDueDate));
        this_.checkRules();
    }

    public void createOpenCreditNoteForIntegrationOrRecovery() {
        if (this.isAnnulled()) {
            throw new IllegalStateException("error.DebitNote.createOpenCreditNoteForIntegrationOrRecovery.document.is.annuled");
        }
        if (!TreasuryConstants.isPositive(this.getAvailableNetAmountForCredit())) {
            throw new IllegalStateException("error.DebitNote.createOpenCreditNoteForIntegrationOrRecovery.available.amount.for.credit.is.not.positive");
        }
        if (!this.getDocumentNumberSeries().getSeries().isLegacy()) {
            throw new IllegalStateException("error.DebitNote.createOpenCreditNoteForIntegrationOrRecovery.series.is.not.legacy");
        }
        if (!this.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification()) {
            throw new IllegalStateException("error.DebitNote.createOpenCreditNoteForIntegrationOrRecovery.invoice.registration.not.treasury.certification");
        }
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), this.getDocumentNumberSeries().getSeries());
        DateTime documentDate = new DateTime();
        CreditNote creditNote = CreditNote.create(this.getDebtAccount(), documentNumberSeries, documentDate, this, this.getUiDocumentNumber());
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            BigDecimal amountForCreditWithoutVat = debitEntry.getAvailableNetAmountForCredit();
            if (!TreasuryConstants.isPositive(amountForCreditWithoutVat)) continue;
            debitEntry.createCreditEntry(documentDate, debitEntry.getDescription(), null, null, amountForCreditWithoutVat, null, creditNote);
        }
    }

    public BigDecimal getAvailableNetAmountForCredit() {
        return this.getDebitEntriesSet().stream().map(de -> de.getAvailableNetAmountForCredit()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Deprecated
    public static DebitEntry createBalanceTransferDebit(DebtAccount debtAccount, DateTime entryDate, LocalDate dueDate, String originNumber, Product product, BigDecimal amountWithVat, DebtAccount payorDebtAccount, String entryDescription, InterestRate interestRate, FinantialEntity finantialEntity) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        Series regulationSeries = finantialInstitution.getRegulationSeries();
        DocumentNumberSeries numberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), regulationSeries);
        Vat transferVat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, entryDate).get();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent();
        }
        DebitNote debitNote = DebitNote.create(debtAccount, payorDebtAccount, numberSeries, new DateTime(), new DateTime().toLocalDate(), originNumber);
        BigDecimal amountWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(amountWithVat, TreasuryConstants.divide(transferVat.getTaxRate(), TreasuryConstants.HUNDRED_PERCENT).add(BigDecimal.ONE)));
        return DebitEntry.create(finantialEntity, debtAccount, null, transferVat, amountWithoutVat, dueDate, Maps.newHashMap(), product, entryDescription, BigDecimal.ONE, interestRate, entryDate, false, false, debitNote);
    }
}

