/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry_Base;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class CreditEntry
extends CreditEntry_Base {
    protected CreditEntry(FinantialEntity finantialEntity, FinantialDocument finantialDocument, Product product, Vat vat, BigDecimal unitAmount, String description, BigDecimal quantity, DateTime entryDateTime, DebitEntry debitEntry, TreasuryExemption treasuryExemption) {
        this.init(finantialEntity, finantialDocument, product, vat, unitAmount, description, quantity, entryDateTime, debitEntry, treasuryExemption);
    }

    public boolean isCreditNoteEntry() {
        return true;
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal amount, String description, BigDecimal quantity, DateTime entryDateTime) {
        throw new RuntimeException("error.CreditEntry.use.init.without.finantialEntryType");
    }

    protected void init(FinantialEntity finantialEntity, FinantialDocument finantialDocument, Product product, Vat vat, BigDecimal unitAmount, String description, BigDecimal quantity, DateTime entryDateTime, DebitEntry debitEntry, TreasuryExemption treasuryExemption) {
        super.init(finantialDocument, finantialDocument.getDebtAccount(), product, FinantialEntryType.CREDIT_ENTRY, vat, unitAmount, description, quantity, entryDateTime);
        super.setFinantialEntity(finantialEntity);
        this.setDebitEntry(debitEntry);
        this.setFromExemption(treasuryExemption != null);
        this.setTreasuryExemption(treasuryExemption);
        this.recalculateAmountValues();
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof CreditNote)) {
            throw new TreasuryDomainException("error.CreditEntry.finantialDocument.not.credit.entry.type", new String[0]);
        }
        if (this.getFromExemption() && this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.CreditEntry.from.exemption.requires.debit.entry", new String[0]);
        }
        if (!(this.getDebitEntry() == null || this.getDebitEntry().getProduct() == this.getProduct() || this.getFinantialDocument() != null && this.getFinantialDocument().getDocumentNumberSeries().getSeries().isLegacy())) {
            throw new TreasuryDomainException("error.CreditEntry.product.must.be.the.same.as.debit.entry", new String[0]);
        }
        if (this.getFromExemption() && this.getTreasuryExemption() == null) {
            throw new TreasuryDomainException("error.CreditEntry.from.exemption.at.most.one.per.debit.entry", new String[0]);
        }
        if (this.getDebitEntry() != null && TreasuryConstants.isGreaterThan(this.getDebitEntry().getTotalCreditedAmountWithVat(), this.getDebitEntry().getTotalAmount())) {
            throw new TreasuryDomainException("error.CreditEntry.reated.debit.entry.invalid.total.credited.amount", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDescription())) {
            throw new TreasuryDomainException("error.CreditEntry.description.required", new String[0]);
        }
    }

    public boolean isFromExemption() {
        return this.getFromExemption();
    }

    public void delete() {
        this.setDebitEntry(null);
        super.delete();
    }

    public void edit(String description) {
        if (this.isFromExemption()) {
            throw new TreasuryDomainException("error.CreditEntry.cannot.edit.due.to.exemption.origin", new String[0]);
        }
        this.setDescription(description);
        this.checkRules();
    }

    public static Stream<CreditEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof CreditEntry).map(CreditEntry.class::cast);
    }

    public LocalDate getDueDate() {
        return this.getEntryDateTime().toLocalDate();
    }

    public static Stream<? extends CreditEntry> find(CreditNote creditNote) {
        return creditNote.getFinantialDocumentEntriesSet().stream().filter(f -> f instanceof CreditEntry).map(CreditEntry.class::cast);
    }

    public static Stream<? extends CreditEntry> find(TreasuryEvent treasuryEvent) {
        return Stream.concat(DebitEntry.find(treasuryEvent).flatMap(d -> d.getCreditEntriesSet().stream()), treasuryEvent.getCreditEntriesSet().stream());
    }

    public static Stream<? extends CreditEntry> findActive(TreasuryEvent treasuryEvent) {
        return Stream.concat(DebitEntry.findActive(treasuryEvent).flatMap(d -> d.getCreditEntriesSet().stream().filter(ce -> !ce.isAnnulled())), treasuryEvent.getCreditEntriesSet().stream().filter(ce -> !ce.isAnnulled()));
    }

    public static Stream<? extends CreditEntry> findActive(TreasuryEvent treasuryEvent, Product product) {
        return Stream.concat(DebitEntry.findActive(treasuryEvent, product).flatMap(d -> d.getCreditEntriesSet().stream().filter(ce -> !ce.isAnnulled())), treasuryEvent.getCreditEntriesSet().stream().filter(ce -> ce.getProduct() == product).filter(ce -> !ce.isAnnulled()));
    }

    public static CreditEntry create(FinantialDocument finantialDocument, String description, Product product, Vat vat, BigDecimal unitAmount, DateTime entryDateTime, DebitEntry debitEntry, BigDecimal quantity) {
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)debitEntry))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (debitEntry == null) {
            throw new TreasuryDomainException("error.CreditEntry.debitEntry.required", new String[0]);
        }
        CreditEntry cr = new CreditEntry(debitEntry.getFinantialEntity(), finantialDocument, product, vat, unitAmount, description, quantity, entryDateTime, debitEntry, null);
        return cr;
    }

    public static CreditEntry create(FinantialEntity finantialEntity, FinantialDocument finantialDocument, String description, Product product, Vat vat, BigDecimal unitAmount, DateTime entryDateTime, BigDecimal quantity) {
        CreditEntry cr = new CreditEntry(finantialEntity, finantialDocument, product, vat, unitAmount, description, quantity, entryDateTime, null, null);
        return cr;
    }

    static CreditEntry createFromExemption(TreasuryExemption treasuryExemption, FinantialDocument finantialDocument, String description, BigDecimal unitAmount, DateTime entryDateTime, BigDecimal quantity) {
        DebitEntry debitEntry = treasuryExemption.getDebitEntry();
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)debitEntry))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (treasuryExemption == null) {
            throw new TreasuryDomainException("error.CreditEntry.createFromExemption.requires.treasuryExemption", new String[0]);
        }
        CreditEntry cr = new CreditEntry(debitEntry.getFinantialEntity(), finantialDocument, debitEntry.getProduct(), debitEntry.getVat(), unitAmount, description, quantity, entryDateTime, debitEntry, treasuryExemption);
        return cr;
    }

    public BigDecimal getOpenAmountWithInterests() {
        return this.getOpenAmount();
    }

    public CreditNote getCreditNote() {
        return (CreditNote)((Object)this.getFinantialDocument());
    }

    public CreditEntry splitCreditEntry(BigDecimal amountWithVatOfNewCreditEntry) {
        if (!TreasuryConstants.isLessThan(amountWithVatOfNewCreditEntry, this.getOpenAmount())) {
            throw new TreasuryDomainException("error.CreditEntry.splitCreditEntry.remainingAmount.less.than.open.amount", new String[0]);
        }
        if (!this.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.CreditEntry.splitCreditEntry.finantialDocument.not.preparing", new String[0]);
        }
        BigDecimal oldNetAmount = this.getNetAmount();
        BigDecimal oldAmountWithVat = this.getAmountWithVat();
        CreditNote newCreditNote = CreditNote.create(this.getDebtAccount(), this.getCreditNote().getDocumentNumberSeries(), this.getCreditNote().getDocumentDate(), this.getCreditNote().getDebitNote(), this.getCreditNote().getOriginDocumentNumber());
        newCreditNote.setDocumentObservations(this.getCreditNote().getDocumentObservations());
        newCreditNote.setDocumentTermsAndConditions(this.getCreditNote().getDocumentTermsAndConditions());
        newCreditNote.editPropertiesMap(this.getCreditNote().getPropertiesMap());
        newCreditNote.setCertificationOriginDocumentReference(this.getCreditNote().getCertificationOriginDocumentReference());
        newCreditNote.setCloseDate(this.getCreditNote().getCloseDate());
        BigDecimal unitAmountOfNewCreditEntry = Currency.getValueWithScale(TreasuryConstants.divide(TreasuryConstants.divide(amountWithVatOfNewCreditEntry, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this)))), this.getQuantity()));
        BigDecimal openUnitAmountOfThisCreditEntry = TreasuryConstants.divide(TreasuryConstants.divide(this.getOpenAmount(), BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this)))), this.getQuantity());
        this.setAmount(openUnitAmountOfThisCreditEntry.subtract(unitAmountOfNewCreditEntry));
        this.recalculateAmountValues();
        CreditEntry newCreditEntry = this.getDebitEntry() != null ? CreditEntry.create((FinantialDocument)((Object)newCreditNote), this.getDescription(), this.getProduct(), this.getVat(), unitAmountOfNewCreditEntry, this.getEntryDateTime(), this.getDebitEntry(), this.getQuantity()) : CreditEntry.create(this.getFinantialEntity(), (FinantialDocument)((Object)newCreditNote), this.getDescription(), this.getProduct(), this.getVat(), unitAmountOfNewCreditEntry, this.getEntryDateTime(), this.getQuantity());
        newCreditEntry.setFromExemption(this.isFromExemption());
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP()) {
            newCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
            newCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        if (oldNetAmount.compareTo(this.getNetAmount().add(newCreditEntry.getNetAmount())) != 0) {
            throw new IllegalStateException("error.CreditEntry.splitCreditEntry.netAmount.before.after.not.equal");
        }
        if (oldAmountWithVat.compareTo(this.getAmountWithVat().add(newCreditEntry.getAmountWithVat())) != 0) {
            throw new IllegalStateException("error.CreditEntry.splitCreditEntry.amountWithVat.before.after.not.equal");
        }
        return newCreditEntry;
    }

    public FinantialEntity getFinantialEntity() {
        if (super.getFinantialEntity() != null) {
            return super.getFinantialEntity();
        }
        if (this.getDebitEntry() != null) {
            return this.getDebitEntry().getFinantialEntity();
        }
        return null;
    }

    public BigDecimal getUiTotalAmount() {
        if (Boolean.TRUE.equals(TreasurySettings.getInstance().getDisplayNegativeAmountsForCreditEntries())) {
            return super.getUiTotalAmount().negate();
        }
        return super.getUiTotalAmount();
    }

    public BigDecimal getUiOpenAmount() {
        if (Boolean.TRUE.equals(TreasurySettings.getInstance().getDisplayNegativeAmountsForCreditEntries())) {
            return super.getUiOpenAmount().negate();
        }
        return super.getUiOpenAmount();
    }

    public BigDecimal getUiOpenAmountWithInterests() {
        if (Boolean.TRUE.equals(TreasurySettings.getInstance().getDisplayNegativeAmountsForCreditEntries())) {
            return super.getUiOpenAmountWithInterests().negate();
        }
        return super.getUiOpenAmountWithInterests();
    }

    public TreasuryEvent getTreasuryEvent() {
        if (super.getTreasuryEvent() != null) {
            return super.getTreasuryEvent();
        }
        return super.getDebitEntry() != null ? super.getDebitEntry().getTreasuryEvent() : null;
    }
}

