/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.model;

import java.math.BigDecimal;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotification;
import org.joda.time.DateTime;

public class SibsPayWebhookNotificationWrapper
implements DigitalPlatformResultBean {
    private SibsPayWebhookNotification webhookNotification;

    public SibsPayWebhookNotificationWrapper(SibsPayWebhookNotification webhookNotification) {
        this.webhookNotification = webhookNotification;
    }

    public BigDecimal getAmount() {
        return this.webhookNotification.getAmount().getValue();
    }

    public String getMerchantTransactionId() {
        return null;
    }

    public String getPaymentBrand() {
        return this.webhookNotification.getPaymentMethod();
    }

    public DateTime getPaymentDate() {
        return this.webhookNotification.getTransactionDateTime();
    }

    public String getPaymentResultCode() {
        return this.webhookNotification.getPaymentStatus();
    }

    public String getPaymentResultDescription() {
        return null;
    }

    public String getPaymentType() {
        return this.webhookNotification.getPaymentMethod();
    }

    public String getTimestamp() {
        return null;
    }

    public String getTransactionId() {
        return this.webhookNotification.getTransactionID();
    }

    public String getOperationStatusCode() {
        return this.webhookNotification.getReturnStatus().getStatusCode();
    }

    public String getOperationStatusMessage() {
        return this.webhookNotification.getReturnStatus().getStatusMsg();
    }

    public String getOperationStatusDescription() {
        return this.webhookNotification.getReturnStatus().getStatusDescription();
    }

    public String getNotificationID() {
        return this.webhookNotification.getNotificationID();
    }

    public boolean isOperationSuccess() {
        return SibsPayService.isOperationSuccess(this.webhookNotification.getReturnStatus().getStatusCode());
    }

    public boolean isPaid() {
        return SibsPayService.isPaid(this.getPaymentResultCode());
    }

    public boolean isPending() {
        return SibsPayService.isPending(this.getPaymentResultCode());
    }

    public boolean isExpired() {
        return SibsPayService.isExpired(this.getPaymentResultCode());
    }

    public boolean isDeclined() {
        return SibsPayService.isDeclined(this.getPaymentResultCode());
    }
}

