/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.FixedAmountInterestRateType_Base;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class FixedAmountInterestRateType
extends FixedAmountInterestRateType_Base {
    private static final String DEFAULT_CODE = "FIXED_AMOUNT";

    public FixedAmountInterestRateType() {
        super.setRequiresInterestFixedAmount(Boolean.valueOf(true));
    }

    public FixedAmountInterestRateType(LocalizedString description) {
        this();
        super.init(description);
        super.setCode(DEFAULT_CODE);
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (FixedAmountInterestRateType.findAll().count() > 1L) {
            throw new TreasuryDomainException("error.FixedAmountInterestRateType.already.exists", new String[0]);
        }
    }

    public List<InterestRateBean> calculateInterests(DebitEntry debitEntry, LocalDate paymentDate, boolean withAllInterestValues) {
        return this.calculateForFixedAmount(debitEntry, withAllInterestValues);
    }

    public List<InterestRateBean> calculateAllInterestsByLockingAtDate(DebitEntry debitEntry, LocalDate lockDate) {
        return this.calculateForFixedAmount(debitEntry, true);
    }

    private List<InterestRateBean> calculateForFixedAmount(DebitEntry debitEntry, boolean withAllInterestValues) {
        InterestRate interestRate = debitEntry.getInterestRate();
        InterestRateBean result = new InterestRateBean(interestRate.getInterestRateType());
        BigDecimal totalInterestAmount = Currency.getValueWithScale(interestRate.getInterestFixedAmount());
        if (!withAllInterestValues) {
            for (Map.Entry entry : this.createdInterestEntriesMap(debitEntry).entrySet()) {
                result.addCreatedInterestEntry((LocalDate)entry.getKey(), (BigDecimal)entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract((BigDecimal)entry.getValue());
            }
        }
        if (TreasuryConstants.isNegative(totalInterestAmount)) {
            totalInterestAmount = BigDecimal.ZERO;
        }
        result.setInterestAmount(Currency.getValueWithScale(totalInterestAmount));
        result.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", debitEntry.getDescription()));
        return Collections.singletonList(result);
    }

    public static LocalizedString getPresentationName() {
        return TreasuryConstants.treasuryBundleI18N("label.FixedAmountInterestRateType.default.description", new String[0]);
    }

    public static FixedAmountInterestRateType create(LocalizedString description) {
        return new FixedAmountInterestRateType(description);
    }

    public static Stream<FixedAmountInterestRateType> findAll() {
        return FenixFramework.getDomainRoot().getInterestRateTypesSet().stream().filter(type -> type instanceof FixedAmountInterestRateType).map(FixedAmountInterestRateType.class::cast);
    }

    public static Optional<FixedAmountInterestRateType> findUnique() {
        return FixedAmountInterestRateType.findAll().findFirst();
    }
}

