/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentTransaction_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class PaymentTransaction
extends PaymentTransaction_Base {
    public PaymentTransaction() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setResponsibleUsername(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
    }

    protected PaymentTransaction(PaymentRequest paymentRequest, String transactionId, DateTime paymentDate, BigDecimal paidAmount, Set<SettlementNote> settlementNotes) {
        this();
        if (PaymentTransaction.isTransactionDuplicate(transactionId)) {
            throw new TreasuryDomainException("error.PaymentTransaction.transaction.duplicate", transactionId);
        }
        this.init(paymentRequest, transactionId, paymentDate, paidAmount, settlementNotes);
        this.checkRules();
    }

    protected void init(PaymentRequest paymentRequest, String transactionId, DateTime paymentDate, BigDecimal paidAmount, Set<SettlementNote> settlementNotes) {
        this.setPaymentRequest(paymentRequest);
        this.setPaymentDate(paymentDate);
        this.setTransactionId(transactionId);
        this.setPaidAmount(paidAmount);
        this.getSettlementNotesSet().addAll(settlementNotes);
    }

    public void checkRules() {
        if (this.getPaymentRequest() == null) {
            throw new TreasuryDomainException("error.PaymentTransaction.paymentRequest.required", new String[0]);
        }
        if (this.getPaymentDate() == null) {
            throw new TreasuryDomainException("error.PaymentTransaction.paymentDate.required", new String[0]);
        }
        if (this.getPaidAmount() == null) {
            throw new TreasuryDomainException("error.PaymentTransaction.paidAmount.required", new String[0]);
        }
        if (!TreasuryConstants.isPositive(this.getPaidAmount())) {
            throw new TreasuryDomainException("error.PaymentTransaction.paidAmount.invalid", new String[0]);
        }
        if (PaymentTransaction.findByTransactionId(this.getTransactionId()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentTransaction.transaction.duplicate", this.getTransactionId());
        }
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setPaymentRequest(null);
        super.setPaymentRequestLog(null);
        super.getSettlementNotesSet().clear();
        super.deleteDomainObject();
    }

    public static Stream<? extends PaymentTransaction> findAll() {
        return FenixFramework.getDomainRoot().getPaymentTransactionsSet().stream();
    }

    public static Stream<? extends PaymentTransaction> findByTransactionId(String transactionId) {
        return PaymentTransaction.findAll().filter(t -> transactionId.equalsIgnoreCase(t.getTransactionId()));
    }

    public static boolean isTransactionDuplicate(String transactionId) {
        return PaymentTransaction.findByTransactionId(transactionId).findAny().isPresent();
    }

    public static PaymentTransaction create(PaymentRequest paymentRequest, String transactionId, DateTime paymentDate, BigDecimal paidAmount, Set<SettlementNote> settlementNotes) {
        return new PaymentTransaction(paymentRequest, transactionId, paymentDate, paidAmount, settlementNotes);
    }
}

