/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanNumberGenerator_Base;
import pt.ist.fenixframework.FenixFramework;

public class PaymentPlanNumberGenerator
extends PaymentPlanNumberGenerator_Base {
    public PaymentPlanNumberGenerator() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public PaymentPlanNumberGenerator(LocalizedString name, String prefix, Integer initialValue) {
        this();
        this.setName(name);
        this.setPrefix(prefix);
        this.setInitialValue(initialValue);
        this.checkRules();
    }

    public static PaymentPlanNumberGenerator create(LocalizedString name, String prefix, Integer initialValue) {
        return new PaymentPlanNumberGenerator(name, prefix, initialValue);
    }

    private void checkRules() {
        if (this.getInitialValue() == null) {
            throw new TreasuryDomainException("error.PaymentPlanNumberGenerator.initialValue.required", new String[0]);
        }
        if (this.getPrefix() == null) {
            throw new TreasuryDomainException("error.PaymentPlanNumberGenerator.prefix.required", new String[0]);
        }
        if (this.getName() == null) {
            throw new TreasuryDomainException("error.PaymentPlanNumberGenerator.name.required", new String[0]);
        }
    }

    protected String getPrefixToGenerateNumber() {
        return StringUtils.isEmpty((String)this.getPrefix()) ? "" : this.getPrefix();
    }

    public String generateNumber() {
        this.setActualValue(this.getActualValue() == null ? this.getInitialValue() : this.getActualValue() + 1);
        return this.getPrefixToGenerateNumber() + this.getActualValue();
    }

    public String getNextNumberPreview() {
        return this.getPrefixToGenerateNumber() + (this.getActualValue() == null ? this.getInitialValue() : this.getActualValue() + 1);
    }

    public void delete() {
        if (!this.getPaymentPlanSettingsSet().isEmpty()) {
            throw new TreasuryDomainException("error.PaymentPlanNumberGenerator.in.settings.cannot.be.deleted", new String[0]);
        }
        this.setDomainRoot(null);
        super.deleteDomainObject();
    }
}

