/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.dataproviders;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.services.reports.dataproviders.AbstractDataProvider;
import org.joda.time.LocalDate;

public class PaymentReferenceCodeDataProvider
extends AbstractDataProvider
implements IReportDataProvider {
    protected static final String PAYMENT_CODE_KEY = "paymentCode";
    private SibsPaymentRequest paymentCode;

    public PaymentReferenceCodeDataProvider(SibsPaymentRequest paymentCode) {
        this.setPaymentCode(paymentCode);
        this.registerKey(PAYMENT_CODE_KEY, PaymentReferenceCodeDataProvider::handlePaymentCodeKey);
    }

    private static Object handlePaymentCodeKey(IReportDataProvider provider) {
        PaymentReferenceCodeDataProvider regisProvider = (PaymentReferenceCodeDataProvider)provider;
        return regisProvider.getPaymentCode();
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
    }

    public SibsPaymentRequest getPaymentCode() {
        return this.paymentCode;
    }

    public void setPaymentCode(SibsPaymentRequest paymentCode) {
        this.paymentCode = paymentCode;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        for (FinantialDocumentEntry entry : this.paymentCode.getOrderedDebitEntries()) {
            builder.append(((DebitEntry)((Object)entry)).getProduct().getName().getContent()).append("\n");
        }
        return builder.toString();
    }

    public BigDecimal getAmount() {
        return this.paymentCode.getPayableAmount();
    }

    public LocalDate getDueDate() {
        return this.paymentCode.getDueDate();
    }
}

