/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry$1;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$delete;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$edit;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.domain.tariff.InterestRate_Base;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class InterestRate
extends InterestRate_Base {
    private static final int MAX_YEARS = 5;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected InterestRate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected InterestRate(Tariff tariff, DebitEntry debitEntry, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this();
        this.setTariff(tariff);
        this.setDebitEntry(debitEntry);
        this.setInterestRateType(interestRateType);
        this.setNumberOfDaysAfterDueDate(1);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this.setInterestFixedAmount(interestFixedAmount);
        this.setRate(rate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTariff() == null && this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.required", new String[0]);
        }
        if (this.getTariff() != null && this.getDebitEntry() != null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.only.one", new String[0]);
        }
        if (this.getInterestRateType() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestRateType.required", new String[0]);
        }
        if (this.getInterestRateType().isInterestFixedAmountRequired() && this.getInterestFixedAmount() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestFixedAmount.required", new String[0]);
        }
    }

    @Deprecated
    public boolean isMaximumDaysToApplyPenaltyApplied() {
        return this.getMaximumDaysToApplyPenalty() > 0;
    }

    @Deprecated
    public boolean isApplyInFirstWorkday() {
        return this.getApplyInFirstWorkday();
    }

    public void edit(InterestRateType interestRateType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new InterestRate$callable$edit(this, interestRateType, n, bl, n2, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(InterestRate this_, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this_.setInterestRateType(interestRateType);
        this_.setNumberOfDaysAfterDueDate(1);
        this_.setApplyInFirstWorkday(applyInFirstWorkday);
        this_.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this_.setInterestFixedAmount(interestFixedAmount);
        this_.setRate(rate);
        this_.checkRules();
    }

    public List<InterestRateBean> calculateInterests(LocalDate paymentDate, boolean withAllInterestValues) {
        return this.getInterestRateType().calculateInterests(this.getDebitEntry(), paymentDate, withAllInterestValues);
    }

    public List<InterestRateBean> calculateAllInterestsByLockingAtDate(LocalDate lockDate) {
        return this.getInterestRateType().calculateAllInterestsByLockingAtDate(this.getDebitEntry(), lockDate);
    }

    private Currency getRelatedCurrency() {
        if (this.getTariff() != null) {
            return this.getTariff().getFinantialEntity().getFinantialInstitution().getCurrency();
        }
        if (this.getDebitEntry() != null) {
            return this.getDebitEntry().getCurrency();
        }
        return null;
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new InterestRate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(InterestRate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.InterestRate.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTariff(null);
        this_.setDebitEntry(null);
        this_.setInterestRateType(null);
        this_.deleteDomainObject();
    }

    @Deprecated
    public int getNumberOfDaysAfterDueDate() {
        return super.getNumberOfDaysAfterDueDate();
    }

    @Deprecated
    public void setNumberOfDaysAfterDueDate(int numberOfDaysAfterDueDate) {
        super.setNumberOfDaysAfterDueDate(numberOfDaysAfterDueDate);
    }

    @Deprecated
    public int getMaximumDaysToApplyPenalty() {
        return super.getMaximumDaysToApplyPenalty();
    }

    @Deprecated
    public void setMaximumDaysToApplyPenalty(int maximumDaysToApplyPenalty) {
        super.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
    }

    @Deprecated
    public boolean getApplyInFirstWorkday() {
        return super.getApplyInFirstWorkday();
    }

    @Deprecated
    public void setApplyInFirstWorkday(boolean applyInFirstWorkday) {
        super.setApplyInFirstWorkday(applyInFirstWorkday);
    }

    @Deprecated
    public BigDecimal getRate() {
        return super.getRate();
    }

    @Deprecated
    public void setRate(BigDecimal rate) {
        super.setRate(rate);
    }

    @Deprecated
    public InterestType getInterestType() {
        return super.getInterestType();
    }

    @Deprecated
    public void setInterestType(InterestType interestType) {
        super.setInterestType(interestType);
    }

    public static Stream<InterestRate> findAll() {
        return FenixFramework.getDomainRoot().getInterestRatesSet().stream();
    }

    public static InterestRate createForTariff(Tariff tariff, InterestRateType interestRateType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForTariff.perform((Callable)new InterestRate$callable$createForTariff(tariff, interestRateType, n, bl, n2, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForTariff(Tariff tariff, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(tariff, null, interestRateType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, interestFixedAmount, rate);
    }

    public String getUiFullDescription() {
        if (this.getInterestRateType().isInterestFixedAmountRequired()) {
            return this.getInterestRateType().getDescription().getContent() + "-" + this.getRelatedCurrency().getValueFor(this.getInterestFixedAmount());
        }
        return this.getInterestRateType().getDescription().getContent();
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        return (InterestRate)((Object)advice$createForDebitEntry.perform((Callable)new InterestRate$callable$createForDebitEntry(debitEntry, interestRate)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        if (interestRate != null) {
            return new InterestRate(null, debitEntry, interestRate.getInterestRateType(), interestRate.getNumberOfDaysAfterDueDate(), interestRate.getApplyInFirstWorkday(), interestRate.getMaximumDaysToApplyPenalty(), interestRate.getInterestFixedAmount(), interestRate.getRate());
        }
        return null;
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestRateType interestRateType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForDebitEntry$1.perform((Callable)new InterestRate$callable$createForDebitEntry$1(debitEntry, interestRateType, n, bl, n2, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(null, debitEntry, interestRateType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, interestFixedAmount, rate);
    }
}

