/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentpenalty;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxSettings$callable$delete;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxSettings_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentPenaltyTaxSettings
extends PaymentPenaltyTaxSettings_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaymentPenaltyTaxSettings() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setActive(false);
        this.setCreatePaymentCode(false);
        this.setApplyPenaltyOnDebitsWithoutInterest(false);
    }

    public PaymentPenaltyTaxSettings(FinantialEntity finantialEntity, Product penaltyProduct) {
        this();
        this.setFinantialEntity(finantialEntity);
        this.setPenaltyProduct(penaltyProduct);
        this.checkRules();
    }

    private void checkRules() {
        if (super.getDomainRoot() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.domainRoot.required");
        }
        if (this.getFinantialEntity() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.finantialEntity.required");
        }
        if (super.getActive() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.active.required");
        }
        if (Boolean.TRUE.equals(super.getActive()) && this.getEmolumentDescription() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.is.active.but.emolumentDescription.is.null");
        }
        if (Boolean.TRUE.equals(super.getActive()) && this.getPenaltyProduct() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.is.active.but.penaltyProduct.is.null");
        }
        if (super.getCreatePaymentCode() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.createPaymentCode.required");
        }
        if (super.getApplyPenaltyOnDebitsWithoutInterest() == null) {
            throw new IllegalStateException("error.PaymentPenaltyTaxSettings.applyPenaltyOnDebitsWithoutInterest.required");
        }
    }

    public LocalizedString buildEmolumentDescription(DebitEntry originDebitEntry) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("debitEntryDescription", originDebitEntry.getDescription());
            valueMap.put("penaltyProductName", this.getPenaltyProduct().getName().getContent(locale));
            result = result.with(locale, StrSubstitutor.replace((Object)this.getEmolumentDescription().getContent(locale), valueMap));
        }
        return result;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPenaltyTaxSettings$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPenaltyTaxSettings this_) {
        this_.setDomainRoot(null);
        this_.setFinantialEntity(null);
        this_.setPenaltyProduct(null);
        this_.getTargetProductsSet().clear();
        super.deleteDomainObject();
    }

    public void edit(boolean active, Product penaltyProduct, LocalizedString emolumentDescription, boolean createPaymentCode, boolean applyPenaltyOnDebitsWithoutInterest, boolean includePendingInterestsToPaymentCode) {
        super.setActive(Boolean.valueOf(active));
        super.setPenaltyProduct(penaltyProduct);
        super.setEmolumentDescription(emolumentDescription);
        super.setCreatePaymentCode(Boolean.valueOf(createPaymentCode));
        super.setApplyPenaltyOnDebitsWithoutInterest(Boolean.valueOf(applyPenaltyOnDebitsWithoutInterest));
        super.setIncludePendingInterestsToPaymentCode(Boolean.valueOf(includePendingInterestsToPaymentCode));
        this.checkRules();
    }

    public static PaymentPenaltyTaxSettings create(FinantialEntity finantialEntity, Product penaltyProduct) {
        return new PaymentPenaltyTaxSettings(finantialEntity, penaltyProduct);
    }

    public static Stream<PaymentPenaltyTaxSettings> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPenaltyTaxSettingsSet().stream();
    }

    public static Stream<PaymentPenaltyTaxSettings> findActive() {
        return PaymentPenaltyTaxSettings.findAll().filter(s -> Boolean.TRUE.equals(s.getActive()));
    }

    public static Stream<PaymentPenaltyTaxSettings> findActiveForOriginDebitEntry(DebitEntry originDebitEntry) {
        return PaymentPenaltyTaxSettings.findActive().filter(s -> s.getTargetProductsSet().contains((Object)originDebitEntry.getProduct()));
    }
}

