/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.util.TreasuryConstants;

public enum PaymentPlanStateType {
    CLOSED,
    ANNULED,
    OPEN,
    TRANSFERRED,
    NON_COMPLIANCE;


    public boolean isOpen() {
        return this == OPEN;
    }

    public boolean isClosed() {
        return this == CLOSED;
    }

    public boolean isAnnuled() {
        return this == ANNULED;
    }

    public boolean isTransferred() {
        return this == TRANSFERRED;
    }

    public boolean isInNonCompliance() {
        return this == NON_COMPLIANCE;
    }

    public LocalizedString getDescriptionI18N() {
        return TreasuryConstants.treasuryBundleI18N(((Object)((Object)this)).getClass().getSimpleName() + "." + this.name(), new String[0]);
    }

    public static List<PaymentPlanStateType> findAll() {
        ArrayList<PaymentPlanStateType> result = new ArrayList<PaymentPlanStateType>();
        result.add(CLOSED);
        result.add(ANNULED);
        result.add(OPEN);
        result.add(TRANSFERRED);
        result.add(NON_COMPLIANCE);
        return result;
    }
}

