/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.exemption;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption$callable$create;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption$callable$revertExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryExemption
extends TreasuryExemption_Base {
    public static final Advice advice$revertExemption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TreasuryExemption() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryExemption(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String reason, BigDecimal netAmountToExempt, DebitEntry debitEntry) {
        this();
        if (Boolean.TRUE.equals(debitEntry.getCalculatedAmountsOverriden())) {
            throw new TreasuryDomainException("error.DebitEntry.exempt.not.possible.due.to.overriden.calculated.amounts", new String[0]);
        }
        for (CreditEntry creditEntry : debitEntry.getCreditEntriesSet()) {
            if (creditEntry.getFinantialDocument().isAnnulled() || creditEntry.isFromExemption()) continue;
            throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.with.credit.not.from.exemption", new String[0]);
        }
        this.setTreasuryExemptionType(treasuryExemptionType);
        this.setTreasuryEvent(treasuryEvent);
        this.setReason(reason);
        this.setExemptByPercentage(false);
        if (netAmountToExempt.scale() > debitEntry.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netAmountToExempt has scale above the currency decimal places for cents");
        }
        this.setNetAmountToExempt(netAmountToExempt);
        this.setDebitEntry(debitEntry);
        this.setProduct(debitEntry.getProduct());
        this.checkRules();
        if (this.getNetAmountToExempt().scale() > this.getDebitEntry().getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netAmountToExempt has scale above the currency decimal places for cents");
        }
        this.getDebitEntry().exempt(this);
    }

    public void checkRules() {
        if (this.getTreasuryExemptionType() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.treasuryExemptionType.required", new String[0]);
        }
        if (this.getNetAmountToExempt() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.required", new String[0]);
        }
        if (!TreasuryConstants.isPositive(this.getNetAmountToExempt())) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.positive.required", new String[0]);
        }
        if (this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.product.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getReason())) {
            throw new TreasuryDomainException("error.TreasuryExemption.reason.empty", new String[0]);
        }
        if (this.getDebitEntry().isEventAnnuled()) {
            throw new TreasuryDomainException("error.TreasuryExemption.debit.entry.annuled.in.event", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(this.getNetAmountToExempt(), this.getDebitEntry().getAmountWithVat().add(this.getDebitEntry().getNetExemptedAmount()))) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.higher.than.debitEntry", new String[0]);
        }
    }

    public boolean isExemptByPercentage() {
        return super.getExemptByPercentage();
    }

    @Deprecated
    public BigDecimal getExemptedAmount() {
        return this.getNetExemptedAmount();
    }

    public BigDecimal getNetExemptedAmount() {
        if (this.isExemptByPercentage()) {
            throw new TreasuryDomainException("error.TreasuryExemption.exempted.by.percentage.not.supported", new String[0]);
        }
        return this.getNetAmountToExempt();
    }

    public boolean isDeletable() {
        boolean creditNoteIsPreparing = this.getCreditEntry() != null && (this.getCreditEntry().getFinantialDocument() == null || this.getCreditEntry().getFinantialDocument().isPreparing());
        boolean debitNoteIsPreparing = this.getCreditEntry() == null && (this.getDebitEntry().getFinantialDocument() == null || this.getDebitEntry().getFinantialDocument().isPreparing());
        return this.getDebitEntry().isAnnulled() || creditNoteIsPreparing || debitNoteIsPreparing;
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setTreasuryExemptionType(null);
        super.setTreasuryEvent(null);
        super.setProduct(null);
        super.setCreditEntry(null);
        super.deleteDomainObject();
    }

    public void revertExemption() {
        Object object = advice$revertExemption.perform((Callable)new TreasuryExemption$callable$revertExemption(this));
    }

    static /* synthetic */ void advised$revertExemption(TreasuryExemption this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
        if (this_.getCreditEntry() != null) {
            this_.getCreditEntry().getCreditNote().setState(FinantialDocumentStateType.ANNULED);
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            String reason = TreasuryConstants.treasuryBundle("label.TreasuryExemption.revertExemption.credit.note.annulment.message", new String[0]);
            this_.getCreditEntry().getCreditNote().setAnnulledReason(reason);
            this_.getCreditEntry().getCreditNote().setAnnullmentDate(new DateTime());
            this_.getCreditEntry().getCreditNote().setAnnullmentResponsible(!Strings.isNullOrEmpty((String)loggedUsername) ? loggedUsername : "unknown");
        } else if (!this_.getDebitEntry().isAnnulled()) {
            if (this_.getDebitEntry().isProcessedInClosedDebitNote()) {
                throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
            }
            this_.getDebitEntry().revertExemptionIfPossibleInPreparingState(this_);
        }
        super.setDebitEntry(null);
        this_.delete();
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getValueToExempt() {
        return super.getValueToExempt();
    }

    @Deprecated(forRemoval=true)
    public void setValueToExempt(BigDecimal valueToExempt) {
        super.setValueToExempt(valueToExempt);
    }

    public BigDecimal getNetAmountToExempt() {
        return super.getValueToExempt();
    }

    public void setNetAmountToExempt(BigDecimal value) {
        super.setValueToExempt(value);
    }

    public static Stream<TreasuryExemption> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream();
    }

    public static Stream<TreasuryExemption> find(TreasuryExemptionType treasuryExemptionType) {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream().filter(t -> t.getTreasuryExemptionType() == treasuryExemptionType);
    }

    public static Stream<TreasuryExemption> find(TreasuryEvent treasuryEvent) {
        return treasuryEvent.getTreasuryExemptionsSet().stream();
    }

    protected static Stream<TreasuryExemption> find(TreasuryEvent treasuryEvent, Product product) {
        return TreasuryExemption.find(treasuryEvent).filter(t -> t.getProduct() == product);
    }

    public static Optional<TreasuryExemption> findUnique(TreasuryEvent treasuryEvent, Product product) {
        return TreasuryExemption.find(treasuryEvent, product).findFirst();
    }

    public static Stream<TreasuryExemption> findByDebtAccount(DebtAccount debtAccount) {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream().filter(t -> t.getDebitEntry().getDebtAccount() == debtAccount);
    }

    public static TreasuryExemption create(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String string, BigDecimal bigDecimal, DebitEntry debitEntry) {
        return (TreasuryExemption)((Object)advice$create.perform((Callable)new TreasuryExemption$callable$create(treasuryExemptionType, treasuryEvent, string, bigDecimal, debitEntry)));
    }

    static /* synthetic */ TreasuryExemption advised$create(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String reason, BigDecimal netAmountToExempt, DebitEntry debitEntry) {
        return new TreasuryExemption(treasuryExemptionType, treasuryEvent, reason, netAmountToExempt, debitEntry);
    }

    public static TreasuryExemption createForImportation(TreasuryExemptionType treasuryExemptionType, Optional<TreasuryEvent> treasuryEvent, String reason, BigDecimal netAmountToExempt, DebitEntry debitEntry, Optional<CreditEntry> creditEntry) {
        TreasuryExemption treasuryExemption = new TreasuryExemption();
        treasuryExemption.setTreasuryExemptionType(treasuryExemptionType);
        treasuryExemption.setTreasuryEvent(treasuryEvent.orElse(null));
        treasuryExemption.setReason(reason);
        treasuryExemption.setExemptByPercentage(false);
        if (netAmountToExempt.scale() > debitEntry.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netAmountToExempt has scale above the currency decimal places for cents");
        }
        treasuryExemption.setNetAmountToExempt(netAmountToExempt);
        treasuryExemption.setDebitEntry(debitEntry);
        treasuryExemption.setProduct(debitEntry.getProduct());
        treasuryExemption.setCreditEntry(creditEntry.orElse(null));
        return treasuryExemption;
    }
}

