/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.debt;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount$callable$closeDebtAccount;
import org.fenixedu.treasury.domain.debt.DebtAccount$callable$create;
import org.fenixedu.treasury.domain.debt.DebtAccount$callable$delete;
import org.fenixedu.treasury.domain.debt.DebtAccount$callable$reopenDebtAccount;
import org.fenixedu.treasury.domain.debt.DebtAccount$callable$transferBalanceForActiveDebtAccount;
import org.fenixedu.treasury.domain.debt.DebtAccount_Base;
import org.fenixedu.treasury.domain.debt.balancetransfer.BalanceTransferService;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebtAccount
extends DebtAccount_Base {
    public static final Comparator<DebtAccount> COMPARATOR_BY_CUSTOMER_NAME_IGNORE_CASE;
    public static final Comparator<DebtAccount> COMPARATOR_BY_FINANTIAL_INSTITUTION_NAME;
    public static final Advice advice$transferBalanceForActiveDebtAccount;
    public static final Advice advice$closeDebtAccount;
    public static final Advice advice$reopenDebtAccount;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    public DebtAccount() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected DebtAccount(FinantialInstitution finantialInstitution, Customer customer) {
        this();
        this.setCustomer(customer);
        this.setFinantialInstitution(finantialInstitution);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getCustomer() == null) {
            throw new TreasuryDomainException("error.DebtAccount.customer.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.DebtAccount.finantialInstitution.required", new String[0]);
        }
    }

    public BigDecimal getTotalInDebt() {
        BigDecimal amount = BigDecimal.ZERO;
        for (InvoiceEntry invoiceEntry : this.getPendingInvoiceEntriesSet()) {
            if (invoiceEntry.isDebitNoteEntry()) {
                amount = amount.add(invoiceEntry.getOpenAmount());
                continue;
            }
            if (!invoiceEntry.isCreditNoteEntry()) continue;
            amount = amount.subtract(invoiceEntry.getOpenAmount());
        }
        this.getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }

    public BigDecimal getTotalInDebtForAllDebtAccountsOfSameFinantialInstitution() {
        BigDecimal result = BigDecimal.ZERO;
        for (Customer customer : this.getCustomer().getAllCustomers()) {
            if (!DebtAccount.findUnique(this.getFinantialInstitution(), customer).isPresent()) continue;
            result = result.add(DebtAccount.findUnique(this.getFinantialInstitution(), customer).get().getTotalInDebt());
        }
        return result;
    }

    public Set<SibsPaymentRequest> getActiveSibsPaymentRequestsOfPendingDebitEntries() {
        return this.getPendingInvoiceEntriesSet().stream().filter(e -> e.isDebitNoteEntry()).map(DebitEntry.class::cast).flatMap(d -> d.getActiveSibsPaymentRequestsOfPendingDebitEntries().stream()).collect(Collectors.toSet());
    }

    public Set<SibsPaymentRequest> getActiveSibsPaymentRequestsOfPendingInstallments() {
        return this.getActivePaymentPlansSet().stream().flatMap(p -> p.getSortedOpenInstallments().stream()).flatMap(d -> d.getActiveSibsPaymentRequestsOfPendingInstallments().stream()).collect(Collectors.toSet());
    }

    public boolean isClosed() {
        return this.getClosed();
    }

    public void transferBalanceForActiveDebtAccount() {
        Object object = advice$transferBalanceForActiveDebtAccount.perform((Callable)new DebtAccount$callable$transferBalanceForActiveDebtAccount(this));
    }

    static /* synthetic */ void advised$transferBalanceForActiveDebtAccount(DebtAccount this_) {
        if (this_.getCustomer().isActive()) {
            throw new TreasuryDomainException("error.DebtAccount.transfer.from.must.not.be.active", new String[0]);
        }
        Optional<DebtAccount> activeDebtAccount = DebtAccount.findUnique(this_.getFinantialInstitution(), this_.getCustomer().getActiveCustomer());
        if (!activeDebtAccount.isPresent()) {
            throw new TreasuryDomainException("error.DebtAccount.active.debt.account.not.found", new String[0]);
        }
        this_.transferBalance(activeDebtAccount.get());
    }

    private void transferBalance(DebtAccount destinyDebtAccount) {
        if (this.getFinantialInstitution() != destinyDebtAccount.getFinantialInstitution()) {
            throw new RuntimeException("error.DebtAccount.transferBalance.must.be.applied.for.debtAccounts.of.same.finantialInstitution");
        }
        new BalanceTransferService(this, destinyDebtAccount).transferBalance();
    }

    public Stream<? extends InvoiceEntry> pendingInvoiceEntries() {
        return this.getInvoiceEntrySet().stream().filter(x -> x.isPendingForPayment());
    }

    public Set<? extends InvoiceEntry> getPendingInvoiceEntriesSet() {
        return this.pendingInvoiceEntries().collect(Collectors.toSet());
    }

    public void closeDebtAccount() {
        Object object = advice$closeDebtAccount.perform((Callable)new DebtAccount$callable$closeDebtAccount(this));
    }

    static /* synthetic */ void advised$closeDebtAccount(DebtAccount this_) {
        this_.setClosed(true);
    }

    public void reopenDebtAccount() {
        Object object = advice$reopenDebtAccount.perform((Callable)new DebtAccount$callable$reopenDebtAccount(this));
    }

    static /* synthetic */ void advised$reopenDebtAccount(DebtAccount this_) {
        this_.setClosed(false);
    }

    private Set<SettlementNote> getSettlementNoteSet() {
        return this.getFinantialDocumentsSet().stream().filter(x -> x.isSettlementNote()).map(SettlementNote.class::cast).collect(Collectors.toSet());
    }

    public String obtainUITotalInDebt() {
        return this.getFinantialInstitution().getCurrency().getValueFor(this.getTotalInDebt());
    }

    public boolean isDeletable() {
        return this.getFinantialDocumentsSet().isEmpty() && this.getInvoiceEntrySet().isEmpty() && this.getInvoiceSet().isEmpty() && this.getPayorDebitEntriesSet().isEmpty() && this.getForwardPaymentsSet().isEmpty() && this.getPaymentRequestsSet().isEmpty() && this.getTreasuryEventsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new DebtAccount$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(DebtAccount this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.DebtAccount.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setCustomer(null);
        this_.setFinantialInstitution(null);
        this_.deleteDomainObject();
    }

    public BigDecimal calculatePendingInterestAmount() {
        return this.calculatePendingInterestAmount(new DateTime().toLocalDate());
    }

    public BigDecimal calculateTotalPendingInterestAmountForAllDebtAccountsOfSameFinantialInstitution() {
        BigDecimal result = BigDecimal.ZERO;
        for (Customer customer : this.getCustomer().getAllCustomers()) {
            if (!DebtAccount.findUnique(this.getFinantialInstitution(), customer).isPresent()) continue;
            result = result.add(DebtAccount.findUnique(this.getFinantialInstitution(), customer).get().calculatePendingInterestAmount());
        }
        return result;
    }

    private BigDecimal calculatePendingInterestAmount(LocalDate whenToCalculate) {
        BigDecimal interestAmount = BigDecimal.ZERO;
        for (InvoiceEntry invoiceEntry : this.getPendingInvoiceEntriesSet()) {
            if (!invoiceEntry.isDebitNoteEntry()) continue;
            List<InterestRateBean> undebitedInterestRateBeansList = ((DebitEntry)((Object)invoiceEntry)).calculateUndebitedInterestValue(whenToCalculate);
            BigDecimal totalInterestAmount = undebitedInterestRateBeansList.stream().map(bean -> bean.getInterestAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            interestAmount = interestAmount.add(totalInterestAmount);
        }
        return interestAmount;
    }

    public Stream<InvoiceEntry> getActiveInvoiceEntries() {
        return this.getInvoiceEntrySet().stream().filter(x -> x.getFinantialDocument() == null || x.getFinantialDocument() != null && !x.getFinantialDocument().isAnnulled());
    }

    public boolean hasPreparingDocuments() {
        return this.getFinantialDocumentsSet().stream().anyMatch(ie -> ie.isPreparing());
    }

    public boolean hasPreparingDebitNotes() {
        return this.getPendingInvoiceEntriesSet().stream().anyMatch(ie -> ie.isDebitNoteEntry() && ie.getFinantialDocument() != null && ie.getFinantialDocument().isPreparing());
    }

    public boolean hasPreparingCreditNotes() {
        return this.getPendingInvoiceEntriesSet().stream().anyMatch(ie -> ie.isCreditNoteEntry() && ie.getFinantialDocument() != null && ie.getFinantialDocument().isPreparing());
    }

    public boolean hasPreparingSettlementNotes() {
        return this.getPendingInvoiceEntriesSet().stream().anyMatch(ie -> ie.getSettlementEntriesSet().stream().anyMatch(se -> se.getFinantialDocument() != null && se.getFinantialDocument().isPreparing()));
    }

    public Set<PaymentPlan> getActivePaymentPlansSet() {
        return this.getPaymentPlansSet().stream().filter(plan -> plan.getState().isOpen()).collect(Collectors.toSet());
    }

    public Collection<? extends PaymentCodeTarget> getUsedPaymentCodeTargetOfPendingInstallments() {
        HashSet result = Sets.newHashSet();
        for (PaymentPlan paymentPlan : this.getActivePaymentPlansSet()) {
            result.addAll(paymentPlan.getInstallmentsSet().stream().flatMap(inst -> inst.getPaymentCodesSet().stream()).filter(pay -> pay.getPaymentReferenceCode().isUsed()).collect(Collectors.toSet()));
        }
        return result;
    }

    public Set<PaymentPlan> getPaymentPlansNotCompliantSet(LocalDate when) {
        return this.getActivePaymentPlansSet().stream().filter(plan -> !plan.isCompliant(when)).collect(Collectors.toSet());
    }

    public Set<PaymentPlan> getPaymentPlansNotCompliantSet() {
        return this.getPaymentPlansNotCompliantSet(LocalDate.now());
    }

    public static Stream<DebtAccount> findAll() {
        return FenixFramework.getDomainRoot().getDebtAccountsSet().stream();
    }

    public static Stream<DebtAccount> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getDebtAccountsSet().stream();
    }

    public static Stream<DebtAccount> findActiveAdhoc(FinantialInstitution finantialInstitution) {
        return DebtAccount.find(finantialInstitution).filter(x -> x.getCustomer().isAdhocCustomer()).filter(x -> x.getCustomer().isActive());
    }

    public static Stream<DebtAccount> find(Customer customer) {
        return customer.getDebtAccountsSet().stream();
    }

    public static Optional<DebtAccount> findUnique(FinantialInstitution finantialInstitution, Customer customer) {
        return Optional.ofNullable(customer.getDebtAccountFor(finantialInstitution));
    }

    public static SortedSet<DebtAccount> findActiveAdhocDebtAccountsSortedByCustomerName(FinantialInstitution finantialInstitution) {
        TreeSet result = Sets.newTreeSet(COMPARATOR_BY_CUSTOMER_NAME_IGNORE_CASE);
        result.addAll(DebtAccount.findActiveAdhoc(finantialInstitution).collect(Collectors.toSet()));
        return result;
    }

    public static DebtAccount create(FinantialInstitution finantialInstitution, Customer customer) {
        return (DebtAccount)((Object)advice$create.perform((Callable)new DebtAccount$callable$create(finantialInstitution, customer)));
    }

    static /* synthetic */ DebtAccount advised$create(FinantialInstitution finantialInstitution, Customer customer) {
        DebtAccount existing = DebtAccount.findUnique(finantialInstitution, customer).orElse(null);
        if (existing != null) {
            existing.setClosed(false);
            return existing;
        }
        return new DebtAccount(finantialInstitution, customer);
    }

    static {
        advice$transferBalanceForActiveDebtAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$closeDebtAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$reopenDebtAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CUSTOMER_NAME_IGNORE_CASE = (o1, o2) -> {
            int c = Customer.COMPARE_BY_NAME_IGNORE_CASE.compare(o1.getCustomer(), o2.getCustomer());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_FINANTIAL_INSTITUTION_NAME = (o1, o2) -> {
            int c = FinantialInstitution.COMPARATOR_BY_NAME.compare(o1.getFinantialInstitution(), o2.getFinantialInstitution());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

