/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class FixedTariffInterestRateBean
implements ITreasuryBean {
    private InterestRateType interestRateType;
    private List<TreasuryTupleDataSourceBean> interestTypeDataSource = new ArrayList<TreasuryTupleDataSourceBean>();
    private int numberOfDaysAfterDueDate;
    private boolean applyInFirstWorkday;
    private int maximumDaysToApplyPenalty;
    private BigDecimal interestFixedAmount;
    private BigDecimal rate;

    public InterestRateType getInterestRateType() {
        return this.interestRateType;
    }

    public void setInterestRateType(InterestRateType value) {
        this.interestRateType = value;
    }

    public List<TreasuryTupleDataSourceBean> getInterestTypeDataSource() {
        return this.interestTypeDataSource;
    }

    public void setInterestTypeDataSource(List<InterestRateType> value) {
        this.interestTypeDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.toString());
            tuple.setText(x.getDescription().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public int getNumberOfDaysAfterDueDate() {
        return this.numberOfDaysAfterDueDate;
    }

    public void setNumberOfDaysAfterDueDate(int value) {
        this.numberOfDaysAfterDueDate = value;
    }

    public boolean getApplyInFirstWorkday() {
        return this.applyInFirstWorkday;
    }

    public void setApplyInFirstWorkday(boolean value) {
        this.applyInFirstWorkday = value;
    }

    public int getMaximumDaysToApplyPenalty() {
        return this.maximumDaysToApplyPenalty;
    }

    public void setMaximumDaysToApplyPenalty(int value) {
        this.maximumDaysToApplyPenalty = value;
    }

    public BigDecimal getInterestFixedAmount() {
        return this.interestFixedAmount;
    }

    public void setInterestFixedAmount(BigDecimal value) {
        this.interestFixedAmount = value;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal value) {
        this.rate = value;
    }

    public FixedTariffInterestRateBean() {
        InterestRateType.getAvailableInterestRateTypesSortedByName().stream().map(type -> new TreasuryTupleDataSourceBean(type.getExternalId(), type.getDescription().getContent())).collect(Collectors.toCollection(() -> this.interestTypeDataSource));
    }

    public FixedTariffInterestRateBean(InterestRate interestRate) {
        this();
        this.setInterestRateType(interestRate.getInterestRateType());
        this.setNumberOfDaysAfterDueDate(interestRate.getNumberOfDaysAfterDueDate());
        this.setApplyInFirstWorkday(interestRate.getApplyInFirstWorkday());
        this.setMaximumDaysToApplyPenalty(interestRate.getMaximumDaysToApplyPenalty());
        this.setInterestFixedAmount(interestRate.getInterestFixedAmount());
        this.setRate(interestRate.getRate());
    }
}

