/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.MbCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayLog;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.IPaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createLog;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createPaymentReferenceCode;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createPaymentReferenceCodeInstance;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$saveExceptionLog;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class SibsOnlinePaymentsGatewayPaymentCodeGenerator
implements IPaymentCodeGenerator {
    private PaymentCodePool paymentCodePool;
    public static final Advice advice$createPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$saveExceptionLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createPaymentReferenceCodeInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public SibsOnlinePaymentsGatewayPaymentCodeGenerator(PaymentCodePool paymentCodePool) {
        this.paymentCodePool = paymentCodePool;
    }

    @Override
    public PaymentReferenceCode createPaymentReferenceCode(DebtAccount debtAccount, PaymentReferenceCodeBean paymentReferenceCodeBean) {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCode.perform((Callable)new SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createPaymentReferenceCode(this, debtAccount, paymentReferenceCodeBean)));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCode(SibsOnlinePaymentsGatewayPaymentCodeGenerator this_, DebtAccount debtAccount, PaymentReferenceCodeBean bean) {
        BigDecimal paymentAmount = bean.getPaymentAmount();
        PaymentReferenceCode paymentReferenceCode = this_.generateNewCodeFor(debtAccount, paymentAmount, new LocalDate(), new LocalDate().plusMonths(this_.paymentCodePool.getSibsOnlinePaymentsGateway().getNumberOfMonthsToExpirePaymentReferenceCode()), Sets.newHashSet(bean.getSelectedDebitEntries()), Sets.newHashSet(bean.getSelectedInstallments()));
        return paymentReferenceCode;
    }

    private PaymentReferenceCode generateNewCodeFor(DebtAccount debtAccount, BigDecimal amount, LocalDate validFrom, LocalDate validTo, Set<DebitEntry> selectedDebitEntries, Set<Installment> selectedInstallments) {
        long activePaymentCodesOnDebitEntryCount;
        if (!Boolean.TRUE.equals(this.paymentCodePool.getActive())) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.paymentCodePool.not.active", new String[0]);
        }
        for (DebitEntry debitEntry : selectedDebitEntries) {
            activePaymentCodesOnDebitEntryCount = MultipleEntriesPaymentCode.findNewByDebitEntry(debitEntry).count() + MultipleEntriesPaymentCode.findUsedByDebitEntry(debitEntry).count();
            if (activePaymentCodesOnDebitEntryCount < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", debitEntry.getDescription());
        }
        for (Installment installment : selectedInstallments) {
            activePaymentCodesOnDebitEntryCount = MultipleEntriesPaymentCode.findNewByInstallment(installment).count() + MultipleEntriesPaymentCode.findUsedByInstallment(installment).count();
            if (activePaymentCodesOnDebitEntryCount < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", installment.getDescription().getContent());
        }
        SibsOnlinePaymentsGateway sibsGateway = this.paymentCodePool.getSibsOnlinePaymentsGateway();
        String merchantTransactionId = sibsGateway.generateNewMerchantTransactionId();
        SibsOnlinePaymentsGatewayLog log = this.createLog(sibsGateway, debtAccount);
        try {
            FenixFramework.atomic(() -> {
                log.saveMerchantTransactionId(merchantTransactionId);
                log.logRequestSendDate();
            });
            MbCheckoutResultBean checkoutResultBean = sibsGateway.generateMBPaymentReference(amount, validFrom.toDateTimeAtStartOfDay(), validTo.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1), merchantTransactionId);
            String sibsReferenceId = checkoutResultBean.getTransactionId();
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(checkoutResultBean.getTransactionId(), checkoutResultBean.isOperationSuccess(), false, checkoutResultBean.getPaymentGatewayResultCode(), checkoutResultBean.getOperationResultDescription());
                log.saveRequestAndResponsePayload(checkoutResultBean.getRequestLog(), checkoutResultBean.getResponseLog());
                log.savePaymentTypeAndBrand(checkoutResultBean.getPaymentType() != null ? checkoutResultBean.getPaymentType().name() : null, checkoutResultBean.getPaymentBrand() != null ? checkoutResultBean.getPaymentBrand().name() : null);
            });
            if (!checkoutResultBean.isOperationSuccess()) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.request.not.successful", new String[0]);
            }
            String paymentCode = checkoutResultBean.getPaymentReference();
            if (Strings.isNullOrEmpty((String)paymentCode)) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.reference.not.empty", new String[0]);
            }
            if (PaymentReferenceCode.findByReferenceCode(this.paymentCodePool.getEntityReferenceCode(), paymentCode, this.paymentCodePool.getFinantialInstitution()).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
            }
            if (!StringUtils.isEmpty((String)merchantTransactionId) && PaymentReferenceCode.findBySibsMerchantTransactionId(merchantTransactionId).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.sibsMerchantTransaction.found.duplicated", new String[0]);
            }
            if (!StringUtils.isEmpty((String)sibsReferenceId) && PaymentReferenceCode.findBySibsReferenceId(sibsReferenceId).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.sibsReferenceId.found.duplicated", new String[0]);
            }
            return this.createPaymentReferenceCodeInstance(amount, validFrom, validTo, log, paymentCode, merchantTransactionId, sibsReferenceId, selectedDebitEntries, selectedInstallments);
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            this.saveExceptionLog(log, e, isOnlinePaymentsGatewayException);
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = isOnlinePaymentsGatewayException ? "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication" : "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.unknown";
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    private void saveExceptionLog(SibsOnlinePaymentsGatewayLog sibsOnlinePaymentsGatewayLog, Exception exception, boolean bl) {
        Object object = advice$saveExceptionLog.perform((Callable)new SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$saveExceptionLog(this, sibsOnlinePaymentsGatewayLog, exception, bl));
    }

    static /* synthetic */ void advised$saveExceptionLog(SibsOnlinePaymentsGatewayPaymentCodeGenerator this_, SibsOnlinePaymentsGatewayLog log, Exception e, boolean isOnlinePaymentsGatewayException) {
        log.logRequestReceiveDateAndData(null, false, false, null, null);
        log.markExceptionOccuredAndSaveLog(e);
        if (isOnlinePaymentsGatewayException) {
            log.saveRequestAndResponsePayload(((OnlinePaymentsGatewayCommunicationException)((Object)e)).getRequestLog(), ((OnlinePaymentsGatewayCommunicationException)((Object)e)).getResponseLog());
        }
    }

    private PaymentReferenceCode createPaymentReferenceCodeInstance(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, SibsOnlinePaymentsGatewayLog sibsOnlinePaymentsGatewayLog, String string, String string2, String string3, Set<DebitEntry> set, Set<Installment> set2) throws Exception {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCodeInstance.perform((Callable)new SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createPaymentReferenceCodeInstance(this, bigDecimal, localDate, localDate2, sibsOnlinePaymentsGatewayLog, string, string2, string3, set, set2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCodeInstance(SibsOnlinePaymentsGatewayPaymentCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, SibsOnlinePaymentsGatewayLog log, String paymentCode, String sibsMerchantTransactionId, String sibsReferenceId, Set selectedDebitEntries, Set selectedInstallments) throws Exception {
        log.savePaymentCode(paymentCode);
        PaymentReferenceCode paymentReferenceCode = PaymentReferenceCode.createForSibsOnlinePaymentGateway(paymentCode, validFrom, validTo, PaymentReferenceCodeStateType.USED, this_.paymentCodePool, amount, sibsMerchantTransactionId, sibsReferenceId);
        paymentReferenceCode.createPaymentTargetTo(selectedDebitEntries, selectedInstallments, amount);
        return paymentReferenceCode;
    }

    private SibsOnlinePaymentsGatewayLog createLog(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount) {
        return (SibsOnlinePaymentsGatewayLog)((Object)advice$createLog.perform((Callable)new SibsOnlinePaymentsGatewayPaymentCodeGenerator$callable$createLog(this, sibsOnlinePaymentsGateway, debtAccount)));
    }

    static /* synthetic */ SibsOnlinePaymentsGatewayLog advised$createLog(SibsOnlinePaymentsGatewayPaymentCodeGenerator this_, SibsOnlinePaymentsGateway sibsGateway, DebtAccount debtAccount) {
        return SibsOnlinePaymentsGatewayLog.createLogForRequestPaymentCode(sibsGateway, debtAccount);
    }

    @Override
    public PaymentCodePool getReferenceCodePool() {
        return this.paymentCodePool;
    }

    @Override
    public boolean isSibsMerchantTransactionAndReferenceIdRequired() {
        return true;
    }
}

