/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.sap.test;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.generated.sources.saft.sap.AuditFile;
import org.fenixedu.treasury.generated.sources.saft.sap.OrderReferences;
import org.fenixedu.treasury.generated.sources.saft.sap.SourceDocuments;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporterUtils;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SAPExporterTestQuantityDifferentOfOne
extends SAPExporter {
    @Override
    protected String exportFinantialDocumentToXML(FinantialInstitution finantialInstitution, List<FinantialDocument> documents, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        if (documents.isEmpty()) {
            throw new TreasuryDomainException("error.ERPExporter.no.document.to.export", new String[0]);
        }
        SAPExporterTestQuantityDifferentOfOne.checkForUnsetDocumentSeriesNumberInDocumentsToExport(documents);
        documents = this.processCreditNoteSettlementsInclusion(documents);
        DateTime beginDate = ((FinantialDocument)((Object)documents.stream().min((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        DateTime endDate = ((FinantialDocument)((Object)documents.stream().max((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        return this.generateERPFile(finantialInstitution, beginDate, endDate, documents, false, false, preProcessFunctionBeforeSerialize);
    }

    @Override
    protected SourceDocuments.WorkingDocuments.WorkDocument.Line convertToSAFTWorkDocumentLine(InvoiceEntry entry, Map<String, org.fenixedu.treasury.generated.sources.saft.sap.Product> baseProducts) {
        FinantialInstitution institution = entry.getDebtAccount().getFinantialInstitution();
        org.fenixedu.treasury.generated.sources.saft.sap.Product currentProduct = null;
        Product product = entry.getProduct();
        if (product.getCode() != null && baseProducts.containsKey(product.getCode())) {
            currentProduct = baseProducts.get(product.getCode());
        } else {
            currentProduct = SAPExporterTestQuantityDifferentOfOne.convertProductToSAFTProduct(product);
            baseProducts.put(currentProduct.getProductCode(), currentProduct);
        }
        XMLGregorianCalendar documentDateCalendar = null;
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = entry.getFinantialDocument().getDocumentDate();
            documentDateCalendar = SAPExporterTestQuantityDifferentOfOne.convertToXMLDate(dataTypeFactory, documentDate);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        SourceDocuments.WorkingDocuments.WorkDocument.Line line = new SourceDocuments.WorkingDocuments.WorkDocument.Line();
        if (entry.isCreditNoteEntry()) {
            line.setCreditAmount(entry.getNetAmount().setScale(2, RoundingMode.HALF_EVEN));
        } else if (entry.isDebitNoteEntry()) {
            line.setDebitAmount(entry.getNetAmount().setScale(2, RoundingMode.HALF_EVEN));
        }
        if (entry.getFinantialDocument().isExportedInLegacyERP()) {
            if (entry.isCreditNoteEntry()) {
                line.setCreditAmount(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
            } else if (entry.isDebitNoteEntry()) {
                line.setDebitAmount(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
            }
        }
        line.setDescription(StringUtils.abbreviate((String)entry.getDescription(), (int)200));
        List<OrderReferences> orderReferences = line.getOrderReferences();
        if (entry.isCreditNoteEntry()) {
            CreditEntry creditEntry = (CreditEntry)((Object)entry);
            if (creditEntry.getDebitEntry() != null) {
                SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
                metadata.setDescription(creditEntry.getDebitEntry().getERPIntegrationMetadata());
                line.setMetadata(metadata);
                OrderReferences reference = new OrderReferences();
                if (!creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
                    reference.setOriginatingON(creditEntry.getDebitEntry().getFinantialDocument().getUiDocumentNumber());
                } else {
                    reference.setOriginatingON("");
                }
                reference.setOrderDate(documentDateCalendar);
                if (((DebitNote)((Object)creditEntry.getDebitEntry().getFinantialDocument())).isExportedInLegacyERP()) {
                    DebitNote debitNote = (DebitNote)((Object)creditEntry.getDebitEntry().getFinantialDocument());
                    if (!Strings.isNullOrEmpty((String)debitNote.getLegacyERPCertificateDocumentReference())) {
                        if (!creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
                            reference.setOriginatingON(debitNote.getLegacyERPCertificateDocumentReference());
                        }
                    } else {
                        if (!creditEntry.getFinantialDocument().isExportedInLegacyERP() && !institution.getErpIntegrationConfiguration().isCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled()) {
                            throw new TreasuryDomainException("error.ERPExporter.credit.note.of.legacy.debit.note.without.legacyERPCertificateDocumentReference", new String[]{debitNote.getUiDocumentNumber(), creditEntry.getFinantialDocument().getUiDocumentNumber()});
                        }
                        reference.setOriginatingON("");
                    }
                }
                reference.setLineNumber(BigInteger.ONE);
                orderReferences.add(reference);
            }
        } else if (entry.isDebitNoteEntry()) {
            DebitEntry debitEntry = (DebitEntry)((Object)entry);
            SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
            metadata.setDescription(debitEntry.getERPIntegrationMetadata());
            line.setMetadata(metadata);
        }
        line.setProductCode(currentProduct.getProductCode());
        line.setProductDescription(currentProduct.getProductDescription());
        line.setQuantity(entry.getQuantity());
        line.setSettlementAmount(BigDecimal.ZERO);
        line.setTax(this.getSAFTWorkingDocumentsTax(product, entry));
        line.setTaxPointDate(documentDateCalendar);
        if (TreasuryConstants.isEqual(line.getTax().getTaxPercentage(), BigDecimal.ZERO) || line.getTax().getTaxAmount() != null && TreasuryConstants.isEqual(line.getTax().getTaxAmount(), BigDecimal.ZERO)) {
            if (product.getVatExemptionReason() != null) {
                line.setTaxExemptionReason(product.getVatExemptionReason().getCode() + "-" + product.getVatExemptionReason().getName().getContent());
            } else {
                line.setTaxExemptionReason(TreasuryConstants.treasuryBundle("warning.ERPExporter.vat.exemption.unknown", new String[0]));
            }
        }
        line.setUnitOfMeasure(product.getUnitOfMeasure().getContent());
        line.setUnitPrice(TreasuryConstants.divide(entry.getNetAmount(), entry.getQuantity()).setScale(4, RoundingMode.HALF_UP));
        if (entry.getFinantialDocument().isExportedInLegacyERP()) {
            line.setUnitPrice(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
        }
        return line;
    }
}

