/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.meowallet;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$createLogForMbwayPaymentRequest;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$createLogForSibsPaymentRequest;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$createMbwayRequest;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$createMbwayRequest$1;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$delete;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$prepareCheckout;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$processMbwayTransaction;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$processPaymentReferenceCodeTransaction;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$processPaymentStatus;
import org.fenixedu.treasury.domain.meowallet.MeoWallet$callable$saveExceptionLog;
import org.fenixedu.treasury.domain.meowallet.MeoWalletLog;
import org.fenixedu.treasury.domain.meowallet.MeoWallet_Base;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletCallbackBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletCheckoutBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletPaymentBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletPaymentItemBean;
import org.fenixedu.treasury.services.payments.meowallet.MeoWalletService;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MeoWallet
extends MeoWallet_Base
implements IMbwayPaymentPlatformService,
ISibsPaymentCodePoolService,
IForwardPaymentPlatformService {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/returnforwardpayment";
    public static final String STATUS_FAIL = "FAIL";
    public static final String STATUS_COMPLETED = "COMPLETED";
    public static final String STATUS_VOIDED = "VOIDED";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createLogForMbwayPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createLogForSibsPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createMbwayRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createMbwayRequest$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$processMbwayTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$processPaymentReferenceCodeTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$prepareCheckout = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$saveExceptionLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$processPaymentStatus = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MeoWallet() {
    }

    public MeoWallet(FinantialInstitution finantialInstitution, String name, boolean active, String endpointUrl, String authorizationAPIToken) {
        this();
        this.init(finantialInstitution, name, active);
        this.setEndpointUrl(endpointUrl);
        this.setAuthorizationAPIToken(authorizationAPIToken);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbWayPaymentMethod());
        this.checkRules();
    }

    public static MeoWallet create(FinantialInstitution finantialInstitution, String name, boolean active, String endpointUrl, String authorizationAPIToken) {
        return new MeoWallet(finantialInstitution, name, active, endpointUrl, authorizationAPIToken);
    }

    private void checkRules() {
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MeoWallet$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MeoWallet this_) {
        super.delete();
        super.deleteDomainObject();
    }

    public MeoWalletService getMeoWalletService() {
        return new MeoWalletService(this.getEndpointUrl(), this.getAuthorizationAPIToken());
    }

    public String generateNewMerchantTransactionId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static MeoWalletLog createLogForMbwayPaymentRequest(String string, String string2) {
        return (MeoWalletLog)((Object)advice$createLogForMbwayPaymentRequest.perform((Callable)new MeoWallet$callable$createLogForMbwayPaymentRequest(string, string2)));
    }

    static /* synthetic */ MeoWalletLog advised$createLogForMbwayPaymentRequest(String extInvoiceId, String extCustomerId) {
        return MeoWalletLog.createForMbwayPaymentRequest(extInvoiceId, extCustomerId);
    }

    public static MeoWalletLog createLogForSibsPaymentRequest(String string, String string2) {
        return (MeoWalletLog)((Object)advice$createLogForSibsPaymentRequest.perform((Callable)new MeoWallet$callable$createLogForSibsPaymentRequest(string, string2)));
    }

    static /* synthetic */ MeoWalletLog advised$createLogForSibsPaymentRequest(String extInvoiceId, String extCustomerId) {
        return MeoWalletLog.createForSibsPaymentRequest(extInvoiceId, extCustomerId);
    }

    @Override
    public MbwayRequest createMbwayRequest(DebtAccount debtAccount, Set<DebitEntry> set, Set<Installment> set2, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest.perform((Callable)new MeoWallet$callable$createMbwayRequest(this, debtAccount, set, set2, string, string2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ MbwayRequest advised$createMbwayRequest(MeoWallet this_, DebtAccount debtAccount, Set debitEntries, Set installments, String countryPrefix, String localPhoneNumber) {
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(e -> e.getOpenAmountWithInterests()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(i -> i.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        MeoWalletLog log = MeoWallet.createLogForMbwayPaymentRequest(merchantTransactionId, debtAccount.getCustomer().getExternalId());
        ArrayList<MeoWalletPaymentItemBean> items = new ArrayList<MeoWalletPaymentItemBean>();
        debitEntries.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription(), d.getOpenAmountWithInterests())));
        installments.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription().getContent(), d.getOpenAmount())));
        MeoWalletPaymentBean payment = MeoWalletPaymentBean.createMbwayPaymentBean(payableAmount, merchantTransactionId, debtAccount.getCustomer().getExternalId(), debtAccount.getCustomer().getName(), localPhoneNumber, items);
        try {
            MbwayRequest mbwayPaymentRequest = (MbwayRequest)((Object)FenixFramework.atomic(() -> {
                MbwayRequest request = MbwayRequest.create(this, debtAccount, debitEntries, installments, localPhoneNumber, payableAmount, merchantTransactionId);
                log.logRequestSendDate();
                log.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)request))));
                return request;
            }));
            MeoWalletPaymentBean paymentBean = this_.getMeoWalletService().generateMbwayReference(payment);
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(paymentBean.getId(), paymentBean.getType(), paymentBean.getMethod(), paymentBean.getAmount(), paymentBean.getStatus(), !paymentBean.getStatus().equals(STATUS_FAIL));
                log.saveRequest(paymentBean.getRequestLog());
                log.saveResponse(paymentBean.getResponseLog());
                log.setStateCode(mbwayPaymentRequest.getState().name());
                log.setStateDescription(mbwayPaymentRequest.getState().getDescriptionI18N());
                mbwayPaymentRequest.setTransactionId(paymentBean.getId());
            });
            return mbwayPaymentRequest;
        }
        catch (Exception e2) {
            boolean isOnlinePaymentsGatewayException = e2 instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(null, null, null, null, null, false);
                log.logException(e2);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)e2;
                    log.saveRequest(onlineException.getRequestLog());
                    log.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e2 instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e2;
            }
            String message = "error.MeoWallet.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e2, message, new String[0]);
        }
    }

    @Override
    public MbwayRequest createMbwayRequest(SettlementNoteBean settlementNoteBean, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest$1.perform((Callable)new MeoWallet$callable$createMbwayRequest$1(this, settlementNoteBean, string, string2)));
    }

    static /* synthetic */ MbwayRequest advised$createMbwayRequest(MeoWallet this_, SettlementNoteBean settlementNoteBean, String countryPrefix, String localPhoneNumber) {
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(s -> ((InstallmentPaymenPlanBean)s).getInstallment()).map(Installment.class::cast).collect(Collectors.toSet());
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        MeoWalletLog log = MeoWallet.createLogForMbwayPaymentRequest(merchantTransactionId, debtAccount.getCustomer().getExternalId());
        ArrayList<MeoWalletPaymentItemBean> items = new ArrayList<MeoWalletPaymentItemBean>();
        debitEntries.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription(), d.getOpenAmountWithInterests())));
        installments.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription().getContent(), d.getOpenAmount())));
        MeoWalletPaymentBean payment = MeoWalletPaymentBean.createMbwayPaymentBean(payableAmount, merchantTransactionId, debtAccount.getCustomer().getExternalId(), debtAccount.getCustomer().getName(), localPhoneNumber, items);
        try {
            MbwayRequest mbwayPaymentRequest = (MbwayRequest)((Object)FenixFramework.atomic(() -> {
                MbwayRequest request = MbwayRequest.create(this, debtAccount, debitEntries, installments, localPhoneNumber, payableAmount, merchantTransactionId);
                log.logRequestSendDate();
                log.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)request))));
                return request;
            }));
            MeoWalletPaymentBean paymentBean = this_.getMeoWalletService().generateMbwayReference(payment);
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(paymentBean.getId(), paymentBean.getType(), paymentBean.getMethod(), paymentBean.getAmount(), paymentBean.getStatus(), !paymentBean.getStatus().equals(STATUS_FAIL));
                log.saveRequest(paymentBean.getRequestLog());
                log.saveResponse(paymentBean.getResponseLog());
                log.setStateCode(mbwayPaymentRequest.getState().name());
                log.setStateDescription(mbwayPaymentRequest.getState().getDescriptionI18N());
                mbwayPaymentRequest.setTransactionId(paymentBean.getId());
            });
            return mbwayPaymentRequest;
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(null, null, null, null, null, false);
                log.logException(e);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)e;
                    log.saveRequest(onlineException.getRequestLog());
                    log.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.MeoWallet.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    @Override
    public PaymentTransaction processMbwayTransaction(PaymentRequestLog log, DigitalPlatformResultBean bean) {
        return this.processMbwayTransaction((MeoWalletLog)((Object)log), bean);
    }

    public PaymentTransaction processMbwayTransaction(MeoWalletLog meoWalletLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        return (PaymentTransaction)((Object)advice$processMbwayTransaction.perform((Callable)new MeoWallet$callable$processMbwayTransaction(this, meoWalletLog, digitalPlatformResultBean)));
    }

    static /* synthetic */ PaymentTransaction advised$processMbwayTransaction(MeoWallet this_, MeoWalletLog log, DigitalPlatformResultBean bean) {
        MbwayRequest request = (MbwayRequest)((Object)log.getPaymentRequest());
        if (!bean.getMerchantTransactionId().equals(request.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        BigDecimal paidAmount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.payment.date", new String[0]);
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log.markAsDuplicatedTransaction());
            return null;
        }
        try {
            FenixFramework.atomic(() -> log.logRequestSendDate());
            PaymentTransaction transaction = null;
            if (STATUS_COMPLETED.equals(bean.getPaymentResultCode())) {
                try {
                    transaction = (PaymentTransaction)((Object)FenixFramework.atomic(() -> {
                        log.setStateCode(PaymentReferenceCodeStateType.PROCESSED.name());
                        log.savePaymentInfo(paidAmount, paymentDate);
                        Set<SettlementNote> settlementNotes = request.processPayment(paidAmount, paymentDate, bean.getTransactionId(), bean.getMerchantTransactionId());
                        PaymentTransaction paymentTransaction = PaymentTransaction.create((PaymentRequest)((Object)((Object)((Object)request))), bean.getTransactionId(), paymentDate, paidAmount, settlementNotes);
                        log.setPaymentTransaction(paymentTransaction);
                        return paymentTransaction;
                    }));
                }
                catch (Exception e) {
                    FenixFramework.atomic(() -> log.logException(e));
                    throw new RuntimeException(e);
                }
            } else if (STATUS_FAIL.equals(bean.getPaymentResultCode())) {
                FenixFramework.atomic(() -> {
                    log.setStateCode(PaymentReferenceCodeStateType.ANNULLED.name());
                    request.anull();
                });
            }
            return transaction;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> log.logException(e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(InvoiceEntry::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount, false);
    }

    @Override
    @Deprecated
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount, false);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(SettlementNoteBean settlementNoteBean) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (settlementNoteBean.isLimitSibsPaymentRequestToCustomDueDate() && settlementNoteBean.getCustomSibsPaymentRequestDueDate() == null) {
            throw new IllegalArgumentException("customSibsPaymentRequestDueDate is null");
        }
        if (settlementNoteBean.getCustomSibsPaymentRequestDueDate() != null) {
            validTo = settlementNoteBean.getCustomSibsPaymentRequestDueDate();
        }
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount, settlementNoteBean.isLimitSibsPaymentRequestToCustomDueDate());
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequestWithInterests(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate interestsCalculationDate) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(d -> d.getOpenAmountWithInterestsAtDate(interestsCalculationDate)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount, false);
    }

    private SibsPaymentRequest createPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate validTo, BigDecimal payableAmount, boolean limitSibsPaymentRequestToValidTo) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.paymentCodePool.not.active", new String[0]);
        }
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        String merchantTransactionId = this.generateNewMerchantTransactionId();
        ArrayList<MeoWalletPaymentItemBean> items = new ArrayList<MeoWalletPaymentItemBean>();
        debitEntries.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription(), d.getOpenAmountWithInterests())));
        installments.stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription().getContent(), d.getOpenAmount())));
        MeoWalletPaymentBean payment = MeoWalletPaymentBean.createMBPaymentBean(payableAmount, merchantTransactionId, debtAccount.getCustomer().getExternalId(), debtAccount.getCustomer().getName(), items);
        if (limitSibsPaymentRequestToValidTo) {
            payment.setExpires(validTo.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1));
        }
        MeoWalletLog log = MeoWallet.createLogForSibsPaymentRequest(merchantTransactionId, debtAccount.getCustomer().getExternalId());
        try {
            FenixFramework.atomic(() -> log.logRequestSendDate());
            MeoWalletPaymentBean paymentBean = this.getMeoWalletService().generateMBPaymentReference(payment);
            String sibsReferenceId = paymentBean.getId();
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(paymentBean.getId(), paymentBean.getType(), paymentBean.getMethod(), paymentBean.getAmount(), paymentBean.getStatus(), !paymentBean.getStatus().equals(STATUS_FAIL));
                log.saveRequest(paymentBean.getRequestLog());
                log.saveResponse(paymentBean.getResponseLog());
            });
            if (StringUtils.isEmpty((String)paymentBean.getMb().getRef())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.reference.not.empty", new String[0]);
            }
            if (SibsReferenceCode.findByReferenceCode(paymentBean.getMb().getEntity(), paymentBean.getMb().getRef()).count() >= 2L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
            }
            SibsPaymentRequest sibsPaymentRequest = (SibsPaymentRequest)((Object)FenixFramework.atomic(() -> {
                SibsPaymentRequest request = SibsPaymentRequest.create((DigitalPaymentPlatform)((Object)((Object)this)), debtAccount, debitEntries, installments, payableAmount, paymentBean.getMb().getEntity(), paymentBean.getMb().getRef(), merchantTransactionId, sibsReferenceId);
                log.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)request))));
                if (limitSibsPaymentRequestToValidTo) {
                    request.setPaymentDueDate(validTo);
                    request.setExpiresDate(paymentBean.getExpires());
                }
                return request;
            }));
            return sibsPaymentRequest;
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            this.saveExceptionLog(log, e, isOnlinePaymentsGatewayException);
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.unknown";
            if (isOnlinePaymentsGatewayException) {
                message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication";
            }
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    @Override
    public PaymentTransaction processPaymentReferenceCodeTransaction(PaymentRequestLog log, DigitalPlatformResultBean bean) {
        return this.processPaymentReferenceCodeTransaction((MeoWalletLog)((Object)log), bean);
    }

    public PaymentTransaction processPaymentReferenceCodeTransaction(MeoWalletLog meoWalletLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        return (PaymentTransaction)((Object)advice$processPaymentReferenceCodeTransaction.perform((Callable)new MeoWallet$callable$processPaymentReferenceCodeTransaction(this, meoWalletLog, digitalPlatformResultBean)));
    }

    static /* synthetic */ PaymentTransaction advised$processPaymentReferenceCodeTransaction(MeoWallet this_, MeoWalletLog log, DigitalPlatformResultBean bean) {
        SibsPaymentRequest paymentRequest = (SibsPaymentRequest)((Object)log.getPaymentRequest());
        if (!bean.getMerchantTransactionId().equals(paymentRequest.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        String mbEntity = null;
        String mbRef = null;
        if (bean instanceof MeoWalletCallbackBean) {
            mbEntity = ((MeoWalletCallbackBean)bean).getMb_entity();
            mbRef = ((MeoWalletCallbackBean)bean).getMb_ref();
        } else if (bean instanceof MeoWalletPaymentBean) {
            mbEntity = ((MeoWalletPaymentBean)bean).getMb().getEntity();
            mbRef = ((MeoWalletPaymentBean)bean).getMb().getRef();
        }
        if (!mbEntity.equals(paymentRequest.getEntityReferenceCode())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.entityReferenceCode.not.equal", new String[0]);
        }
        if (!mbRef.equals(paymentRequest.getReferenceCode())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.referenceCode.not.equal", new String[0]);
        }
        BigDecimal paidAmount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        FenixFramework.atomic(() -> {
            log.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)paymentRequest))));
            log.savePaymentInfo(paidAmount, paymentDate);
        });
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.payment.date", new String[0]);
        }
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(paymentRequest.getEntityReferenceCode(), paymentRequest.getReferenceCode(), paymentDate)) {
            FenixFramework.atomic(() -> log.markAsDuplicatedTransaction());
            return null;
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log.markAsDuplicatedTransaction());
            return null;
        }
        try {
            FenixFramework.atomic(() -> log.logRequestSendDate());
            PaymentTransaction transaction = null;
            if (STATUS_COMPLETED.equals(bean.getPaymentResultCode())) {
                try {
                    transaction = (PaymentTransaction)((Object)FenixFramework.atomic(() -> {
                        PaymentTransaction processPayment2 = paymentRequest.processPayment(paidAmount, bean.getPaymentDate(), bean.getTransactionId(), null, bean.getMerchantTransactionId(), bean.getPaymentDate(), null, true);
                        log.setStateCode(PaymentReferenceCodeStateType.PROCESSED.name());
                        log.savePaymentInfo(paidAmount, paymentDate);
                        log.setPaymentTransaction(processPayment2);
                        return processPayment2;
                    }));
                }
                catch (Exception e) {
                    FenixFramework.atomic(() -> log.logException(e));
                    throw new RuntimeException(e);
                }
            } else if (STATUS_FAIL.equals(bean.getPaymentResultCode()) || STATUS_VOIDED.equals(bean.getPaymentResultCode())) {
                FenixFramework.atomic(() -> {
                    log.setStateCode(PaymentReferenceCodeStateType.ANNULLED.name());
                    paymentRequest.anull();
                });
            }
            return transaction;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> log.logException(e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPaymentRequest = ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction);
        this.prepareCheckout(forwardPaymentRequest);
        return forwardPaymentRequest;
    }

    public PaymentRequestLog log(PaymentRequest paymentRequest, String statusCode, String statusMessage, String requestBody, String responseBody) {
        MeoWalletLog log = MeoWalletLog.createPaymentRequestLog(paymentRequest, paymentRequest.getCurrentState().getCode(), paymentRequest.getCurrentState().getLocalizedName());
        log.setExtInvoiceId(paymentRequest.getMerchantTransactionId());
        log.setMeoWalletId(paymentRequest.getTransactionId());
        log.setStatusCode(statusCode);
        log.setStatusMessage(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            log.saveRequest(requestBody);
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            log.saveResponse(responseBody);
        }
        return log;
    }

    private ForwardPaymentStatusBean prepareCheckout(ForwardPaymentRequest forwardPaymentRequest) {
        return (ForwardPaymentStatusBean)advice$prepareCheckout.perform((Callable)new MeoWallet$callable$prepareCheckout(this, forwardPaymentRequest));
    }

    static /* synthetic */ ForwardPaymentStatusBean advised$prepareCheckout(MeoWallet this_, ForwardPaymentRequest forwardPayment) {
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setMerchantTransactionId(merchantTransactionId);
        });
        try {
            DateTime requestSendDate = new DateTime();
            ArrayList<MeoWalletPaymentItemBean> items = new ArrayList<MeoWalletPaymentItemBean>();
            forwardPayment.getDebitEntriesSet().stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription(), d.getOpenAmountWithInterests())));
            forwardPayment.getInstallmentsSet().stream().forEach(d -> items.add(new MeoWalletPaymentItemBean(1, d.getDescription().getContent(), d.getOpenAmount())));
            MeoWalletPaymentBean paymentBean = MeoWalletPaymentBean.createForwardPaymentBean(forwardPayment.getPayableAmount(), forwardPayment.getDebtAccount().getCustomer().getName(), items);
            MeoWalletCheckoutBean checkoutBean = new MeoWalletCheckoutBean(paymentBean, forwardPayment.getForwardPaymentSuccessUrl(), forwardPayment.getForwardPaymentInsuccessUrl(), merchantTransactionId, forwardPayment.getDebtAccount().getCustomer().getExternalId(), this_.getMeoWalletService().getMethodsExceptIncluded(this_.getIncludeMethod().split(",")));
            MeoWalletCheckoutBean resultCheckoutBean = this_.getMeoWalletService().prepareOnlinePaymentCheckout(checkoutBean);
            FenixFramework.atomic(() -> {
                forwardPayment.setCheckoutId(resultCheckoutBean.getId());
                forwardPayment.setRedirectUrl(resultCheckoutBean.getUrl_redirect());
            });
            DateTime requestReceiveDate = new DateTime();
            ForwardPaymentStateType stateType = this_.translateForwardPaymentStateType(resultCheckoutBean.getPayment().getStatus());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getRequestLog(), resultCheckoutBean.getResponseLog());
            FenixFramework.atomic(() -> {
                if (!result.isInvocationSuccess() || result.getStateType() == ForwardPaymentStateType.REJECTED) {
                    MeoWalletLog log = (MeoWalletLog)((Object)((Object)((Object)forwardPayment.reject("prepareCheckout", resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getRequestLog(), resultCheckoutBean.getResponseLog()))));
                    log.setRequestSendDate(requestSendDate);
                    log.setRequestReceiveDate(requestReceiveDate);
                } else {
                    MeoWalletLog log = (MeoWalletLog)((Object)((Object)((Object)forwardPayment.advanceToRequestState("prepareCheckout", resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getRequestLog(), resultCheckoutBean.getResponseLog()))));
                    log.setOperationSuccess(result.isInvocationSuccess());
                    log.setRequestSendDate(requestSendDate);
                    log.setRequestReceiveDate(requestReceiveDate);
                }
            });
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(String operationResultType) {
        if (operationResultType == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.unknown.payment.state", new String[0]);
        }
        if (operationResultType.equals(STATUS_COMPLETED)) {
            return ForwardPaymentStateType.PAYED;
        }
        if (operationResultType.equals(STATUS_FAIL)) {
            return ForwardPaymentStateType.REJECTED;
        }
        return ForwardPaymentStateType.REQUESTED;
    }

    public String getReturnURL(ForwardPaymentRequest forwardPayment) {
        return String.format("%s%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), RETURN_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        return request.getRedirectUrl();
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest forwardPayment) {
        try {
            MeoWalletCheckoutBean resultCheckoutBean = this.getMeoWalletService().getForwardPaymentTransactionReportByCheckoutId(forwardPayment.getCheckoutId());
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultCheckoutBean.getPayment().getStatus());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getRequestLog(), resultCheckoutBean.getResponseLog());
            result.editTransactionDetails(resultCheckoutBean.getId(), resultCheckoutBean.getPayment().getModified_date(), resultCheckoutBean.getPayment().getAmount());
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                if (!"ERRO".equals(e.getMessage())) {
                    PaymentRequestLog log = forwardPayment.logException(e);
                    log.setOperationCode("paymentStatus");
                    if (!StringUtils.isEmpty((String)requestBody)) {
                        log.saveRequest(requestBody);
                    }
                    if (!StringUtils.isEmpty((String)responseBody)) {
                        log.saveResponse(responseBody);
                    }
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPayment, String justification, Optional<String> specificTransactionId) {
        if (specificTransactionId.isEmpty()) {
            ForwardPaymentStatusBean statusBean = new ForwardPaymentStatusBean(false, forwardPayment.getState(), "N/A", "N/A", null, null);
            return new PostProcessPaymentStatusBean(statusBean, forwardPayment.getState(), false);
        }
        try {
            DateTime requestSendDate = new DateTime();
            MeoWalletCheckoutBean resultCheckoutBean = this.getMeoWalletService().getForwardPaymentTransactionReportByCheckoutId(specificTransactionId.get());
            DateTime requestReceiveDate = new DateTime();
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultCheckoutBean.getPayment().getStatus());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getPayment().getStatus(), resultCheckoutBean.getRequestLog(), resultCheckoutBean.getResponseLog());
            result.editTransactionDetails(resultCheckoutBean.getPayment().getId(), resultCheckoutBean.getPayment().getModified_date(), resultCheckoutBean.getPayment().getAmount());
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands(resultCheckoutBean.getPayment().getMethod());
            MeoWalletLog log = (MeoWalletLog)((Object)FenixFramework.atomic(() -> {
                MeoWalletLog log2 = new MeoWalletLog("processPaymentStatus", resultCheckoutBean.getPayment().getExt_invoiceid(), resultCheckoutBean.getPayment().getExt_customerid());
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)forwardPayment))));
                return log2;
            }));
            this.processPaymentStatus(log, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private void saveExceptionLog(MeoWalletLog meoWalletLog, Exception exception, boolean bl) {
        Object object = advice$saveExceptionLog.perform((Callable)new MeoWallet$callable$saveExceptionLog(this, meoWalletLog, exception, bl));
    }

    static /* synthetic */ void advised$saveExceptionLog(MeoWallet this_, MeoWalletLog log, Exception e, boolean isOnlinePaymentsGatewayException) {
        log.logRequestReceiveDateAndData(null, null, null, null, null, false);
        log.logException(e);
        if (isOnlinePaymentsGatewayException) {
            log.saveRequest(((OnlinePaymentsGatewayCommunicationException)e).getRequestLog());
            log.saveResponse(((OnlinePaymentsGatewayCommunicationException)e).getResponseLog());
        }
    }

    @Override
    public String getEntityReferenceCode() {
        return "undefined";
    }

    @Override
    public String getLogosJspPage() {
        return null;
    }

    @Override
    public PaymentRequestLog createLogForWebhookNotification() {
        return MeoWalletLog.createLogForWebhookNotification();
    }

    @Override
    public void fillLogForWebhookNotification(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean bean) {
        MeoWalletLog log = (MeoWalletLog)((Object)paymentRequestLog);
        FenixFramework.atomic(() -> {
            log.logRequestReceiveDateAndData(bean.getTransactionId(), "Notification", bean.getPaymentType(), bean.getAmount(), bean.getPaymentResultCode(), !STATUS_FAIL.equals(bean.getPaymentResultCode()));
            log.setExtInvoiceId(bean.getMerchantTransactionId());
            log.setMeoWalletId(bean.getTransactionId());
        });
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.MeoWallet.presentationName", new String[0]);
    }

    @Override
    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        MeoWalletLog log = MeoWalletLog.createForTransationReport(merchantTransationId);
        try {
            List<Object> resultCheckoutBean = new ArrayList();
            FenixFramework.atomic(() -> log.setRequestSendDate(DateTime.now()));
            resultCheckoutBean = this.getMeoWalletService().getPaymentTransactionReportByMerchantTransactionId(merchantTransationId);
            String request = resultCheckoutBean.isEmpty() ? "" : ((MeoWalletPaymentBean)resultCheckoutBean.get(0)).getRequestLog();
            String response = resultCheckoutBean.isEmpty() ? "" : ((MeoWalletPaymentBean)resultCheckoutBean.get(0)).getResponseLog();
            String operationId = resultCheckoutBean.isEmpty() ? "" : ((MeoWalletPaymentBean)resultCheckoutBean.get(0)).getId();
            FenixFramework.atomic(() -> {
                log.setRequestReceiveDate(DateTime.now());
                log.saveRequest(request);
                log.saveResponse(response);
                log.setMeoWalletId(operationId);
            });
            return resultCheckoutBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> log.logException(e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", Optional.of(forwardPayment.getCheckoutId()));
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        ForwardPaymentRequest forwardPayment = (ForwardPaymentRequest)((Object)paymentRequestLog.getPaymentRequest());
        MeoWalletLog log = (MeoWalletLog)((Object)paymentRequestLog);
        MeoWalletCallbackBean bean = (MeoWalletCallbackBean)digitalPlatformResultBean;
        try {
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(bean.getOperation_status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, bean.getOperation_status(), bean.getOperation_status(), "", "");
            result.editTransactionDetails(bean.getOperation_id(), bean.getModified_date(), bean.getAmount());
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands(bean.getMethod());
            this.processPaymentStatus(log, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log2 = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private void processPaymentStatus(MeoWalletLog meoWalletLog, ForwardPaymentRequest forwardPaymentRequest, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
        Object object = advice$processPaymentStatus.perform((Callable)new MeoWallet$callable$processPaymentStatus(this, meoWalletLog, forwardPaymentRequest, postProcessPaymentStatusBean));
    }

    static /* synthetic */ void advised$processPaymentStatus(MeoWallet this_, MeoWalletLog log, ForwardPaymentRequest forwardPayment, PostProcessPaymentStatusBean returnBean) {
        ForwardPaymentStatusBean result = returnBean.getForwardPaymentStatusBean();
        log.setStateCode(result.getStatusCode());
        log.setStateDescription(result.getStateType().getLocalizedName());
        log.setStatusMessage(result.getStatusMessage());
        if (forwardPayment.getState().isPayed() || forwardPayment.getState().isRejected()) {
            log.setTransactionWithPayment(forwardPayment.getState().isPayed());
            log.setOperationCode("processDuplicated");
            log.setOperationSuccess(true);
            return;
        }
        forwardPayment.setTransactionId(result.getTransactionId());
        if (result.isInPayedState()) {
            PaymentTransaction paymentTransaction = forwardPayment.advanceToPaidState(result.getStatusCode(), result.getPayedAmount(), result.getTransactionDate(), result.getTransactionId(), null);
            log.setOperationCode("advanceToPaidState");
            log.setOperationSuccess(true);
            log.setTransactionWithPayment(true);
            log.setPaymentTransaction(paymentTransaction);
            log.saveRequest(result.getRequestBody());
            log.saveResponse(result.getResponseBody());
            log.setMeoWalletId(result.getTransactionId());
            log.savePaymentInfo(result.getPayedAmount(), result.getTransactionDate());
            log.setPaymentMethod(result.getSibsOnlinePaymentBrands());
        } else if (result.isInRejectedState()) {
            forwardPayment.reject();
            log.setOperationCode("postProcessPayment");
            log.setOperationSuccess(false);
            log.setTransactionWithPayment(false);
            log.setMeoWalletId(result.getTransactionId());
        }
    }
}

