/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRateType_Base;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public abstract class InterestRateType
extends InterestRateType_Base {
    public static Comparator<InterestRateType> COMPARE_BY_NAME = (o1, o2) -> o1.getDescription().getContent().compareTo(o2.getDescription().getContent());

    public InterestRateType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setRequiresInterestFixedAmount(false);
    }

    public void init(LocalizedString description) {
        this.setCode(UUID.randomUUID().toString());
        this.setDescription(description);
    }

    protected void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new RuntimeException("error.InterestRateType.domainRoot.required");
        }
        if (this.getCode() == null) {
            throw new RuntimeException("error.InterestRateType.code.required");
        }
        if (this.getDescription() == null) {
            throw new RuntimeException("error.InterestRateType.description.required");
        }
    }

    public abstract InterestRateBean calculateInterests(DebitEntry var1, LocalDate var2, boolean var3);

    public abstract InterestRateBean calculateAllInterestsByLockingAtDate(DebitEntry var1, LocalDate var2);

    public boolean isInterestRateTypeActive() {
        return InterestRateType.getAvailableInterestRateTypesSortedByName().contains((Object)this);
    }

    public boolean isInterestFixedAmountRequired() {
        return Boolean.TRUE.equals(this.getRequiresInterestFixedAmount());
    }

    public LocalizedString getInterestRateTypePresentationName() {
        return InterestRateType.getPresentationName(((Object)((Object)this)).getClass());
    }

    public void activate() {
        TreasurySettings.getInstance().getAvailableInterestRateTypesSet().add(this);
    }

    public void deactivate() {
        TreasurySettings.getInstance().getAvailableInterestRateTypesSet().remove((Object)this);
    }

    public void makeDefault() {
        TreasurySettings.getInstance().setDefaultInterestRateType(this);
    }

    public void delete() {
        super.setDomainRoot(null);
        this.getInterestRateEntriesSet().forEach(e -> e.delete());
        super.deleteDomainObject();
    }

    protected TreeMap<LocalDate, BigDecimal> createdInterestEntriesMap(DebitEntry debitEntry) {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        for (DebitEntry interestDebitEntry : debitEntry.getInterestDebitEntriesSet()) {
            if (interestDebitEntry.isAnnulled() || !TreasuryConstants.isPositive(interestDebitEntry.getAvailableAmountForCredit())) continue;
            LocalDate interestEntryDateTime = interestDebitEntry.getEntryDateTime().toLocalDate();
            result.putIfAbsent(interestEntryDateTime, BigDecimal.ZERO);
            result.put(interestEntryDateTime, result.get(interestEntryDateTime).add(interestDebitEntry.getAvailableAmountForCredit()));
        }
        return result;
    }

    public static LocalizedString getPresentationName(Class<? extends InterestRateType> interestRateTypeClass) {
        try {
            Method method = interestRateTypeClass.getMethod("getPresentationName", new Class[0]);
            return (LocalizedString)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<? extends InterestRateType> findAll() {
        return FenixFramework.getDomainRoot().getInterestRateTypesSet().stream();
    }

    public static Stream<? extends InterestRateType> findByCode(String code) {
        return InterestRateType.findAll().filter(t -> t.getCode().equals(code));
    }

    public static Optional<? extends InterestRateType> findUniqueByCode(String code) {
        return InterestRateType.findByCode(code).findFirst();
    }

    public static Optional<? extends InterestRateType> findUniqueByDescription(String description) {
        return InterestRateType.getAvailableInterestRateTypesSortedByName().stream().filter(type -> type.getDescription().anyMatch(content -> description.equals(content))).findFirst();
    }

    public static List<? extends InterestRateType> getAvailableInterestRateTypesSortedByName() {
        return TreasurySettings.getInstance().getAvailableInterestRateTypesSet().stream().sorted(COMPARE_BY_NAME).collect(Collectors.toList());
    }

    public static InterestRateType getDefaultInterestRateType() {
        return TreasurySettings.getInstance().getDefaultInterestRateType();
    }

    public static <T extends InterestRateType> T create(Class<T> clazz, LocalizedString description) {
        try {
            return (T)((Object)((InterestRateType)((Object)clazz.getConstructor(LocalizedString.class).newInstance(description))));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

