/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator;

import java.util.List;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutNonConsecutiveInstallmentsOverdueValidator_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class WithoutNonConsecutiveInstallmentsOverdueValidator
extends WithoutNonConsecutiveInstallmentsOverdueValidator_Base {
    public WithoutNonConsecutiveInstallmentsOverdueValidator() {
    }

    public WithoutNonConsecutiveInstallmentsOverdueValidator(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        this();
        this.setNumberDaysToTakeEffect(numberDaysToTakeEffect);
        this.setNumberInstallments(numberInstallments);
    }

    public WithoutNonConsecutiveInstallmentsOverdueValidator create(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        return new WithoutNonConsecutiveInstallmentsOverdueValidator(numberInstallments, numberDaysToTakeEffect);
    }

    public String getDescription() {
        return TreasuryConstants.treasuryBundle("org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutNonConsecutiveInstallmentsOverdueValidator.description", String.valueOf(this.getNumberInstallments()), String.valueOf(this.getNumberDaysToTakeEffect()));
    }

    public Boolean validate(LocalDate date, List<Installment> sortedInstallments) {
        return (long)this.getNumberInstallments().intValue() > sortedInstallments.stream().filter(inst -> {
            int numberOfWorkDaysBetween = TreasuryConstants.countNumberOfWorkDaysBetween(inst.getDueDate(), date);
            return inst.isOverdue(date) && numberOfWorkDaysBetween > this.getNumberDaysToTakeEffect();
        }).count();
    }

    protected PaymentPlanValidator clone() {
        return new WithoutNonConsecutiveInstallmentsOverdueValidator(this.getNumberInstallments(), this.getNumberDaysToTakeEffect());
    }
}

