/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFile_Base;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class ForwardPaymentConfigurationFile
extends ForwardPaymentConfigurationFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";

    public ForwardPaymentConfigurationFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isManager(username);
    }

    @Override
    public void delete() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        this.setDomainRoot(null);
        services.deleteFile(this);
        super.deleteDomainObject();
    }

    public static ForwardPaymentConfigurationFile create(String filename, byte[] contents) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        ForwardPaymentConfigurationFile file = new ForwardPaymentConfigurationFile();
        services.createFile(file, filename, CONTENT_TYPE, contents);
        return file;
    }

    public static Stream<ForwardPaymentConfigurationFile> findAll() {
        return FenixFramework.getDomainRoot().getVirtualTPACertificateSet().stream();
    }
}

