/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry$callable$delete;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry_Base;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class FinantialDocumentEntry
extends FinantialDocumentEntry_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public abstract BigDecimal getTotalAmount();

    protected FinantialDocumentEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(DebtAccount debtAccount, FinantialDocument finantialDocument, FinantialEntryType finantialEntryType, BigDecimal amount, String description, DateTime entryDateTime) {
        this.setFinantialDocument(finantialDocument);
        this.setFinantialEntryType(finantialEntryType);
        this.setAmount(amount);
        this.setDescription(description);
        this.setEntryDateTime(entryDateTime);
        super.setCode(String.format("FF-%s-FE-%d", debtAccount.getCustomer().getCode(), debtAccount.getCustomer().nextFinantialDocumentEntryNumber()));
    }

    public void addToFinantialDocument(FinantialDocument finantialDocument) {
        if (this.getFinantialDocument() != null && !this.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.addToFinantialDocument.already.has.closed.or.annulled.finantialDocument", new String[0]);
        }
        this.setFinantialDocument(finantialDocument);
    }

    public void setFinantialDocument(FinantialDocument finantialDocument) {
        if (finantialDocument != null && finantialDocument.isClosed()) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.finantialDocument.is.already.closed", new String[0]);
        }
        super.setFinantialDocument(finantialDocument);
    }

    protected void checkRules() {
        if (this.isFinantialDocumentRequired() && this.getFinantialDocument() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.finantialDocument.required", new String[0]);
        }
        if (this.getFinantialEntryType() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.finantialEntryType.required", new String[0]);
        }
        if (this.getAmount() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.amount.required", new String[0]);
        }
        if (TreasuryConstants.isNegative(this.getAmount())) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.amount.less.than.zero", new String[0]);
        }
    }

    public boolean isFinantialDocumentRequired() {
        return true;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getFinantialDocument() != null && !this.getFinantialDocument().isPreparing()) {
            blockers.add(TreasuryConstants.treasuryBundle("error.finantialdocumententry.cannot.be.deleted.document.is.not.preparing", new String[0]));
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FinantialDocumentEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FinantialDocumentEntry this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setDomainRoot(null);
        if (this_.getFinantialDocument() != null) {
            this_.getFinantialDocument().removeFinantialDocumentEntries(this_);
        }
        this_.setFinantialDocument(null);
        this_.setFinantialEntryType(null);
        this_.deleteDomainObject();
    }

    protected boolean isNegative(BigDecimal value) {
        return !this.isZero(value) && !this.isPositive(value);
    }

    protected boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    protected boolean isPositive(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) < 0;
    }

    protected boolean isGreaterThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public Map<String, String> getPropertiesMap() {
        return TreasuryConstants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public void editPropertiesMap(Map<String, String> propertiesMap) {
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
    }

    public static Stream<? extends FinantialDocumentEntry> findAll() {
        return FenixFramework.getDomainRoot().getFinantialDocumentEntriesSet().stream();
    }

    public static Optional<? extends FinantialDocumentEntry> findUniqueByEntryOrder(FinantialDocument finantialDocument, int entryOrder) {
        return finantialDocument.getFinantialDocumentEntriesSet().stream().filter(e -> e.getEntryOrder() != null && e.getEntryOrder() == entryOrder).findFirst();
    }

    public boolean isAnnulled() {
        return this.getFinantialDocument() != null && this.getFinantialDocument().isAnnulled();
    }

    public abstract BigDecimal getNetAmount();

    public void setCode(String code) {
        super.setCode(code);
    }

    public DebtAccount getDebtAccount() {
        if (this.getFinantialDocument() != null) {
            return this.getFinantialDocument().getDebtAccount();
        }
        return null;
    }

    public static Stream<FinantialDocumentEntry> findByCode(String code) {
        return FenixFramework.getDomainRoot().getFinantialDocumentEntriesSet().stream().filter(entry -> entry.getCode() != null).filter(entry -> entry.getCode().equals(code));
    }

    public static Optional<FinantialDocumentEntry> findUniqueByCode(String code) {
        return FinantialDocumentEntry.findByCode(code).findFirst();
    }

    public static Stream<FinantialDocumentEntry> findByCode(DebtAccount debtAccount, String code) {
        HashSet invoiceEntrySet = new HashSet();
        Set entriesOfFinantialDocuments = debtAccount.getFinantialDocumentsSet().stream().flatMap(document -> document.getFinantialDocumentEntriesSet().stream()).collect(Collectors.toSet());
        invoiceEntrySet.addAll(debtAccount.getInvoiceEntrySet());
        invoiceEntrySet.addAll(entriesOfFinantialDocuments);
        return invoiceEntrySet.stream().filter(document -> document.getCode() != null).filter(document -> document.getCode().equals(code));
    }

    public static Optional<FinantialDocumentEntry> findUniqueByCode(DebtAccount debtAccount, String code) {
        return FinantialDocumentEntry.findByCode(debtAccount, code).findFirst();
    }
}

