/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class PendingDebitEntryBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final String DUE_DATE = "dueDate";
    private static final String PRODUCT_SERIALIZER = "product";
    private Product product;
    private BigDecimal amount;
    private LocalDate dueDate;

    public PendingDebitEntryBean() {
    }

    public PendingDebitEntryBean(Product product, BigDecimal amount, LocalDate dueDate) {
        this.product = product;
        this.amount = amount;
        this.dueDate = dueDate;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product emolumentProduct) {
        this.product = emolumentProduct;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.product.getName().getContent();
    }

    @Override
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public BigDecimal getEntryAmount() {
        return this.amount;
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return this.amount;
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.amount;
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
        this.amount = debtAmount;
    }

    @Override
    public Vat getVat() {
        return null;
    }

    @Override
    public BigDecimal getVatRate() {
        return null;
    }

    @Override
    public boolean isIncluded() {
        return false;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
    }

    @Override
    public boolean isNotValid() {
        return false;
    }

    @Override
    public void setNotValid(boolean notValid) {
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return null;
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return null;
    }

    @Override
    public boolean isForPendingDebitEntry() {
        return true;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(PRODUCT_SERIALIZER, (JsonElement)new JsonPrimitive(this.product.getExternalId()));
        jsonObject.add(DUE_DATE, (JsonElement)new JsonPrimitive(this.dueDate.toString()));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive(this.getSettledAmount().toPlainString()));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.product = (Product)FenixFramework.getDomainObject((String)jsonObject.get(PRODUCT_SERIALIZER).getAsString());
        this.dueDate = LocalDate.parse((String)jsonObject.get(DUE_DATE).getAsString());
        this.amount = jsonObject.get("amount").getAsBigDecimal();
    }
}

