/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$create;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$delete;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$edit;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GlobalInterestRate
extends GlobalInterestRate_Base {
    public static final Comparator<? super GlobalInterestRate> FIRST_DATE_COMPARATOR;
    public static Comparator<GlobalInterestRate> COMPARATOR_BY_YEAR;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected GlobalInterestRate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(LocalDate firstDay, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this.setFirstDay(firstDay);
        this.setYear(firstDay.getYear());
        this.setDescription(description);
        this.setRate(rate);
        this.setApplyPaymentMonth(applyPaymentMonth);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFirstDay() == null) {
            throw new TreasuryDomainException("error.GlobalInterestRate.firstDay.required", new String[0]);
        }
        if (GlobalInterestRate.findByFirstDay(this.getFirstDay()).count() > 1L) {
            throw new TreasuryDomainException("error.GlobalInterestRate.firstDay.duplicated", new String[0]);
        }
        if (this.getRate() == null) {
            throw new TreasuryDomainException("error.GlobalInterestRate.rate.with.valid.value.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getDescription().getContent())) {
            throw new TreasuryDomainException("error.GlobalInterestRate.description.required", new String[0]);
        }
        if (TreasuryConstants.isLessThan(this.getRate(), BigDecimal.ZERO) || TreasuryConstants.isGreaterThan(this.getRate(), TreasuryConstants.HUNDRED_PERCENT)) {
            throw new TreasuryDomainException("error.GlobalInterestRate.rate.with.valid.value.required", new String[0]);
        }
    }

    public void edit(LocalDate localDate, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2) {
        Object object = advice$edit.perform((Callable)new GlobalInterestRate$callable$edit(this, localDate, localizedString, bigDecimal, bl, bl2));
    }

    static /* synthetic */ void advised$edit(GlobalInterestRate this_, LocalDate firstDay, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this_.setYear(firstDay.getYear());
        this_.setFirstDay(firstDay);
        this_.setDescription(description);
        this_.setRate(rate);
        this_.setApplyPaymentMonth(applyPaymentMonth);
        this_.setApplyInFirstWorkday(applyInFirstWorkday);
        this_.checkRules();
    }

    @Deprecated
    public int getYear() {
        return super.getYear();
    }

    public boolean isApplyPaymentMonth() {
        return super.getApplyPaymentMonth();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new GlobalInterestRate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(GlobalInterestRate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.GlobalInterestRate.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static GlobalInterestRate create(LocalDate localDate, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2) {
        return (GlobalInterestRate)((Object)advice$create.perform((Callable)new GlobalInterestRate$callable$create(localDate, localizedString, bigDecimal, bl, bl2)));
    }

    static /* synthetic */ GlobalInterestRate advised$create(LocalDate firstDay, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        GlobalInterestRate globalInterestRate = new GlobalInterestRate();
        globalInterestRate.init(firstDay, description, rate, applyPaymentMonth, applyInFirstWorkday);
        return globalInterestRate;
    }

    public static Stream<GlobalInterestRate> findAll() {
        return FenixFramework.getDomainRoot().getGlobalInterestRatesSet().stream();
    }

    public static Stream<GlobalInterestRate> findByYear(int year) {
        return GlobalInterestRate.findAll().filter(i -> year == i.getYear());
    }

    public static Optional<GlobalInterestRate> findUniqueByYear(int year) {
        return GlobalInterestRate.findByYear(year).findFirst();
    }

    public static Stream<GlobalInterestRate> findByDescription(LocalizedString description) {
        return GlobalInterestRate.findAll().filter(i -> description.equals((Object)i.getDescription()));
    }

    public static Stream<GlobalInterestRate> findByRate(BigDecimal rate) {
        return GlobalInterestRate.findAll().filter(i -> rate.equals(i.getRate()));
    }

    public static Stream<GlobalInterestRate> findByFirstDay(LocalDate date) {
        return GlobalInterestRate.findAll().filter(r -> r.getFirstDay().equals((Object)date));
    }

    public static Optional<GlobalInterestRate> findUniqueAppliedForDate(LocalDate date) {
        return GlobalInterestRate.findAll().filter(r -> !r.getFirstDay().isAfter((ReadablePartial)date)).sorted(FIRST_DATE_COMPARATOR.reversed()).findFirst();
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        FIRST_DATE_COMPARATOR = (o1, o2) -> {
            int c = o1.getFirstDay().compareTo((ReadablePartial)o2.getFirstDay());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_YEAR = (o1, o2) -> {
            int c = Integer.compare(o1.getYear(), o2.getYear());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

