/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.settings;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings$callable$allowPaymentMixingLegacyInvoices;
import org.fenixedu.treasury.domain.settings.TreasurySettings$callable$edit;
import org.fenixedu.treasury.domain.settings.TreasurySettings$callable$getInstance;
import org.fenixedu.treasury.domain.settings.TreasurySettings$callable$restrictPaymentMixingLegacyInvoices;
import org.fenixedu.treasury.domain.settings.TreasurySettings_Base;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasurySettings
extends TreasurySettings_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$restrictPaymentMixingLegacyInvoices = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$allowPaymentMixingLegacyInvoices = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$getInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasurySettings() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public void edit(Currency currency, Product product, Product product2, Integer n, Boolean bl) {
        Object object = advice$edit.perform((Callable)new TreasurySettings$callable$edit(this, currency, product, product2, n, bl));
    }

    static /* synthetic */ void advised$edit(TreasurySettings this_, Currency defaultCurrency, Product interestProduct, Product advancePaymentProduct, Integer numberOfPaymentPlansActivesPerStudent, Boolean canRegisterPaymentWithMultipleMethods) {
        this_.setDefaultCurrency(defaultCurrency);
        this_.setInterestProduct(interestProduct);
        this_.setAdvancePaymentProduct(advancePaymentProduct);
        this_.setNumberOfPaymentPlansActivesPerStudent(numberOfPaymentPlansActivesPerStudent);
        this_.setCanRegisterPaymentWithMultipleMethods(canRegisterPaymentWithMultipleMethods);
    }

    public boolean isRestrictPaymentMixingLegacyInvoices() {
        return this.getRestrictPaymentMixingLegacyInvoices();
    }

    public void restrictPaymentMixingLegacyInvoices() {
        Object object = advice$restrictPaymentMixingLegacyInvoices.perform((Callable)new TreasurySettings$callable$restrictPaymentMixingLegacyInvoices(this));
    }

    static /* synthetic */ void advised$restrictPaymentMixingLegacyInvoices(TreasurySettings this_) {
        this_.setRestrictPaymentMixingLegacyInvoices(true);
    }

    public void allowPaymentMixingLegacyInvoices() {
        Object object = advice$allowPaymentMixingLegacyInvoices.perform((Callable)new TreasurySettings$callable$allowPaymentMixingLegacyInvoices(this));
    }

    static /* synthetic */ void advised$allowPaymentMixingLegacyInvoices(TreasurySettings this_) {
        this_.setRestrictPaymentMixingLegacyInvoices(false);
    }

    protected static Optional<TreasurySettings> findUnique() {
        return FenixFramework.getDomainRoot().getTreasurySettingsSet().stream().findFirst();
    }

    public static synchronized TreasurySettings getInstance() {
        return (TreasurySettings)((Object)advice$getInstance.perform((Callable)new TreasurySettings$callable$getInstance()));
    }

    static synchronized /* synthetic */ TreasurySettings advised$getInstance() {
        if (!TreasurySettings.findUnique().isPresent()) {
            TreasurySettings treasurySettings = new TreasurySettings();
        }
        return TreasurySettings.findUnique().get();
    }

    public void setCreditCardPaymentMethod(PaymentMethod creditCardPaymentMethod) {
        if (this.getCreditCardPaymentMethod() != null) {
            Set platforms = this.getCreditCardPaymentMethod().getDigitalPaymentPlatformPaymentModesSet();
            for (DigitalPaymentPlatformPaymentMode platform : platforms) {
                platform.setPaymentMethod(creditCardPaymentMethod);
            }
        }
        super.setCreditCardPaymentMethod(creditCardPaymentMethod);
    }

    public void setMbPaymentMethod(PaymentMethod mbPaymentMethod) {
        if (this.getMbPaymentMethod() != null) {
            Set platforms = this.getMbPaymentMethod().getDigitalPaymentPlatformPaymentModesSet();
            for (DigitalPaymentPlatformPaymentMode platform : platforms) {
                platform.setPaymentMethod(mbPaymentMethod);
            }
        }
        super.setMbPaymentMethod(mbPaymentMethod);
    }

    public void setMbWayPaymentMethod(PaymentMethod mbWayPaymentMethod) {
        if (this.getMbWayPaymentMethod() != null) {
            Set platforms = this.getMbWayPaymentMethod().getDigitalPaymentPlatformPaymentModesSet();
            for (DigitalPaymentPlatformPaymentMode platform : platforms) {
                platform.setPaymentMethod(mbWayPaymentMethod);
            }
        }
        super.setMbWayPaymentMethod(mbWayPaymentMethod);
    }

    public static String GET_DAYS_AFTER_CREATION_BUNDLE_LABEL_FOR_FIX() {
        return "label.TuitionInstallmentTariff.daysAfterCreation.fix";
    }

    public static String GET_BEST_OF_FIXED_DATE_OR_DAYS_AFTER_CREATION() {
        return "label.TuitionInstallmentTariff.bestOfFixedDateAndDaysAfterCreation.fix";
    }

    public static LocalizedString GET_DUE_DATE_CALCULATION_TYPE_DAYS_AFTER_CREATION_LABEL(DueDateCalculationType enumValue) {
        if (enumValue == DueDateCalculationType.DAYS_AFTER_CREATION || enumValue == DueDateCalculationType.BEST_OF_FIXED_DATE_AND_DAYS_AFTER_CREATION) {
            return TreasuryConstants.treasuryBundleI18N(((Object)((Object)enumValue)).getClass().getSimpleName() + "." + enumValue.name() + ".fix", new String[0]);
        }
        return TreasuryConstants.treasuryBundleI18N(((Object)((Object)enumValue)).getClass().getSimpleName() + "." + enumValue.name(), new String[0]);
    }
}

