/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paypal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpClient;
import com.paypal.http.HttpRequest;
import com.paypal.http.HttpResponse;
import com.paypal.http.serializer.Json;
import com.paypal.orders.AmountBreakdown;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.ApplicationContext;
import com.paypal.orders.Item;
import com.paypal.orders.Money;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.OrdersCaptureRequest;
import com.paypal.orders.OrdersCreateRequest;
import com.paypal.orders.OrdersGetRequest;
import com.paypal.orders.PurchaseUnitRequest;
import fr.opensagres.xdocreport.document.json.JSONObject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.paypal.PayPal$callable$captureOrder;
import org.fenixedu.treasury.domain.paypal.PayPal$callable$processPaymentStatus;
import org.fenixedu.treasury.domain.paypal.PayPalLog;
import org.fenixedu.treasury.domain.paypal.PayPal_Base;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.payments.paypal.PayPalWebhookBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PayPal
extends PayPal_Base
implements IForwardPaymentPlatformService {
    public static final String STATUS_PAID = "COMPLETED";
    public static final String STATUS_FAIL = "VOIDED";
    public static final Advice advice$processPaymentStatus = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$captureOrder = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PayPal() {
    }

    private PayPal(FinantialInstitution finantialInstitution, String name, boolean active, String accountId, String secret, String mode) {
        this();
        this.init(finantialInstitution, name, active);
        this.setAccountId(accountId);
        this.setSecret(secret);
        this.setMode(mode);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        this.checkRules();
    }

    private void checkRules() {
    }

    public static PayPal create(FinantialInstitution finantialInstitution, String name, boolean active, String accountId, String secret, String mode) {
        return new PayPal(finantialInstitution, name, active, accountId, secret, mode);
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.PayPal.presentationName", new String[0]);
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPaymentRequest = ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction);
        this.prepareCheckout(forwardPaymentRequest);
        return forwardPaymentRequest;
    }

    private ForwardPaymentStatusBean prepareCheckout(ForwardPaymentRequest forwardPayment) {
        String merchantTransactionId = UUID.randomUUID().toString().replace("-", "");
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setMerchantTransactionId(merchantTransactionId);
        });
        try {
            DateTime requestSendDate = new DateTime();
            ArrayList items = new ArrayList();
            forwardPayment.getDebitEntriesSet().stream().forEach(d -> items.add(new Item().name(d.getDescription()).unitAmount(new Money().currencyCode(d.getCurrency().getIsoCode()).value(Currency.getValueWithScale(d.getOpenAmountWithInterests()).toString())).quantity(d.getQuantity().toString())));
            forwardPayment.getInstallmentsSet().stream().forEach(d -> items.add(new Item().name(d.getDescription().getContent()).unitAmount(new Money().currencyCode(d.getSortedOpenInstallmentEntries().get(0).getDebitEntry().getCurrency().getCode()).value(Currency.getValueWithScale(d.getOpenAmount()).toString())).quantity("1")));
            OrderRequest orderRequest = new OrderRequest();
            orderRequest.checkoutPaymentIntent("CAPTURE");
            ApplicationContext applicationContext = new ApplicationContext().brandName("FenixEdu").landingPage("LOGIN").cancelUrl(forwardPayment.getForwardPaymentInsuccessUrl()).returnUrl(forwardPayment.getForwardPaymentSuccessUrl()).userAction("PAY_NOW").shippingPreference("NO_SHIPPING");
            orderRequest.applicationContext(applicationContext);
            ArrayList<PurchaseUnitRequest> purchaseUnitRequests = new ArrayList<PurchaseUnitRequest>();
            PurchaseUnitRequest purchaseUnitRequest = new PurchaseUnitRequest();
            purchaseUnitRequest.amountWithBreakdown(new AmountWithBreakdown().currencyCode(((Item)items.get(0)).unitAmount().currencyCode()).value(forwardPayment.getPayableAmount().toString()).amountBreakdown(new AmountBreakdown().itemTotal(new Money().currencyCode(((Item)items.get(0)).unitAmount().currencyCode()).value(forwardPayment.getPayableAmount().toString()))));
            purchaseUnitRequest.items(items);
            purchaseUnitRequest.customId(merchantTransactionId);
            purchaseUnitRequests.add(purchaseUnitRequest);
            orderRequest.purchaseUnits(purchaseUnitRequests);
            orderRequest.processingInstruction("ORDER_COMPLETE_ON_PAYMENT_APPROVAL");
            OrdersCreateRequest request = new OrdersCreateRequest();
            request.header("prefer", "return=representation");
            request.requestBody(orderRequest);
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            String links = order.links().stream().filter(link -> "approve".equals(link.rel())).findFirst().get().href();
            FenixFramework.atomic(() -> {
                forwardPayment.setCheckoutId(order.id());
                forwardPayment.setRedirectUrl(links);
            });
            DateTime requestReceiveDate = new DateTime();
            String requestLog = new JSONObject(new Json().serialize((Object)orderRequest)).toString(4);
            String responseLog = new JSONObject(new Json().serialize(response.result())).toString(4);
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(order.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, order.status(), order.status(), requestLog, responseLog);
            FenixFramework.atomic(() -> {
                if (!result.isInvocationSuccess() || result.getStateType() == ForwardPaymentStateType.REJECTED) {
                    PayPalLog log = (PayPalLog)((Object)((Object)((Object)this.log((PaymentRequest)((Object)((Object)((Object)forwardPayment))), "prepareCheckout", order.status(), requestLog, responseLog))));
                    forwardPayment.reject();
                    log.setRequestSendDate(requestSendDate);
                    log.setRequestReceiveDate(requestReceiveDate);
                } else {
                    PayPalLog log = (PayPalLog)((Object)((Object)((Object)forwardPayment.advanceToRequestState("prepareCheckout", order.status(), order.status(), requestLog, responseLog))));
                    log.setOperationSuccess(result.isInvocationSuccess());
                    log.setRequestSendDate(requestSendDate);
                    log.setRequestReceiveDate(requestReceiveDate);
                }
            });
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public PaymentRequestLog log(PaymentRequest paymentRequest, String statusCode, String statusMessage, String requestBody, String responseBody) {
        PayPalLog log = PayPalLog.createPaymentRequestLog(paymentRequest, paymentRequest.getCurrentState().getCode(), paymentRequest.getCurrentState().getLocalizedName());
        log.setPayPalId(paymentRequest.getTransactionId());
        log.setStatusCode(statusCode);
        log.setStatusMessage(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            log.saveRequest(requestBody);
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            log.saveResponse(responseBody);
        }
        return log;
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(String status) {
        if (status == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.unknown.payment.state", new String[0]);
        }
        if (status.equals(STATUS_PAID)) {
            return ForwardPaymentStateType.PAYED;
        }
        if (status.equals(STATUS_FAIL)) {
            return ForwardPaymentStateType.REJECTED;
        }
        return ForwardPaymentStateType.REQUESTED;
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        return request.getRedirectUrl();
    }

    @Override
    public String getLogosJspPage() {
        return null;
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest paymentRequest) {
        try {
            OrdersGetRequest request = new OrdersGetRequest(paymentRequest.getCheckoutId());
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(order.status());
            String requestLog = paymentRequest.getCheckoutId();
            String responseLog = new JSONObject(new Json().serialize(response.result())).toString(4);
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, order.status(), order.status(), requestLog, responseLog);
            result.editTransactionDetails(order.id(), DateTime.parse((String)(order.updateTime() == null ? order.createTime() : order.updateTime())), order.purchaseUnits().stream().map(unit -> new BigDecimal(unit.amountWithBreakdown().value())).reduce(BigDecimal.ZERO, BigDecimal::add));
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                if (!"ERRO".equals(e.getMessage())) {
                    PaymentRequestLog log = paymentRequest.logException(e);
                    log.setOperationCode("paymentStatus");
                    if (!StringUtils.isEmpty((String)requestBody)) {
                        log.saveRequest(requestBody);
                    }
                    if (!StringUtils.isEmpty((String)responseBody)) {
                        log.saveResponse(responseBody);
                    }
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private HttpClient getClient() {
        Object environment = null;
        environment = "LIVE".equals(this.getMode()) ? new PayPalEnvironment.Live(this.getAccountId(), this.getSecret()) : new PayPalEnvironment.Sandbox(this.getAccountId(), this.getSecret());
        return new PayPalHttpClient((PayPalEnvironment)environment);
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPayment, String justification, Optional<String> specificTransactionId) {
        if (specificTransactionId.isEmpty()) {
            ForwardPaymentStatusBean statusBean = new ForwardPaymentStatusBean(false, forwardPayment.getState(), "N/A", "N/A", null, null);
            return new PostProcessPaymentStatusBean(statusBean, forwardPayment.getState(), false);
        }
        try {
            DateTime requestSendDate = new DateTime();
            OrdersGetRequest request = new OrdersGetRequest(forwardPayment.getCheckoutId());
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            String requestLog = forwardPayment.getCheckoutId();
            String responseLog = new JSONObject(new Json().serialize(response.result())).toString(4);
            Order resultOrder = order;
            if ("APPROVED".equals(order.status())) {
                resultOrder = this.captureOrder(order);
            }
            DateTime requestReceiveDate = new DateTime();
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultOrder.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultOrder.status(), resultOrder.status(), requestLog, responseLog);
            result.editTransactionDetails(resultOrder.id(), DateTime.parse((String)(order.updateTime() == null ? order.createTime() : order.updateTime())), this.getOrderAmount(resultOrder));
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands("TODO");
            String orderId = resultOrder.id();
            PayPalLog log = (PayPalLog)((Object)FenixFramework.atomic(() -> {
                PayPalLog log2 = new PayPalLog("processPaymentStatus", orderId);
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)forwardPayment))));
                return log2;
            }));
            this.processPaymentStatus(log, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private BigDecimal getOrderAmount(Order order) {
        if (STATUS_PAID.equals(order.status())) {
            return order.purchaseUnits().stream().flatMap(unit -> unit.payments().captures().stream()).map(capture -> new BigDecimal(capture.amount().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return order.purchaseUnits().stream().map(unit -> new BigDecimal(unit.amountWithBreakdown().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void processPaymentStatus(PayPalLog payPalLog, ForwardPaymentRequest forwardPaymentRequest, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
        Object object = advice$processPaymentStatus.perform((Callable)new PayPal$callable$processPaymentStatus(this, payPalLog, forwardPaymentRequest, postProcessPaymentStatusBean));
    }

    static /* synthetic */ void advised$processPaymentStatus(PayPal this_, PayPalLog log, ForwardPaymentRequest forwardPayment, PostProcessPaymentStatusBean returnBean) {
        ForwardPaymentStatusBean result = returnBean.getForwardPaymentStatusBean();
        log.setStateCode(result.getStatusCode());
        log.setStateDescription(result.getStateType().getLocalizedName());
        log.setStatusMessage(result.getStatusMessage());
        if (forwardPayment.getState().isPayed() || forwardPayment.getState().isRejected()) {
            log.setTransactionWithPayment(forwardPayment.getState().isPayed());
            log.setOperationCode("processDuplicated");
            log.setOperationSuccess(true);
            return;
        }
        forwardPayment.setTransactionId(result.getTransactionId());
        if (result.isInPayedState()) {
            PaymentTransaction paymentTransaction = forwardPayment.advanceToPaidState(result.getStatusCode(), result.getPayedAmount(), result.getTransactionDate(), result.getTransactionId(), null);
            log.setOperationCode("advanceToPaidState");
            log.setOperationSuccess(true);
            log.setTransactionWithPayment(true);
            log.setPaymentTransaction(paymentTransaction);
            log.saveRequest(result.getRequestBody());
            log.saveResponse(result.getResponseBody());
            log.setPayPalId(result.getTransactionId());
            log.savePaymentInfo(result.getPayedAmount(), result.getTransactionDate());
            log.setPaymentMethod(result.getSibsOnlinePaymentBrands());
        } else if (result.isInRejectedState()) {
            forwardPayment.reject();
            log.setOperationCode("postProcessPayment");
            log.setOperationSuccess(false);
            log.setTransactionWithPayment(false);
            log.setPayPalId(result.getTransactionId());
        }
    }

    @Override
    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", Optional.of(forwardPayment.getCheckoutId()));
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        ForwardPaymentRequest forwardPayment = (ForwardPaymentRequest)((Object)paymentRequestLog.getPaymentRequest());
        PayPalLog log = (PayPalLog)((Object)paymentRequestLog);
        PayPalWebhookBean bean = (PayPalWebhookBean)digitalPlatformResultBean;
        try {
            Order order = bean.getOrder();
            Order resultOrder = bean.getOrder();
            if ("APPROVED".equals(order.status())) {
                resultOrder = this.captureOrder(order);
            }
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultOrder.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultOrder.status(), resultOrder.status(), "", "");
            result.editTransactionDetails(resultOrder.id(), bean.getPaymentDate(), bean.getAmount());
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands(bean.getEvent_type());
            this.processPaymentStatus(log, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                PaymentRequestLog log2 = forwardPayment.logException(e);
                if (!StringUtils.isEmpty((String)requestBody)) {
                    log.saveRequest(requestBody);
                }
                if (!StringUtils.isEmpty((String)responseBody)) {
                    log.saveResponse(responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private Order captureOrder(Order order) throws IOException {
        return (Order)advice$captureOrder.perform((Callable)new PayPal$callable$captureOrder(this, order));
    }

    static /* synthetic */ Order advised$captureOrder(PayPal this_, Order order) throws IOException {
        try {
            OrdersCaptureRequest captureRequest = new OrdersCaptureRequest(order.id());
            captureRequest.requestBody((Object)new OrderRequest());
            HttpResponse captureResponse = this_.getClient().execute((HttpRequest)captureRequest);
            Order resultOrder = (Order)captureResponse.result();
            return resultOrder;
        }
        catch (Exception e) {
            if (e.getMessage().contains("\"issue\":\"ORDER_ALREADY_CAPTURED\"")) {
                OrdersGetRequest request = new OrdersGetRequest(order.id());
                HttpResponse response = this_.getClient().execute((HttpRequest)request);
                return (Order)response.result();
            }
            throw e;
        }
    }
}

