/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.dataproviders;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.reports.dataproviders.AbstractDataProvider;

public class SettlementNoteDataProvider
extends AbstractDataProvider
implements IReportDataProvider {
    protected static final String DOCUMENT_TYPE_KEY = "settlementNoteDocumentType";
    protected static final String DOCUMENT_KEY = "settlementNote";
    protected static final String LINES_KEY = "settlementNoteLines";
    protected static final String PAYMENT_LINES_KEY = "settlementNotePaymentLines";
    protected final List<String> allKeys = new ArrayList<String>();
    protected Map<String, Function<IReportDataProvider, Object>> keysDictionary = new HashMap<String, Function<IReportDataProvider, Object>>();
    private SettlementNote note;

    public SettlementNoteDataProvider(SettlementNote note) {
        this.note = note;
        this.registerKey(DOCUMENT_TYPE_KEY, SettlementNoteDataProvider::handleDocumentTypeKey);
        this.registerKey(DOCUMENT_KEY, SettlementNoteDataProvider::handleDocument);
        this.registerKey(LINES_KEY, SettlementNoteDataProvider::handleLines);
        this.registerKey(PAYMENT_LINES_KEY, SettlementNoteDataProvider::handlePaymentLines);
    }

    private static Object handleDocumentTypeKey(IReportDataProvider provider) {
        SettlementNoteDataProvider invoiceProvider = (SettlementNoteDataProvider)provider;
        return invoiceProvider.note.getFinantialDocumentType().getType().getDescriptionI18N();
    }

    private static Object handleLines(IReportDataProvider provider) {
        SettlementNoteDataProvider invoiceProvider = (SettlementNoteDataProvider)provider;
        return invoiceProvider.note.getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription();
    }

    private static Object handlePaymentLines(IReportDataProvider provider) {
        SettlementNoteDataProvider invoiceProvider = (SettlementNoteDataProvider)provider;
        return invoiceProvider.note.getPaymentEntriesSet();
    }

    private static Object handleDocument(IReportDataProvider provider) {
        SettlementNoteDataProvider invoiceProvider = (SettlementNoteDataProvider)provider;
        return invoiceProvider.note;
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
        arg0.registerCollectionAsField(LINES_KEY);
        arg0.registerCollectionAsField(PAYMENT_LINES_KEY);
    }
}

