/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.dataproviders;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.services.reports.dataproviders.AbstractDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.PaymentReferenceCodeDataProvider;
import org.joda.time.ReadablePartial;

public class DebtAccountDataProvider
extends AbstractDataProvider
implements IReportDataProvider {
    protected static final String DEBT_ACCOUNT_KEY = "debtAccount";
    protected static final String PAYMENT_LINES_KEY = "paymentLines";
    private DebtAccount debtAccount;

    public DebtAccountDataProvider(DebtAccount debtAccount) {
        this(debtAccount, null);
    }

    public DebtAccountDataProvider(DebtAccount debtAccount, List<DebitNote> debitNotesForPaymentLines) {
        this.debtAccount = debtAccount;
        this.registerKey(DEBT_ACCOUNT_KEY, DebtAccountDataProvider::handleDebtAccountKey);
        this.registerKey(PAYMENT_LINES_KEY, DebtAccountDataProvider::handlePaymentsLinesKey);
    }

    private static Object handlePaymentsLinesKey(IReportDataProvider provider) {
        DebtAccountDataProvider debtProvider = (DebtAccountDataProvider)provider;
        ArrayList<PaymentReferenceCodeDataProvider> codesProviders = new ArrayList<PaymentReferenceCodeDataProvider>();
        for (SibsPaymentRequest code : debtProvider.debtAccount.getActiveSibsPaymentRequestsOfPendingDebitEntries()) {
            codesProviders.add(new PaymentReferenceCodeDataProvider(code));
        }
        return codesProviders.stream().sorted((x, y) -> x.getDueDate().compareTo((ReadablePartial)y.getDueDate())).collect(Collectors.toList());
    }

    private static Object handleDebtAccountKey(IReportDataProvider provider) {
        DebtAccountDataProvider invoiceProvider = (DebtAccountDataProvider)provider;
        return invoiceProvider.debtAccount;
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
        arg0.registerCollectionAsField(PAYMENT_LINES_KEY);
    }
}

