/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.services.payments.virtualpaymententries.VirtualPaymentEntryFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class SettlementInterestEntryBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final String INTEREST_DESCRIPTION = "interestDescription";
    private static final String VIRTUAL_PAYMENT_ENTRY_HANDLER = "virtualPaymentEntryHandler";
    private static final String INTEREST_STATIC = "interest";
    private static final String DESCRIPTION = "description";
    private static final long serialVersionUID = 1L;
    private DebitEntry debitEntry;
    private boolean isIncluded = false;
    private InterestRateBean interest;
    private IVirtualPaymentEntryHandler virtualPaymentEntryHandler;
    private Map<String, List<String>> calculationDescription;

    public SettlementInterestEntryBean() {
    }

    public SettlementInterestEntryBean(DebitEntry debitEntry, InterestRateBean interest) {
        this();
        this.debitEntry = debitEntry;
        this.interest = interest;
    }

    public InterestRateBean getInterest() {
        return this.interest;
    }

    public void setInterest(InterestRateBean interest) {
        this.interest = interest;
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public void setDebitEntry(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
    }

    public LocalDate getDocumentDueDate() {
        return this.debitEntry.getFinantialDocument() != null ? this.debitEntry.getFinantialDocument().getDocumentDueDate() : this.debitEntry.getDueDate();
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.getInterest().getDescription();
    }

    @Override
    public boolean isNotValid() {
        return false;
    }

    @Override
    public void setNotValid(boolean notValid) {
    }

    @Override
    public BigDecimal getVatRate() {
        return this.debitEntry.getVatRate();
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return null;
    }

    @Override
    public Vat getVat() {
        VatType vatType = TreasurySettings.getInstance().getInterestProduct().getVatType();
        return Vat.findActiveUnique(vatType, this.debitEntry.getDebtAccount().getFinantialInstitution(), DateTime.now()).get();
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return Collections.emptySet();
    }

    @Override
    public LocalDate getDueDate() {
        return this.debitEntry.getFinantialDocument() != null ? this.debitEntry.getFinantialDocument().getDocumentDueDate() : this.debitEntry.getDueDate();
    }

    @Override
    public BigDecimal getEntryAmount() {
        return null;
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return null;
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.getInterest().getInterestAmount();
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
    }

    @Override
    public boolean isForPendingInterest() {
        return true;
    }

    @Override
    public IVirtualPaymentEntryHandler getVirtualPaymentEntryHandler() {
        return this.virtualPaymentEntryHandler;
    }

    public void setVirtualPaymentEntryHandler(IVirtualPaymentEntryHandler virtualPaymentEntryHandler) {
        this.virtualPaymentEntryHandler = virtualPaymentEntryHandler;
    }

    @Override
    public Map<String, List<String>> getCalculationDescription() {
        return this.calculationDescription;
    }

    public void setCalculationDescription(Map<String, List<String>> calculationDescription) {
        this.calculationDescription = calculationDescription;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getClass().getName()));
        jsonObject.add("debitEntryId", (JsonElement)new JsonPrimitive(this.getDebitEntry().getExternalId()));
        jsonObject.add("included", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isIncluded)));
        jsonObject.add(INTEREST_STATIC, (JsonElement)new JsonPrimitive(this.serializeInterest(this.interest)));
        jsonObject.add(DESCRIPTION, (JsonElement)new JsonPrimitive(this.serializeCalculationDescription(this.calculationDescription)));
        jsonObject.add(VIRTUAL_PAYMENT_ENTRY_HANDLER, (JsonElement)new JsonPrimitive(this.virtualPaymentEntryHandler != null ? this.virtualPaymentEntryHandler.getClass().getName() : ""));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.debitEntry = (DebitEntry)FenixFramework.getDomainObject((String)jsonObject.get("debitEntryId").getAsString());
        this.isIncluded = jsonObject.get("included").getAsBoolean();
        this.calculationDescription = this.deserializeCalculationDescription(jsonObject.get(DESCRIPTION).getAsString());
        this.interest = this.deserializeInterest((JsonObject)new Gson().fromJson(jsonObject.get(INTEREST_STATIC).getAsString(), JsonObject.class));
        for (IVirtualPaymentEntryHandler handler : VirtualPaymentEntryFactory.implementation().getHandlers()) {
            String className = jsonObject.get(VIRTUAL_PAYMENT_ENTRY_HANDLER).getAsString();
            if (!className.equals(handler.getClass().getName())) continue;
            this.virtualPaymentEntryHandler = handler;
        }
    }

    private String serializeInterest(InterestRateBean interest2) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(INTEREST_DESCRIPTION, (JsonElement)new JsonPrimitive(interest2.getDescription()));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)interest2.getInterestAmount()));
        return jsonObject.toString();
    }

    private InterestRateBean deserializeInterest(JsonObject jsonObject) {
        InterestRateBean interestRateBean = new InterestRateBean();
        interestRateBean.setDescription(jsonObject.get(INTEREST_DESCRIPTION).getAsString());
        interestRateBean.setInterestAmount(jsonObject.get("amount").getAsBigDecimal());
        return interestRateBean;
    }

    private String serializeCalculationDescription(Map<String, List<String>> calculationDescription2) {
        Gson gson = new Gson();
        Type listType = new TypeToken<Map<String, List<String>>>(){}.getType();
        return gson.toJson(calculationDescription2, listType);
    }

    private Map<String, List<String>> deserializeCalculationDescription(String asString) {
        Gson gson = new Gson();
        Type listType = new TypeToken<Map<String, List<String>>>(){}.getType();
        return (Map)gson.fromJson(asString, listType);
    }
}

