/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class InstallmentPaymenPlanBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final String INSTALLMENT_OBJECT = "installmentObject";
    private static final long serialVersionUID = 1L;
    private boolean isIncluded;
    private boolean isNotValid;
    private BigDecimal settledAmount;
    private Installment installment;

    public InstallmentPaymenPlanBean() {
    }

    public InstallmentPaymenPlanBean(Installment installment) {
        this.installment = installment;
        this.isIncluded = false;
        this.isNotValid = false;
        this.settledAmount = installment.getOpenAmount();
    }

    public Installment getInstallment() {
        return this.installment;
    }

    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.installment.getDescription().getContent();
    }

    @Override
    public LocalDate getDueDate() {
        return this.installment.getDueDate();
    }

    @Override
    public BigDecimal getEntryAmount() {
        return this.installment.getTotalAmount();
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return this.installment.getOpenAmount();
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.settledAmount;
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
        this.settledAmount = debtAmount;
    }

    @Override
    public Vat getVat() {
        return null;
    }

    @Override
    public BigDecimal getVatRate() {
        return null;
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    @Override
    public boolean isNotValid() {
        return this.isNotValid;
    }

    @Override
    public void setNotValid(boolean notValid) {
        this.isNotValid = notValid;
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return null;
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return this.installment.getInstallmentEntriesSet().stream().map(entry -> entry.getDebitEntry().getDebitNote() != null && entry.getDebitEntry().getDebitNote().getPayorDebtAccount() != null ? entry.getDebitEntry().getDebitNote().getPayorDebtAccount().getCustomer() : entry.getDebitEntry().getDebtAccount().getCustomer()).collect(Collectors.toSet());
    }

    @Override
    public boolean isForInstallment() {
        return true;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getClass().getName()));
        jsonObject.add(INSTALLMENT_OBJECT, (JsonElement)new JsonPrimitive(this.installment.getExternalId()));
        jsonObject.add("included", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isIncluded)));
        jsonObject.add("notValid", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isNotValid)));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive(this.getSettledAmount().toPlainString()));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.installment = (Installment)FenixFramework.getDomainObject((String)jsonObject.get(INSTALLMENT_OBJECT).getAsString());
        this.isIncluded = jsonObject.get("included").getAsBoolean();
        this.isNotValid = jsonObject.get("notValid").getAsBoolean();
        this.settledAmount = jsonObject.get("amount").getAsBigDecimal();
    }
}

