/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes.pool;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodeGeneratorInstance;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$changeAmount;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$changeFinantialInstitution;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$changePooltype;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$changeReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$setNewValidPeriod;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool$callable$update;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool_Base;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.IPaymentCodeGenerator;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class PaymentCodePool
extends PaymentCodePool_Base {
    public static Comparator<PaymentCodePool> COMPARATOR_BY_FINANTIAL_INSTITUTION_AND_NAME;
    public static Comparator<PaymentCodePool> COMPARATOR_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$setNewValidPeriod;
    public static final Advice advice$changePooltype;
    public static final Advice advice$changeFinantialInstitution;
    public static final Advice advice$changeReferenceCode;
    public static final Advice advice$changeAmount;
    public static final Advice advice$update;

    protected PaymentCodePool() {
    }

    protected PaymentCodePool(String name, String entityReferenceCode, Long minReferenceCode, Long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, Boolean active, Boolean useCheckDigit, FinantialInstitution finantialInstitution, DocumentNumberSeries seriesToUseInPayments, PaymentMethod paymentMethod, PaymentCodeGeneratorInstance paymentCodeGeneratorInstance) {
        this();
        this.init(name, entityReferenceCode, minReferenceCode, maxReferenceCode, minAmount, maxAmount, validFrom, validTo, active, useCheckDigit, finantialInstitution, seriesToUseInPayments, paymentMethod, paymentCodeGeneratorInstance);
    }

    protected void init(String name, String entityReferenceCode, Long minReferenceCode, Long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, Boolean active, Boolean useCheckDigit, FinantialInstitution finantialInstitution, DocumentNumberSeries seriesToUseInPayments, PaymentMethod paymentMethod, PaymentCodeGeneratorInstance paymentCodeGeneratorInstance) {
        this.setName(name);
        this.setEntityReferenceCode(entityReferenceCode);
        this.setNextReferenceCode(minReferenceCode);
        this.setMinReferenceCode(minReferenceCode);
        this.setMaxReferenceCode(maxReferenceCode);
        this.setMinAmount(minAmount);
        this.setMaxAmount(maxAmount);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
        this.setActive(active);
        this.setUseCheckDigit(useCheckDigit);
        this.setFinantialInstitution(finantialInstitution);
        this.setPaymentMethod(paymentMethod);
        this.setDocumentSeriesForPayments(seriesToUseInPayments);
        this.setPaymentCodeGeneratorInstance(paymentCodeGeneratorInstance);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.finantialInstitution.required", new String[0]);
        }
        if (this.getFinantialInstitution().getSibsConfiguration() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.finantialInstitution.sibsconfiguration.required", new String[0]);
        }
        Set allPools = PaymentCodePool.findByActive(true, this.getFinantialInstitution()).collect(Collectors.toSet());
        for (PaymentCodePool pool : allPools) {
            if (pool.equals((Object)this) || !pool.getEntityReferenceCode().equals(this.getEntityReferenceCode())) continue;
            if (this.getMinReferenceCode() >= pool.getMinReferenceCode() && this.getMinReferenceCode() <= pool.getMaxReferenceCode()) {
                throw new TreasuryDomainException("error.PaymentCodePool.invalid.reference.range.cross.other.pools", new String[0]);
            }
            if (this.getMaxReferenceCode() < pool.getMinReferenceCode() || this.getMaxReferenceCode() > pool.getMinReferenceCode()) continue;
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.reference.range.cross.other.pools", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.PaymentCodePool.name.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getEntityReferenceCode())) {
            throw new TreasuryDomainException("error.PaymentCodePool.entityReferenceCode.required", new String[0]);
        }
        if (this.getMinReferenceCode() <= 0L || this.getMinReferenceCode() >= this.getMaxReferenceCode()) {
            throw new TreasuryDomainException("error.PaymentCodePool.MinReferenceCode.invalid", new String[0]);
        }
        if (this.getValidFrom() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.validFrom.required", new String[0]);
        }
        if (this.getValidTo() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.validTo.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.PaymentCodePool.name.required", new String[0]);
        }
        if (this.getMaxAmount().compareTo(this.getMinAmount()) < 0) {
            throw new TreasuryDomainException("error.PaymentCodePool.MinMaxAmount.invalid", new String[0]);
        }
        if (this.getValidTo().isBefore((ReadablePartial)this.getValidFrom())) {
            throw new TreasuryDomainException("error.PaymentCodePool.ValiddFrom.ValidTo.invalid", new String[0]);
        }
        if (this.getDocumentSeriesForPayments() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.documentSeriesForPayments.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.paymentMethod.required", new String[0]);
        }
        if (this.getFinantialInstitution() != this.getDocumentSeriesForPayments().getSeries().getFinantialInstitution()) {
            throw new TreasuryDomainException("error.PaymentCodePool.documentNumberSeriesForPayments.invalid.finantialInstitution", new String[0]);
        }
        if (this.getPaymentCodeGeneratorInstance() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.documentNumberSeriesForPayments.invalid.paymentCodeGeneratorInstance", new String[0]);
        }
    }

    public boolean isGenerateReferenceCodeOnDemand() {
        return this.getGenerateReferenceCodeOnDemand();
    }

    @Deprecated
    public void edit(String string, Boolean bl, DocumentNumberSeries documentNumberSeries, PaymentMethod paymentMethod) {
        Object object = advice$edit.perform((Callable)new PaymentCodePool$callable$edit(this, string, bl, documentNumberSeries, paymentMethod));
    }

    static /* synthetic */ void advised$edit(PaymentCodePool this_, String name, Boolean active, DocumentNumberSeries seriesToUseInPayments, PaymentMethod paymentMethod) {
        this_.setName(name);
        this_.setActive(active);
        this_.setDocumentSeriesForPayments(seriesToUseInPayments);
        this_.setPaymentMethod(paymentMethod);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentCodePool$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentCodePool this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentCodePool.cannot.delete", new String[0]);
        }
        if (this_.getSibsOnlinePaymentsGateway() != null) {
            throw new TreasuryDomainException("error.PaymentCodePool.remove.sibs.oppwa.configuration.first", new String[0]);
        }
        this_.setDocumentSeriesForPayments(null);
        this_.setFinantialInstitution(null);
        this_.setPaymentCodeGeneratorInstance(null);
        this_.deleteDomainObject();
    }

    public IPaymentCodeGenerator getPaymentCodeGenerator() {
        return this.getPaymentCodeGeneratorInstance().getPaymentCodeGenerator(this);
    }

    public static PaymentCodePool create(String string, String string2, Long l, Long l2, BigDecimal bigDecimal, BigDecimal bigDecimal2, LocalDate localDate, LocalDate localDate2, Boolean bl, Boolean bl2, FinantialInstitution finantialInstitution, DocumentNumberSeries documentNumberSeries, PaymentMethod paymentMethod, PaymentCodeGeneratorInstance paymentCodeGeneratorInstance) {
        return (PaymentCodePool)((Object)advice$create.perform((Callable)new PaymentCodePool$callable$create(string, string2, l, l2, bigDecimal, bigDecimal2, localDate, localDate2, bl, bl2, finantialInstitution, documentNumberSeries, paymentMethod, paymentCodeGeneratorInstance)));
    }

    static /* synthetic */ PaymentCodePool advised$create(String name, String entityReferenceCode, Long minReferenceCode, Long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, Boolean active, Boolean useCheckDigit, FinantialInstitution finantialInstitution, DocumentNumberSeries seriesToUseInPayments, PaymentMethod paymentMethod, PaymentCodeGeneratorInstance paymentCodeGeneratorInstance) {
        if (finantialInstitution.getSibsConfiguration() == null || finantialInstitution.getSibsConfiguration() == null && !entityReferenceCode.equals(finantialInstitution.getSibsConfiguration().getEntityReferenceCode())) {
            throw new TreasuryDomainException("error.administration.payments.sibs.managepaymentcodepool.invalid.entity.reference.code.from.finantial.institution", new String[0]);
        }
        return new PaymentCodePool(name, entityReferenceCode, minReferenceCode, maxReferenceCode, minAmount, maxAmount, validFrom, validTo, active, useCheckDigit, finantialInstitution, seriesToUseInPayments, paymentMethod, paymentCodeGeneratorInstance);
    }

    public static Stream<PaymentCodePool> findAll() {
        HashSet codes = new HashSet();
        return FenixFramework.getDomainRoot().getFinantialInstitutionsSet().stream().map(x -> x.getPaymentCodePoolsSet()).reduce(codes, (a, b) -> {
            a.addAll(b);
            return a;
        }).stream();
    }

    public static Stream<PaymentCodePool> findByName(String name, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findByFinantialInstitution(finantialInstitution).filter(i -> name.equalsIgnoreCase(i.getName()));
    }

    public static Stream<PaymentCodePool> findByMinPaymentCodes(Integer minPaymentCodes, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findByFinantialInstitution(finantialInstitution).filter(i -> minPaymentCodes.equals(i.getMinReferenceCode()));
    }

    public static Stream<PaymentCodePool> findByMaxPaymentCodes(Integer maxPaymentCodes, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findByFinantialInstitution(finantialInstitution).filter(i -> maxPaymentCodes.equals(i.getMaxReferenceCode()));
    }

    public static Stream<PaymentCodePool> findByMinAmount(BigDecimal minAmount, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findByFinantialInstitution(finantialInstitution).filter(i -> minAmount.equals(i.getMinAmount()));
    }

    public static Stream<PaymentCodePool> findByMaxAmount(BigDecimal maxAmount, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findAll().filter(i -> maxAmount.equals(i.getMaxAmount()));
    }

    public static Stream<PaymentCodePool> findByActive(Boolean active, FinantialInstitution finantialInstitution) {
        return PaymentCodePool.findAll().filter(i -> active.equals(i.getActive()));
    }

    public static Stream<PaymentCodePool> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getPaymentCodePoolsSet().stream();
    }

    public IPaymentCodeGenerator getReferenceCodeGenerator() {
        return this.getPaymentCodeGeneratorInstance().getPaymentCodeGenerator(this);
    }

    public Long getAndIncrementNextReferenceCode() {
        Long nextReferenceCode = this.getNextReferenceCode();
        this.setNextReferenceCode(nextReferenceCode + 1L);
        return nextReferenceCode;
    }

    public void setNewValidPeriod(LocalDate localDate, LocalDate localDate2) {
        Object object = advice$setNewValidPeriod.perform((Callable)new PaymentCodePool$callable$setNewValidPeriod(this, localDate, localDate2));
    }

    static /* synthetic */ void advised$setNewValidPeriod(PaymentCodePool this_, LocalDate validFrom, LocalDate validTo) {
        if (this_.getPaymentReferenceCodesSet().size() > 0 && (this_.getValidFrom().compareTo((ReadablePartial)validFrom) != 0 || this_.getValidTo().compareTo((ReadablePartial)validTo) != 0)) {
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.change.state.with.generated.references", new String[0]);
        }
        this_.setValidFrom(validFrom);
        this_.setValidTo(validTo);
        this_.checkRules();
    }

    public void changePooltype(Boolean bl) {
        Object object = advice$changePooltype.perform((Callable)new PaymentCodePool$callable$changePooltype(this, bl));
    }

    static /* synthetic */ void advised$changePooltype(PaymentCodePool this_, Boolean useCheckDigit) {
        if (this_.getPaymentReferenceCodesSet().size() > 0 && this_.getUseCheckDigit() != useCheckDigit) {
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.change.state.with.generated.references", new String[0]);
        }
        this_.setUseCheckDigit(useCheckDigit);
        this_.checkRules();
    }

    public void changeFinantialInstitution(FinantialInstitution finantialInstitution) {
        Object object = advice$changeFinantialInstitution.perform((Callable)new PaymentCodePool$callable$changeFinantialInstitution(this, finantialInstitution));
    }

    static /* synthetic */ void advised$changeFinantialInstitution(PaymentCodePool this_, FinantialInstitution finantialInstitution) {
        if (this_.getPaymentReferenceCodesSet().size() > 0 && this_.getFinantialInstitution() != finantialInstitution) {
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.change.state.with.generated.references", new String[0]);
        }
        this_.setFinantialInstitution(finantialInstitution);
        this_.checkRules();
    }

    public void changeReferenceCode(String string, Long l, Long l2) {
        Object object = advice$changeReferenceCode.perform((Callable)new PaymentCodePool$callable$changeReferenceCode(this, string, l, l2));
    }

    static /* synthetic */ void advised$changeReferenceCode(PaymentCodePool this_, String entityReferenceCode, Long minReferenceCode, Long maxReferenceCode) {
        if (!(this_.getPaymentReferenceCodesSet().size() <= 0 || this_.getEntityReferenceCode().equals(entityReferenceCode) && this_.getMinReferenceCode().equals(minReferenceCode) && this_.getMaxReferenceCode().equals(maxReferenceCode))) {
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.change.state.with.generated.references", new String[0]);
        }
        this_.setEntityReferenceCode(entityReferenceCode);
        this_.setMinReferenceCode(minReferenceCode);
        this_.setMaxReferenceCode(maxReferenceCode);
        this_.checkRules();
    }

    public void changeAmount(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$changeAmount.perform((Callable)new PaymentCodePool$callable$changeAmount(this, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$changeAmount(PaymentCodePool this_, BigDecimal minAmount, BigDecimal maxAmount) {
        if (this_.getPaymentReferenceCodesSet().size() > 0 && (this_.getMinAmount().compareTo(minAmount) != 0 || this_.getMaxAmount().compareTo(maxAmount) != 0)) {
            throw new TreasuryDomainException("error.PaymentCodePool.invalid.change.state.with.generated.references", new String[0]);
        }
        this_.setMinAmount(minAmount);
        this_.setMaxAmount(maxAmount);
        this_.checkRules();
    }

    @Deprecated
    public void update(FinantialInstitution finantialInstitution, String string, String string2, Long l, Long l2, BigDecimal bigDecimal, BigDecimal bigDecimal2, LocalDate localDate, LocalDate localDate2, Boolean bl, Boolean bl2, DocumentNumberSeries documentNumberSeries, PaymentMethod paymentMethod) {
        Object object = advice$update.perform((Callable)new PaymentCodePool$callable$update(this, finantialInstitution, string, string2, l, l2, bigDecimal, bigDecimal2, localDate, localDate2, bl, bl2, documentNumberSeries, paymentMethod));
    }

    static /* synthetic */ void advised$update(PaymentCodePool this_, FinantialInstitution finantialInstitution, String name, String entityReferenceCode, Long minReferenceCode, Long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, Boolean active, Boolean useCheckDigit, DocumentNumberSeries seriesToUseInPayments, PaymentMethod paymentMethod) {
        this_.edit(name, active, seriesToUseInPayments, paymentMethod);
        this_.setNewValidPeriod(validFrom, validTo);
        this_.changeFinantialInstitution(finantialInstitution);
        this_.changePooltype(useCheckDigit);
        this_.changeReferenceCode(entityReferenceCode, minReferenceCode, maxReferenceCode);
        this_.changeAmount(minAmount, maxAmount);
    }

    public void update(String name, Long minReferenceCode, Long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, Boolean active) {
        this.edit(name, active, this.getDocumentSeriesForPayments(), this.getPaymentMethod());
        this.setNewValidPeriod(validFrom, validTo);
        this.changeReferenceCode(this.getEntityReferenceCode(), minReferenceCode, maxReferenceCode);
        this.changeAmount(minAmount, maxAmount);
    }

    public static Stream<PaymentCodePool> findByEntityCode(String entityCode) {
        return PaymentCodePool.findAll().filter(x -> x.getEntityReferenceCode().equals(entityCode));
    }

    public List<PaymentReferenceCode> getPaymentCodesToExport(LocalDate localDate) {
        if (this.getUseCheckDigit().booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        return this.getPaymentReferenceCodesSet().stream().filter(x -> !x.isProcessed()).filter(x -> !x.isAnnulled()).filter(x -> !x.getEndDate().isBefore((ReadablePartial)localDate)).collect(Collectors.toList());
    }

    public List<PaymentReferenceCode> getAnnulledPaymentCodesToExport(LocalDate localDate) {
        if (this.getUseCheckDigit().booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        return this.getPaymentReferenceCodesSet().stream().filter(x -> x.getState().equals(PaymentReferenceCodeStateType.ANNULLED)).filter(x -> x.getValidInterval().contains((ReadableInstant)localDate.toDateTimeAtStartOfDay())).collect(Collectors.toList());
    }

    public void updatePoolReferences() {
        if (this.getUseCheckDigit().booleanValue()) {
            // empty if block
        }
    }

    public boolean getIsFixedAmount() {
        return this.getUseCheckDigit();
    }

    public boolean getIsVariableTimeWindow() {
        return this.getUseCheckDigit() == false;
    }

    public static boolean isReferenceCodesActiveForStudentPortal(FinantialInstitution finantialInstitution) {
        return SibsPaymentCodePool.findForSibsPaymentCodeServiceByActive((FinantialInstitution)finantialInstitution, (boolean)true).findFirst().isPresent() && ("502488603".equals(finantialInstitution.getCode()) || "FMV".equals(finantialInstitution.getCode()));
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setNewValidPeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changePooltype = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changeFinantialInstitution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changeReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changeAmount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$update = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_FINANTIAL_INSTITUTION_AND_NAME = (o1, o2) -> {
            int c = FinantialInstitution.COMPARATOR_BY_NAME.compare(o1.getFinantialInstitution(), o2.getFinantialInstitution());
            if (c != 0) {
                return c;
            }
            c = o1.getName().compareTo(o2.getName());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARATOR_BY_NAME = (o1, o2) -> {
            int c = o1.getName().compareTo(o2.getName());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

