/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes.integration;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool$callable$createPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool_Base;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.CheckDigitGenerator;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPaymentCodePool
extends SibsPaymentCodePool_Base
implements ISibsPaymentCodePoolService {
    private static final String CODE_FILLER = "0";
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 7;
    public static final Advice advice$createPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SibsPaymentCodePool() {
    }

    protected SibsPaymentCodePool(FinantialInstitution finantialInstitution, String name, boolean active, String entityReferenceCode, long minReferenceCode, long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, boolean useCheckDigit, boolean generateReferenceCodeOnDemand, String sourceInstitutionId, String destinationInstitutionId) {
        this();
        super.init(finantialInstitution, name, active);
        this.setEntityReferenceCode(entityReferenceCode);
        this.setMinReferenceCode(minReferenceCode);
        this.setMaxReferenceCode(maxReferenceCode);
        this.setMinAmount(minAmount);
        this.setMaxAmount(maxAmount);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
        this.setUseCheckDigit(useCheckDigit);
        this.setGenerateReferenceCodeOnDemand(generateReferenceCodeOnDemand);
        this.setSourceInstitutionId(sourceInstitutionId);
        this.setDestinationInstitutionId(destinationInstitutionId);
        this.setNextReferenceCode(minReferenceCode);
        if (this.isUseCheckDigit() && !this.isGenerateReferenceCodeOnDemand()) {
            throw new TreasuryDomainException("error.SibsPaymentCodePool.checkDigit.only.supports.generateReferenceCodeOnDemand", new String[0]);
        }
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbPaymentMethod());
        this.checkRules();
    }

    private void checkRules() {
        if (StringUtils.isEmpty((String)this.getName())) {
            throw new TreasuryDomainException("error.PaymentCodePool.name.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getEntityReferenceCode())) {
            throw new TreasuryDomainException("error.PaymentCodePool.entityReferenceCode.required", new String[0]);
        }
        if (this.getMinReferenceCode() <= 0L || this.getMinReferenceCode() >= this.getMaxReferenceCode()) {
            throw new TreasuryDomainException("error.PaymentCodePool.MinReferenceCode.invalid", new String[0]);
        }
        if (this.getValidFrom() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.validFrom.required", new String[0]);
        }
        if (this.getValidTo() == null) {
            throw new TreasuryDomainException("error.PaymentCodePool.validTo.required", new String[0]);
        }
        if (this.getValidTo().isBefore((ReadablePartial)this.getValidFrom())) {
            throw new TreasuryDomainException("error.PaymentCodePool.ValiddFrom.ValidTo.invalid", new String[0]);
        }
        SibsPaymentCodePool.findAll().filter(p -> p != this).forEach(p -> {
            if (!p.getEntityReferenceCode().equals(this.getEntityReferenceCode())) {
                return;
            }
            if (this.getMinReferenceCode() >= p.getMinReferenceCode() && this.getMinReferenceCode() <= p.getMaxReferenceCode()) {
                throw new TreasuryDomainException("error.SibsPaymentCodePool.invalid.reference.range.cross.other.pools", new String[0]);
            }
            if (this.getMaxReferenceCode() >= p.getMinReferenceCode() && this.getMaxReferenceCode() <= p.getMinReferenceCode()) {
                throw new TreasuryDomainException("error.SibsPaymentCodePool.invalid.reference.range.cross.other.pools", new String[0]);
            }
        });
    }

    public boolean isUseCheckDigit() {
        return super.getUseCheckDigit();
    }

    public boolean isGenerateReferenceCodeOnDemand() {
        return super.getGenerateReferenceCodeOnDemand();
    }

    public long getAndIncrementNextReferenceCode() {
        long nextReferenceCode = this.getNextReferenceCode();
        this.setNextReferenceCode(nextReferenceCode + 1L);
        return nextReferenceCode;
    }

    public Set<SibsPaymentRequest> getAssociatedPaymentRequestsSet() {
        return super.getAssociatedPaymentRequestsSet();
    }

    public void edit(String name, boolean active, LocalDate validFrom, LocalDate validTo, String sourceInstitutionId, String destinationInstitutionId) {
        this.setName(name);
        this.setActive(active);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
        this.setSourceInstitutionId(sourceInstitutionId);
        this.setDestinationInstitutionId(destinationInstitutionId);
        this.checkRules();
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments) {
        if (!this.isActive()) {
            throw new RuntimeException("payment code pool not active");
        }
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(InvoiceEntry::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(SettlementNoteBean settlementNoteBean) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        if (!this.isActive()) {
            throw new RuntimeException("payment code pool not active");
        }
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    @Deprecated
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequestWithInterests(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate interestsCalculationDate) {
        if (!this.isActive()) {
            throw new RuntimeException("payment code pool not active");
        }
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(d -> d.getOpenAmountWithInterestsAtDate(interestsCalculationDate)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        return this.createPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    public Set<SibsReferenceCode> createReferenceCodesInAdvance(int numberOfPaymentsCodesToCreate) {
        if (this.isUseCheckDigit()) {
            throw new RuntimeException("error");
        }
        if (!this.isActive()) {
            throw new RuntimeException("payment code pool not active");
        }
        return IntStream.range(0, numberOfPaymentsCodesToCreate).boxed().map(i -> {
            long nextSequentialNumber = this.getAndIncrementNextReferenceCode();
            if (nextSequentialNumber > this.getMaxReferenceCode()) {
                throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
            }
            String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)7, (String)CODE_FILLER);
            String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
            String referenceCodeString = sequentialNumberPadded + controDigitsPadded;
            return SibsReferenceCode.create(this, referenceCodeString, this.getValidFrom(), this.getValidTo(), this.getMinAmount(), this.getMaxAmount());
        }).collect(Collectors.toSet());
    }

    public Stream<SibsReferenceCode> getPaymentCodesToExport() {
        return this.getPaymentCodesToExport(new LocalDate());
    }

    public Stream<SibsReferenceCode> getPaymentCodesToExport(LocalDate localDate) {
        if (this.getUseCheckDigit()) {
            return Collections.emptySet().stream();
        }
        return this.getSibsReferenceCodesSet().stream().filter(x -> !x.isInPaidState()).filter(x -> !x.isInAnnuledState()).filter(x -> !x.getValidTo().isBefore((ReadablePartial)localDate));
    }

    public void delete() {
        super.delete();
        while (!this.getSibsReferenceCodesSet().isEmpty()) {
            ((SibsReferenceCode)((Object)this.getSibsReferenceCodesSet().iterator().next())).delete();
        }
        super.deleteDomainObject();
    }

    private synchronized SibsPaymentRequest createPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> set, Set<Installment> set2, LocalDate localDate, BigDecimal bigDecimal) {
        return (SibsPaymentRequest)((Object)advice$createPaymentRequest.perform((Callable)new SibsPaymentCodePool$callable$createPaymentRequest(this, debtAccount, set, set2, localDate, bigDecimal)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static synchronized /* synthetic */ SibsPaymentRequest advised$createPaymentRequest(SibsPaymentCodePool this_, DebtAccount debtAccount, Set debitEntries, Set installments, LocalDate validTo, BigDecimal payableAmount) {
        if (SibsPaymentRequest.findRequestedByDebitEntriesSet(debitEntries).count() > 0L || SibsPaymentRequest.findCreatedByDebitEntriesSet(debitEntries).count() > 0L) {
            throw new TreasuryDomainException("error.SibsPaymentCodePool.paymentCode.already.exists.for.selected.debit.entries", new String[0]);
        }
        this_.checkMaxActiveSibsPaymentRequests(debitEntries, installments);
        SibsReferenceCode code = this_.isUseCheckDigit() ? this_.generateCheckDigitPaymentCode(payableAmount, validTo) : this_.generateSequentialPaymentCode(payableAmount, validTo);
        SibsPaymentRequest paymentRequest = SibsPaymentRequest.create(code, debtAccount, debitEntries, installments, payableAmount);
        return paymentRequest;
    }

    private void checkMaxActiveSibsPaymentRequests(Set<DebitEntry> debitEntries, Set<Installment> installments) {
        long numActiveSibsPaymentRequests;
        for (DebitEntry debitEntry : debitEntries) {
            numActiveSibsPaymentRequests = debitEntry.getPaymentRequestsSet().stream().filter(r -> r instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast).filter(r -> r.getState() == PaymentReferenceCodeStateType.UNUSED || r.getState() == PaymentReferenceCodeStateType.USED).count();
            if (numActiveSibsPaymentRequests < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", debitEntry.getDescription());
        }
        for (Installment installment : installments) {
            numActiveSibsPaymentRequests = installment.getPaymentRequestsSet().stream().filter(r -> r instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast).filter(r -> r.getState() == PaymentReferenceCodeStateType.UNUSED || r.getState() == PaymentReferenceCodeStateType.USED).count();
            if (numActiveSibsPaymentRequests < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", installment.getDescription().getContent());
        }
    }

    private SibsReferenceCode generateSequentialPaymentCode(BigDecimal payableAmount, LocalDate validTo) {
        if (this.isUseCheckDigit()) {
            throw new RuntimeException("error");
        }
        LocalDate now = new LocalDate();
        Optional<SibsReferenceCode> possiblePaymentCode = this.getSibsReferenceCodesSet().stream().filter(SibsReferenceCode::isInCreatedState).filter(p -> !TreasuryConstants.isGreaterThan(payableAmount, p.getMaxAmount())).filter(p -> !TreasuryConstants.isLessThan(payableAmount, p.getMinAmount())).filter(p -> p.getSibsPaymentRequest() == null).filter(p -> p.getValidInterval().contains((ReadableInstant)(validTo.isAfter((ReadablePartial)now) ? validTo.toDateTimeAtStartOfDay() : now.toDateTimeAtStartOfDay()))).findAny();
        if (possiblePaymentCode.isPresent()) {
            return possiblePaymentCode.get();
        }
        if (!this.isGenerateReferenceCodeOnDemand()) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        long nextSequentialNumber = this.getAndIncrementNextReferenceCode();
        if (nextSequentialNumber > this.getMaxReferenceCode()) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)7, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        String referenceCodeString = sequentialNumberPadded + controDigitsPadded;
        if (this.getValidTo().isBefore((ReadablePartial)validTo)) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(payableAmount, this.getMaxAmount())) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        if (TreasuryConstants.isLessThan(payableAmount, this.getMinAmount())) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        return SibsReferenceCode.create(this, referenceCodeString, new LocalDate(), validTo, payableAmount, payableAmount);
    }

    private SibsReferenceCode generateCheckDigitPaymentCode(BigDecimal payableAmount, LocalDate validTo) {
        if (!this.isUseCheckDigit()) {
            throw new RuntimeException("error");
        }
        long nextReferenceCode = this.getAndIncrementNextReferenceCode();
        if (nextReferenceCode > this.getMaxReferenceCode()) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf("" + nextReferenceCode), (int)7, (String)CODE_FILLER);
        String referenceCodeString = CheckDigitGenerator.generateReferenceCodeWithCheckDigit(this.getEntityReferenceCode(), sequentialNumberPadded, payableAmount);
        if (this.getValidTo().isBefore((ReadablePartial)validTo)) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(payableAmount, this.getMaxAmount())) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        if (TreasuryConstants.isLessThan(payableAmount, this.getMinAmount())) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        return SibsReferenceCode.create(this, referenceCodeString, new LocalDate(), this.getValidTo(), payableAmount, payableAmount);
    }

    public static Stream<SibsPaymentCodePool> findAll() {
        return DigitalPaymentPlatform.findAll().filter(d -> d instanceof SibsPaymentCodePool).map(SibsPaymentCodePool.class::cast);
    }

    public static Stream<SibsPaymentCodePool> find(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> d instanceof SibsPaymentCodePool).map(SibsPaymentCodePool.class::cast);
    }

    public static Stream<SibsPaymentCodePool> find(FinantialInstitution finantialInstitution, String entityReferenceCode) {
        return SibsPaymentCodePool.find(finantialInstitution).filter(d -> d.getEntityReferenceCode().equals(entityReferenceCode));
    }

    public static Stream<SibsPaymentCodePool> find(String entityReferenceCode) {
        return SibsPaymentCodePool.findAll().filter(d -> d.getEntityReferenceCode().equals(entityReferenceCode));
    }

    public static SibsPaymentCodePool create(FinantialInstitution finantialInstitution, String name, boolean active, String entityReferenceCode, long minReferenceCode, long maxReferenceCode, BigDecimal minAmount, BigDecimal maxAmount, LocalDate validFrom, LocalDate validTo, boolean useCheckDigit, boolean generateReferenceCodeOnDemand, String sourceInstitutionId, String destinationInstitutionId) {
        return new SibsPaymentCodePool(finantialInstitution, name, active, entityReferenceCode, minReferenceCode, maxReferenceCode, minAmount, maxAmount, validFrom, validTo, useCheckDigit, generateReferenceCodeOnDemand, sourceInstitutionId, destinationInstitutionId);
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.SibsPaymentCodePool.presentationName", new String[0]);
    }

    @Override
    public PaymentTransaction processPaymentReferenceCodeTransaction(PaymentRequestLog log, DigitalPlatformResultBean bean) {
        return this.processPaymentReferenceCodeTransaction(log, bean);
    }

    @Override
    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        return Collections.emptyList();
    }

    @Override
    public PaymentRequestLog createLogForWebhookNotification() {
        return null;
    }

    @Override
    public void fillLogForWebhookNotification(PaymentRequestLog log, DigitalPlatformResultBean bean) {
    }
}

