/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest_Base;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.exceptions.ForwardPaymentAlreadyPayedException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.joda.time.DateTime;

public class ForwardPaymentRequest
extends ForwardPaymentRequest_Base {
    private static final Comparator<? super ForwardPaymentRequest> ORDER_COMPARATOR = (o1, o2) -> Long.compare(o1.getOrderNumber(), o2.getOrderNumber()) * 10 + o1.getExternalId().compareTo(o2.getExternalId());

    public ForwardPaymentRequest() {
    }

    protected ForwardPaymentRequest(DigitalPaymentPlatform platform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        this();
        this.init(platform, debtAccount, debitEntries, installments, payableAmount, TreasurySettings.getInstance().getCreditCardPaymentMethod());
        this.setState(ForwardPaymentStateType.CREATED);
        this.setOrderNumber(ForwardPaymentRequest.lastForwardPayment().isPresent() ? ForwardPaymentRequest.lastForwardPayment().get().getOrderNumber() + 1L : 1L);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (this.getOrderNumber() <= 0L) {
            throw new TreasuryDomainException("error.ForwardPaymentRequest.orderNumber.invalid", new String[0]);
        }
    }

    private static Optional<ForwardPaymentRequest> lastForwardPayment() {
        return ForwardPaymentRequest.findAll().max(ORDER_COMPARATOR);
    }

    public boolean isActive() {
        return this.getState() != ForwardPaymentStateType.REJECTED;
    }

    public ForwardPaymentStateType getCurrentState() {
        return this.getState();
    }

    public boolean isInCreatedState() {
        return this.getState() == ForwardPaymentStateType.CREATED;
    }

    public boolean isInRequestedState() {
        return this.getState() == ForwardPaymentStateType.REQUESTED;
    }

    public boolean isInAuthorizedState() {
        return this.getState() == ForwardPaymentStateType.AUTHORIZED;
    }

    public boolean isInPaidState() {
        return this.getState() == ForwardPaymentStateType.PAYED;
    }

    public boolean isInAnnuledState() {
        return this.isInRejectedState();
    }

    public boolean isInRejectedState() {
        return this.getState() == ForwardPaymentStateType.REJECTED;
    }

    public boolean isInStateToPostProcessPayment() {
        return !this.isInAnnuledState() && !this.isInRejectedState() && !this.isInPaidState();
    }

    protected boolean payAllDebitEntriesInterests() {
        return true;
    }

    @Deprecated
    public PaymentRequestLog reject(String operationCode, String statusCode, String errorMessage, String requestBody, String responseBody) {
        this.setState(ForwardPaymentStateType.REJECTED);
        PaymentRequestLog log = this.getDigitalPaymentPlatform().log((PaymentRequest)((Object)this), statusCode, errorMessage, requestBody, responseBody);
        log.setOperationCode(operationCode);
        log.setOperationSuccess(false);
        log.setTransactionWithPayment(false);
        this.checkRules();
        return log;
    }

    public void reject() {
        this.setState(ForwardPaymentStateType.REJECTED);
        this.checkRules();
    }

    public PaymentRequestLog advanceToRequestState(String operationCode, String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setState(ForwardPaymentStateType.REQUESTED);
        PaymentRequestLog log = this.getDigitalPaymentPlatform().log((PaymentRequest)((Object)this), statusCode, statusMessage, requestBody, responseBody);
        log.setOperationCode(operationCode);
        this.checkRules();
        return log;
    }

    public PaymentRequestLog advanceToAuthenticatedState(String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setState(ForwardPaymentStateType.AUTHENTICATED);
        PaymentRequestLog log = this.getDigitalPaymentPlatform().log((PaymentRequest)((Object)this), statusCode, statusMessage, requestBody, responseBody);
        log.setOperationCode("advanceToAuthenticatedState");
        this.checkRules();
        return log;
    }

    public PaymentRequestLog advanceToAuthorizedState(String statusCode, String errorMessage, String requestBody, String responseBody) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInAuthorizedState()) {
            throw new TreasuryDomainException("error.ForwardPayment.already.authorized", new String[0]);
        }
        if (this.isInPaidState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        this.setState(ForwardPaymentStateType.AUTHORIZED);
        PaymentRequestLog log = this.getDigitalPaymentPlatform().log((PaymentRequest)((Object)this), statusCode, errorMessage, requestBody, responseBody);
        log.setOperationCode("advanceToAuthorizedState");
        this.checkRules();
        return log;
    }

    @Deprecated
    public PaymentRequestLog advanceToPaidState(String statusCode, String statusMessage, BigDecimal paidAmount, DateTime transactionDate, String transactionId, String authorizationNumber, String requestBody, String responseBody, String justification) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInPaidState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        if (!this.getPaymentTransactionsSet().isEmpty()) {
            throw new TreasuryDomainException("error.ForwardPayment.with.settlement.note.already.associated", new String[0]);
        }
        this.setState(ForwardPaymentStateType.PAYED);
        PaymentRequestLog log = this.getDigitalPaymentPlatform().log((PaymentRequest)((Object)this), statusCode, statusMessage, requestBody, responseBody);
        log.setOperationCode("advanceToPaidState");
        log.setOperationSuccess(true);
        log.setTransactionWithPayment(true);
        Function<PaymentRequest, Map> additionalPropertiesMapFunction = o -> this.fillPaymentEntryPropertiesMap(transactionId, transactionDate, statusCode);
        Set resultSettlementNotes = null;
        resultSettlementNotes = !TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() ? this.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(paidAmount, transactionDate, String.valueOf(this.getOrderNumber()), transactionId, additionalPropertiesMapFunction) : this.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(paidAmount, transactionDate, String.valueOf(this.getOrderNumber()), transactionId, additionalPropertiesMapFunction);
        PaymentTransaction paymentTransaction = PaymentTransaction.create((PaymentRequest)((Object)this), transactionId, transactionDate, paidAmount, resultSettlementNotes);
        paymentTransaction.setJustification(justification);
        log.setPaymentTransaction(paymentTransaction);
        this.checkRules();
        return log;
    }

    public PaymentTransaction advanceToPaidState(String statusCode, BigDecimal paidAmount, DateTime transactionDate, String transactionId, String justification) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInPaidState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        if (!this.getPaymentTransactionsSet().isEmpty()) {
            throw new TreasuryDomainException("error.ForwardPayment.with.settlement.note.already.associated", new String[0]);
        }
        this.setState(ForwardPaymentStateType.PAYED);
        Function<PaymentRequest, Map> additionalPropertiesMapFunction = o -> this.fillPaymentEntryPropertiesMap(transactionId, transactionDate, statusCode);
        Set resultSettlementNotes = null;
        resultSettlementNotes = !TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() ? this.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(paidAmount, transactionDate, String.valueOf(this.getOrderNumber()), transactionId, additionalPropertiesMapFunction) : this.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(paidAmount, transactionDate, String.valueOf(this.getOrderNumber()), transactionId, additionalPropertiesMapFunction);
        PaymentTransaction paymentTransaction = PaymentTransaction.create((PaymentRequest)((Object)this), transactionId, transactionDate, paidAmount, resultSettlementNotes);
        paymentTransaction.setJustification(justification);
        this.checkRules();
        return paymentTransaction;
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String transactionId, DateTime transactionDate, String statusCode) {
        HashMap paymentEntryPropertiesMap = Maps.newHashMap();
        paymentEntryPropertiesMap.put("OrderNumber", String.valueOf(this.getOrderNumber()));
        if (!Strings.isNullOrEmpty((String)transactionId)) {
            paymentEntryPropertiesMap.put("TransactionId", transactionId);
        }
        if (transactionDate != null) {
            paymentEntryPropertiesMap.put("TransactionDate", transactionDate.toString("yyyy/MM/dd HH:mm:ss"));
        }
        if (!Strings.isNullOrEmpty((String)statusCode)) {
            paymentEntryPropertiesMap.put("StatusCode", statusCode);
        }
        return paymentEntryPropertiesMap;
    }

    public void delete() {
        super.setDomainRoot(null);
        super.setDigitalPaymentPlatform(null);
        super.setDebtAccount(null);
        super.setPaymentMethod(null);
        super.getDebitEntriesSet().clear();
        super.getInstallmentsSet().clear();
        super.getPaymentRequestLogsSet().clear();
        super.getPaymentTransactionsSet().forEach(t -> t.delete());
        super.deleteDomainObject();
    }

    public static Stream<ForwardPaymentRequest> findAll() {
        return PaymentRequest.findAll().filter(p -> p instanceof ForwardPaymentRequest).map(ForwardPaymentRequest.class::cast);
    }

    public static Stream<ForwardPaymentRequest> find(DebitEntry debitEntry) {
        return debitEntry.getPaymentRequestsSet().stream().filter(p -> p instanceof ForwardPaymentRequest).map(ForwardPaymentRequest.class::cast);
    }

    public static Stream<ForwardPaymentRequest> findAllByStateType(ForwardPaymentStateType ... stateTypes) {
        ArrayList t = Lists.newArrayList((Object[])stateTypes);
        return ForwardPaymentRequest.findAll().filter(f -> t.contains(f.getState()));
    }

    public static ForwardPaymentRequest create(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest request = new ForwardPaymentRequest(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay());
        request.setForwardPaymentSuccessUrl(successUrlFunction.apply(request));
        request.setForwardPaymentInsuccessUrl(insuccessUrlFunction.apply(request));
        return request;
    }

    public static ForwardPaymentRequest create(DigitalPaymentPlatform plataform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal amount, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        ForwardPaymentRequest request = new ForwardPaymentRequest(plataform, debtAccount, debitEntries, installments, amount);
        request.setForwardPaymentSuccessUrl(successUrlFunction.apply(request));
        request.setForwardPaymentInsuccessUrl(insuccessUrlFunction.apply(request));
        return request;
    }

    public static Optional<ForwardPaymentRequest> findUniqueByMerchantTransactionId(String merchantTransactionId) {
        return ForwardPaymentRequest.findAll().filter(pr -> StringUtils.isNotEmpty((String)pr.getMerchantTransactionId())).filter(pr -> pr.getMerchantTransactionId().equals(merchantTransactionId)).findFirst();
    }

    public String getUiDescription() {
        return String.format("%s ( %s )", this.getPaymentMethod().getName().getContent(), this.getOrderNumber());
    }
}

