/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.config;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.spaces.domain.occupation.config.RepeatableConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class WeeklyConfig
extends RepeatableConfig {
    private final List<Integer> daysOfWeek;

    public WeeklyConfig(Interval interval, LocalTime startTime, LocalTime endTime, Integer repeatsEvery, List<Integer> daysOfWeek) {
        super(interval, startTime, endTime, repeatsEvery);
        this.daysOfWeek = daysOfWeek;
        if (daysOfWeek == null || daysOfWeek.isEmpty()) {
            throw new IllegalArgumentException("days of week can't be empty or null");
        }
    }

    @Override
    public List<Interval> getIntervals() {
        DateTime checkpoint;
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        DateTime start = this.getInterval().getStart();
        DateTime end = this.getInterval().getEnd();
        int firstDayOfWeekIndex = this.daysOfWeek.indexOf(start.getDayOfWeek());
        if (firstDayOfWeekIndex == -1) {
            firstDayOfWeekIndex = 0;
        }
        if ((checkpoint = start.withDayOfWeek(this.daysOfWeek.get(firstDayOfWeekIndex).intValue())).isBefore((ReadableInstant)start)) {
            checkpoint.plusWeeks(1);
        }
        int i = firstDayOfWeekIndex;
        while (checkpoint.isBefore((ReadableInstant)end) || checkpoint.isEqual((ReadableInstant)end)) {
            intervals.add(new Interval((ReadableInstant)checkpoint.withFields((ReadablePartial)this.getStartTime()), (ReadableInstant)checkpoint.withFields((ReadablePartial)this.getEndTime())));
            if (i == this.daysOfWeek.size() - 1) {
                i = 0;
                checkpoint = checkpoint.plusWeeks(this.getRepeatsEvery().intValue());
            } else {
                ++i;
            }
            checkpoint = checkpoint.withDayOfWeek(this.daysOfWeek.get(i).intValue());
        }
        return intervals;
    }
}

