/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.SharedOccupation_Base;
import org.fenixedu.spaces.domain.occupation.config.ExplicitConfigWithSettings;
import org.fenixedu.spaces.domain.occupation.config.OccupationConfig;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.ui.SpaceOccupantsBean;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class SharedOccupation
extends SharedOccupation_Base {
    public SharedOccupation() {
        this.setBennu(Bennu.getInstance());
    }

    public SharedOccupation(String emails, String subject, String description, OccupationConfig config) {
        this(emails, subject, description, config, null);
    }

    public SharedOccupation(String emails, String subject, String description, OccupationConfig config, OccupationRequest request) {
        this();
        this.setConfig(config);
        this.setEmails(emails);
        this.setSubject(subject);
        this.setDescription(description);
        this.setRequest(request);
    }

    public boolean doConfig(SpaceOccupantsBean sob) {
        return this.doAction(sob);
    }

    public void addSpace(Space space) {
        if (this.getSpaces().size() >= 1) {
            return;
        }
        super.addSpace(space);
    }

    public void removeSpace(Space space) {
        super.removeSpace(space);
    }

    public Set<Space> getSpaces() {
        return this.getSpaceSet().stream().filter(space -> space.isActive()).collect(Collectors.toSet());
    }

    public List<Interval> getActiveIntervals() {
        return this.getConfig().getIntervals().stream().filter(i -> i.contains((ReadableInstant)new DateTime())).collect(Collectors.toList());
    }

    public List<Interval> getInactiveIntervals() {
        return this.getConfig().getIntervals().stream().filter(i -> !i.contains((ReadableInstant)new DateTime())).collect(Collectors.toList());
    }

    public Boolean overlaps(List<Interval> intervals) {
        for (Interval interval : intervals) {
            for (Interval occupationInterval : this.getIntervals()) {
                if (!occupationInterval.overlaps((ReadableInterval)interval)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlaps(Interval ... intervals) {
        for (Interval interval : intervals) {
            for (Interval occupationInterval : this.getIntervals()) {
                if (!occupationInterval.overlaps((ReadableInterval)interval)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isActive() {
        return this.getIntervals().stream().anyMatch(interval -> interval.contains((ReadableInstant)DateTime.now()));
    }

    public String getSummary() {
        return this.getConfig().getSummary();
    }

    public String getExtendedSummary() {
        return this.getConfig().getExtendedSummary();
    }

    public DateTime getStart() {
        return this.getConfig().getStart();
    }

    public DateTime getEnd() {
        return this.getConfig().getEnd();
    }

    public String getSubject() {
        if (super.getSubject() != null && !super.getSubject().isEmpty()) {
            return super.getSubject();
        }
        if (this.getUser() != null) {
            return this.getUser().getProfile().getDisplayName();
        }
        return super.getSubject();
    }

    public void delete() {
        if (this.getRequest() != null) {
            this.setRequest(null);
        }
        this.setBennu(null);
        this.getSpaceSet().clear();
        super.deleteDomainObject();
    }

    public boolean canManageOccupation(User user) {
        for (Space space : this.getSpaces()) {
            if (space.isOccupationMember(user)) continue;
            return false;
        }
        return true;
    }

    private List<Interval> removeIntervals(List<Interval> li, SpaceOccupantsBean config) {
        ArrayList<Interval> linterval = new ArrayList<Interval>(li);
        if (config.getAction().equals("add") || config.getOldIntervalList() == null) {
            return linterval;
        }
        int pos = -1;
        for (int i = 0; i < linterval.size(); ++i) {
            if (!((Interval)linterval.get(i)).equals((Object)config.getOldIntervalList().get(0))) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            throw new SpaceOccupationException("error", "label.invalidOldInterval", "");
        }
        if (pos != -1) {
            linterval.remove(pos);
        }
        return linterval;
    }

    private List<Interval> addIntervals(List<Interval> li, SpaceOccupantsBean config) {
        ArrayList<Interval> linterval = new ArrayList<Interval>(li);
        if (config.getAction().equals("remove") || config.getNewIntervalList() == null) {
            return linterval;
        }
        linterval.add(config.getNewIntervalList().get(0));
        return linterval;
    }

    public boolean doAction(SpaceOccupantsBean config) {
        OccupationConfig old;
        User user = config.getUserObject();
        if (user == null) {
            throw new SpaceOccupationException("error", "label.nosuchuser", config.getUser());
        }
        if (this.getUser() != null && !this.getUser().equals((Object)user)) {
            throw new SpaceOccupationException("error", "label.usermismatch", config.getUser());
        }
        if (this.getUser() == null) {
            this.setUser(user);
        }
        if ((old = this.getConfig()) == null) {
            List<Interval> in = config.getNewIntervalList();
            DateTime start = in.iterator().next().getStart();
            DateTime end = in.iterator().next().getEnd();
            ExplicitConfigWithSettings oc = new ExplicitConfigWithSettings(start, end, true, in);
            this.setConfig(oc);
            return true;
        }
        List<Interval> li = old.getIntervals();
        li = this.removeIntervals(li, config);
        li = this.addIntervals(li, config);
        DateTime start = new DateTime().year().withMaximumValue();
        DateTime end = new DateTime(0L);
        for (Interval i : li) {
            if (start.isAfter((ReadableInstant)i.getStart())) {
                start = i.getStart();
            }
            if (!end.isBefore((ReadableInstant)i.getEnd())) continue;
            end = i.getEnd();
        }
        ExplicitConfigWithSettings oc = new ExplicitConfigWithSettings(start, end, true, li);
        this.setConfig(oc);
        return true;
    }

    public String getInfo() {
        return "";
    }

    private static class SpaceOccupationException
    extends DomainException {
        String kind;

        protected SpaceOccupationException(String kind, String label, String message) {
            super(Response.Status.INTERNAL_SERVER_ERROR, "resources/FenixEduSpacesResources", label, new String[]{message});
            this.kind = kind;
        }

        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            json.addProperty(this.kind, this.getLocalizedMessage());
            return json;
        }
    }
}

