/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.Information;
import org.fenixedu.spaces.domain.Space$callable$bean;
import org.fenixedu.spaces.domain.Space$callable$delete;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.Space_Base;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.fenixedu.spaces.ui.InformationBean;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Space
extends Space_Base
implements Comparable<Space> {
    public static final Comparator<Space> NORMALIZED_SPACE_NAMES_COMPARATOR;
    public static final Advice advice$bean;
    public static final Advice advice$delete;

    public Space() {
    }

    public Space(Information information) {
        this(null, information);
    }

    public Space(Space parent, Information information) {
        this.init(parent, information);
    }

    private void init(Space parent, Information information) {
        this.setCreated(new DateTime());
        this.add(information);
        this.setParent(parent);
        this.setBennu(Bennu.getInstance());
    }

    public void init(Space parent, InformationBean informationBean) {
        this.init(parent, Information.builder(informationBean).build());
    }

    public Space(Space parent, InformationBean informationBean) {
        this.init(parent, informationBean);
    }

    public InformationBean bean() {
        return this.getInformation().map(info -> Information.builder(info)).orElse(Information.builder()).bean();
    }

    public void bean(InformationBean informationBean) {
        Object object = advice$bean.perform((Callable)new Space$callable$bean(this, informationBean));
    }

    static /* synthetic */ void advised$bean(Space this_, InformationBean informationBean) {
        this_.add(Information.builder(informationBean).build());
    }

    public List<InformationBean> timeline() {
        ArrayList<InformationBean> timeline = new ArrayList<InformationBean>();
        for (Information current = this.getCurrent(); current != null; current = current.getPrevious()) {
            timeline.add(Information.builder(current).bean());
        }
        return Lists.reverse(timeline);
    }

    public SpaceClassification getClassification() {
        return this.getInformation().map(info -> info.getClassification()).get();
    }

    public boolean isActive() {
        return this.getInformation().isPresent() && this.getBennu() != null;
    }

    public <T> Optional<T> getMetadata(String field) {
        Optional<Information> information = this.getInformation();
        return information.isPresent() ? information.get().getMetadata(field) : Optional.empty();
    }

    protected Optional<Information> getInformation() {
        return this.getInformation(new DateTime());
    }

    protected Optional<Information> getInformation(DateTime when) {
        return this.getInformation(when, new DateTime());
    }

    protected Optional<Information> getInformation(DateTime when, DateTime creationDate) {
        for (Information current = this.getCurrent(); current != null; current = current.getPrevious()) {
            if (!current.contains(when)) continue;
            return Optional.of(current);
        }
        return Optional.empty();
    }

    private Boolean dateEquals(DateTime validFrom, DateTime validUntil) {
        if (validFrom == null && validUntil == null) {
            return Boolean.TRUE;
        }
        return validFrom == null ? Boolean.FALSE.booleanValue() : validFrom.equals((Object)validUntil);
    }

    protected void add(Information information) {
        Information current;
        if (information == null) {
            return;
        }
        if (this.getCurrent() == null) {
            this.setCurrent(information);
            return;
        }
        DateTime newStart = information.getValidFrom();
        DateTime newEnd = information.getValidUntil();
        Interval newValidity = information.getValidity();
        Information newCurrent = null;
        Information last = null;
        Information newHead = null;
        Information head = current = this.getCurrent();
        Interval currentValidity = current.getValidity();
        boolean foundEnd = false;
        boolean foundStart = false;
        if (newValidity.isAfter((ReadableInterval)currentValidity)) {
            newHead = information;
            newHead.setPrevious(head);
        }
        if (newHead == null) {
            while (current != null) {
                if (!foundEnd && !foundStart && current.contains(newValidity)) {
                    if (current.getValidity().equals((Object)newValidity)) {
                        newCurrent = information;
                    } else {
                        Information right;
                        Information information2 = right = this.dateEquals(current.getValidUntil(), newEnd) != false ? information : current.keepRight(newEnd);
                        if (last != null) {
                            last.setPrevious(right);
                        } else {
                            newHead = right;
                        }
                        if (right != information) {
                            right.setPrevious(information);
                        }
                        last = information;
                        newCurrent = this.dateEquals(current.getValidFrom(), newStart) != false ? last : current.keepLeft(newStart);
                    }
                    foundEnd = true;
                    foundStart = true;
                } else {
                    if (!foundEnd) {
                        boolean isAfter = current.isAfter(newEnd);
                        if (current.contains(newEnd) || isAfter) {
                            if (!isAfter) {
                                Information right = current.keepRight(newEnd);
                                if (last != null) {
                                    last.setPrevious(right);
                                } else {
                                    newHead = right;
                                }
                                last = right;
                            }
                            newCurrent = information;
                            foundEnd = true;
                        }
                    }
                    boolean isAfter = current.isAfter(newStart);
                    if (foundEnd && (current.contains(newStart) || isAfter)) {
                        newCurrent = current.keepLeft(newStart);
                        foundStart = true;
                    } else if (!foundEnd || foundStart) {
                        newCurrent = current.copy();
                    }
                }
                if (last != null && !last.equals((Object)newCurrent)) {
                    last.setPrevious(newCurrent);
                }
                last = newCurrent;
                if (newHead == null) {
                    newHead = newCurrent;
                }
                current = current.getPrevious();
            }
            if (!foundEnd) {
                last.setPrevious(information);
            }
        }
        this.addHistory(head);
        this.setCurrent(newHead);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Space$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Space this_) {
        this_.setBennu(null);
        this_.setDeletedBennu(Bennu.getInstance());
    }

    public Optional<Space> readChildByBlueprintNumber(String blueprintNumber, DateTime when) {
        return Strings.isNullOrEmpty((String)blueprintNumber) ? Optional.empty() : this.getChildren().stream().filter(space -> blueprintNumber.equals(space.getBlueprintNumber().orElse(null))).findFirst();
    }

    public Optional<String> getBlueprintNumber() {
        return this.getInformation().map(info -> info.getBlueprintNumber());
    }

    public Optional<String> getBlueprintNumber(DateTime when) {
        return this.getInformation(when).map(info -> info.getBlueprintNumber());
    }

    public Optional<BlueprintFile> getBlueprintFile() {
        return this.getBlueprintFile(new DateTime());
    }

    public Optional<BlueprintFile> getBlueprintFile(DateTime when) {
        return this.getInformation(when).map(info -> info.getBlueprint());
    }

    public Optional<Set<SpacePhoto>> getSpacePhotoSet() {
        return this.getSpacePhotoSet(new DateTime());
    }

    public Optional<Set<SpacePhoto>> getSpacePhotoSet(DateTime when) {
        return this.getInformation(when).map(info -> info.getSpacePhotoSet());
    }

    public void addSpacePhoto(SpacePhoto photo) {
        this.getInformation(new DateTime()).get().addSpacePhoto(photo);
    }

    public List<Space> getPath() {
        ArrayList<Space> path = new ArrayList<Space>();
        for (Space parent = this; parent != null && parent.isActive(); parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    public Optional<String> getName(DateTime when) {
        return this.getInformation(when).map(info -> info.getName());
    }

    public String getName() {
        return this.getInformation().map(info -> info.getName()).orElse("");
    }

    public String getFullName() {
        Object name = this.getName();
        String description = this.getMetadata("description").orElse("");
        if (!description.isEmpty()) {
            if (!((String)name).isEmpty()) {
                name = (String)name + " - ";
            }
            name = (String)name + description;
        }
        return name;
    }

    public Optional<Integer> getAllocatableCapacity(DateTime when) {
        return this.getInformation(when).map(info -> info.getAllocatableCapacity());
    }

    public Integer getAllocatableCapacity() {
        return this.getInformation().map(info -> info.getAllocatableCapacity()).orElse(0);
    }

    public Set<Space> getChildren() {
        return this.getChildrenSet().stream().filter(space -> space.isActive()).collect(Collectors.toSet());
    }

    public Set<Space> getChildTree() {
        return Stream.concat(Stream.of(this), this.getChildrenSet().stream().flatMap(space -> space.getChildTree().stream())).collect(Collectors.toSet());
    }

    public static Set<Space> getSpaces(SpaceClassification classification) {
        return Space.getSpaces().filter(space -> classification.equals((Object)space.getClassification())).collect(Collectors.toSet());
    }

    @Deprecated
    public static Set<Space> getAllCampus() {
        return Space.getTopLevelSpaces();
    }

    public static Set<Space> getTopLevelSpaces() {
        return Space.getSpaces().filter(s -> s.getParent() == null).sorted().collect(Collectors.toSet());
    }

    public Group getManagementGroup() {
        return this.getManagementAccessGroup() != null ? this.getManagementAccessGroup().toGroup() : null;
    }

    public Group getManagementGroupWithChainOfResponsability() {
        Space surroundingSpace;
        Group accessGroup = this.getManagementGroup();
        if (accessGroup == null) {
            accessGroup = Group.nobody();
        }
        if ((surroundingSpace = this.getParent()) != null) {
            return accessGroup.or(surroundingSpace.getManagementGroupWithChainOfResponsability());
        }
        return accessGroup;
    }

    public Group getOccupationsGroup() {
        return this.getOccupationsAccessGroup() != null ? this.getOccupationsAccessGroup().toGroup() : null;
    }

    public Group getOccupationsGroupWithChainOfResponsability() {
        Space surroundingSpace;
        Group accessGroup = this.getOccupationsGroup();
        if (accessGroup == null) {
            accessGroup = Group.nobody();
        }
        if ((surroundingSpace = this.getParent()) != null) {
            return accessGroup.or(surroundingSpace.getOccupationsGroupWithChainOfResponsability());
        }
        return accessGroup;
    }

    public void setManagementAccessGroup(Group managementAccessGroup) {
        super.setManagementAccessGroup(managementAccessGroup == null ? null : managementAccessGroup.toPersistentGroup());
    }

    public void setOccupationsAccessGroup(Group occupationsAccessGroup) {
        super.setOccupationsAccessGroup(occupationsAccessGroup == null ? null : occupationsAccessGroup.toPersistentGroup());
    }

    public boolean isFree(Interval ... intervals) {
        for (Occupation occupation : this.getOccupationSet()) {
            if (!occupation.overlaps(intervals)) continue;
            return false;
        }
        return true;
    }

    public boolean isFree(List<Interval> intervals) {
        for (Occupation occupation : this.getOccupationSet()) {
            if (!occupation.overlaps(intervals).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String getPresentationName() {
        List path = Lists.reverse(this.getPath());
        String others = path.subList(1, path.size()).stream().map(Space::getName).collect(Collectors.joining(", "));
        return String.format(Strings.isNullOrEmpty((String)others) ? "%s" : "%s (%s)", ((Space)path.get(0)).getName(), others);
    }

    public boolean isOccupationMember(User user) {
        Group group = this.getOccupationsGroupWithChainOfResponsability();
        return group != null && group.isMember(user);
    }

    public boolean isSpaceManagementMember(User user) {
        Group group = this.getManagementGroupWithChainOfResponsability();
        return group != null && group.isMember(user);
    }

    public static Stream<Space> getSpaces() {
        return Space.getAllSpaces().filter(space -> space.isActive());
    }

    public static Stream<Space> getAllSpaces() {
        return Bennu.getInstance().getSpaceSet().stream();
    }

    @Override
    public int compareTo(Space o) {
        return this.getFullName().toLowerCase().compareTo(o.getFullName().toLowerCase());
    }

    static {
        advice$bean = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        NORMALIZED_SPACE_NAMES_COMPARATOR = (space1, space2) -> {
            String name1 = Normalizer.normalize(space1.getName(), Normalizer.Form.NFD).toLowerCase();
            String name2 = Normalizer.normalize(space2.getName(), Normalizer.Form.NFD).toLowerCase();
            return name1.compareTo(name2);
        };
    }
}

