/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui.services;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.fenixedu.spaces.domain.submission.SpacePhotoSubmission;
import org.fenixedu.spaces.ui.PhotoSubmissionBean;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$acceptSpacePhoto;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$cancelUserSubmission;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$createPhotoSubmission;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$hideSpacePhoto;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$rejectSpacePhoto;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$removeSpacePhoto;
import org.fenixedu.spaces.ui.services.SpacePhotoService$callable$showSpacePhoto;
import org.joda.time.DateTime;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class SpacePhotoService {
    private final int PHOTOS_IN_PAGE = 10;
    public static final Advice advice$createPhotoSubmission = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$rejectSpacePhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$acceptSpacePhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeSpacePhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$cancelUserSubmission = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$hideSpacePhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$showSpacePhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SpacePhotoSubmission createPhotoSubmission(PhotoSubmissionBean photoSubmissionBean, Space space) {
        return (SpacePhotoSubmission)((Object)advice$createPhotoSubmission.perform((Callable)new SpacePhotoService$callable$createPhotoSubmission(this, photoSubmissionBean, space)));
    }

    static /* synthetic */ SpacePhotoSubmission advised$createPhotoSubmission(SpacePhotoService this_, PhotoSubmissionBean bean2, Space space) {
        SpacePhoto photo = new SpacePhoto(bean2.getSubmissionMultipartFile().getName(), bean2.getSubmissionContent());
        return new SpacePhotoSubmission(space, bean2.getSubmitor(), photo);
    }

    public List<SpacePhotoSubmission> getAllSpacePhotoSubmissionsToProcess(Space space) {
        Set<Space> allSpaces = space.getChildTree();
        List allPendingPhotos = allSpaces.stream().map(s -> s.getSpacePhotoSubmissionPendingSet()).flatMap(set -> set.stream()).collect(Collectors.toList());
        return allPendingPhotos.stream().sorted(SpacePhotoSubmission.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public List<SpacePhotoSubmission> getSpacePhotoSubmissionsToProcess(Space space) {
        return space.getSpacePhotoSubmissionPendingSet().stream().sorted(SpacePhotoSubmission.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public List<SpacePhoto> getVisiblePhotos(Space space) {
        return this.getAllSpacePhotos(space).stream().filter(photo -> photo.isVisible()).collect(Collectors.toList());
    }

    public List<SpacePhoto> getAllSpacePhotos(Space space) {
        if (space.getSpacePhotoSet().isPresent()) {
            return space.getSpacePhotoSet().get().stream().sorted(SpacePhoto.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public PagedListHolder<SpacePhoto> getPhotoBook(List<SpacePhoto> photos, String pageString) {
        int page;
        PagedListHolder book;
        block5: {
            book = new PagedListHolder(photos);
            book.setPageSize(10);
            page = 0;
            if (Strings.isNullOrEmpty((String)pageString)) {
                page = 0;
            } else {
                try {
                    page = Integer.parseInt(pageString);
                }
                catch (NumberFormatException nfe) {
                    if ("f".equals(pageString)) {
                        page = 0;
                    }
                    if (!"l".equals(pageString)) break block5;
                    page = book.getPageCount();
                }
            }
        }
        book.setPage(page == 0 ? 0 : page - 1);
        return book;
    }

    public PagedListHolder<SpacePhotoSubmission> getSubmissionBook(List<SpacePhotoSubmission> submissions, String pageString) {
        int page;
        PagedListHolder book;
        block5: {
            book = new PagedListHolder(submissions);
            book.setPageSize(10);
            page = 0;
            if (Strings.isNullOrEmpty((String)pageString)) {
                page = 0;
            } else {
                try {
                    page = Integer.parseInt(pageString);
                }
                catch (NumberFormatException nfe) {
                    if ("f".equals(pageString)) {
                        page = 0;
                    }
                    if (!"l".equals(pageString)) break block5;
                    page = book.getPageCount();
                }
            }
        }
        book.setPage(page == 0 ? 0 : page - 1);
        return book;
    }

    public void rejectSpacePhoto(SpacePhotoSubmission spacePhotoSubmission, User user, String string) {
        Object object = advice$rejectSpacePhoto.perform((Callable)new SpacePhotoService$callable$rejectSpacePhoto(this, spacePhotoSubmission, user, string));
    }

    static /* synthetic */ void advised$rejectSpacePhoto(SpacePhotoService this_, SpacePhotoSubmission spacePhotoSubmission, User reviewer, String rejectionMessage) {
        spacePhotoSubmission.setModified(new DateTime());
        Space space = spacePhotoSubmission.getSpacePending();
        spacePhotoSubmission.setRejectionMessage(rejectionMessage);
        spacePhotoSubmission.setReviewer(reviewer);
        space.removeSpacePhotoSubmissionPending(spacePhotoSubmission);
        space.addSpacePhotoSubmissionArchived(spacePhotoSubmission);
    }

    public void acceptSpacePhoto(SpacePhotoSubmission spacePhotoSubmission, User user) {
        Object object = advice$acceptSpacePhoto.perform((Callable)new SpacePhotoService$callable$acceptSpacePhoto(this, spacePhotoSubmission, user));
    }

    static /* synthetic */ void advised$acceptSpacePhoto(SpacePhotoService this_, SpacePhotoSubmission spacePhotoSubmission, User reviewer) {
        spacePhotoSubmission.setModified(new DateTime());
        Space space = spacePhotoSubmission.getSpacePending();
        space.addSpacePhoto(spacePhotoSubmission.getPhoto());
        spacePhotoSubmission.setReviewer(reviewer);
        space.removeSpacePhotoSubmissionPending(spacePhotoSubmission);
    }

    public void removeSpacePhoto(Space space, SpacePhoto spacePhoto) {
        Object object = advice$removeSpacePhoto.perform((Callable)new SpacePhotoService$callable$removeSpacePhoto(this, space, spacePhoto));
    }

    static /* synthetic */ void advised$removeSpacePhoto(SpacePhotoService this_, Space space, SpacePhoto spacePhoto) {
        spacePhoto.getSubmission().setModified(new DateTime());
        space.getSpacePhotoSet().orElse(Collections.emptySet()).remove((Object)spacePhoto);
        space.addSpacePhotoSubmissionArchived(spacePhoto.getSubmission());
    }

    public void cancelUserSubmission(SpacePhotoSubmission spacePhotoSubmission, User user) {
        Object object = advice$cancelUserSubmission.perform((Callable)new SpacePhotoService$callable$cancelUserSubmission(this, spacePhotoSubmission, user));
    }

    static /* synthetic */ void advised$cancelUserSubmission(SpacePhotoService this_, SpacePhotoSubmission photoSubmission, User user) {
        if (photoSubmission.isPending() && user.equals((Object)photoSubmission.getSubmitor())) {
            photoSubmission.delete();
        }
    }

    public void hideSpacePhoto(SpacePhoto spacePhoto) {
        Object object = advice$hideSpacePhoto.perform((Callable)new SpacePhotoService$callable$hideSpacePhoto(this, spacePhoto));
    }

    static /* synthetic */ void advised$hideSpacePhoto(SpacePhotoService this_, SpacePhoto spacePhoto) {
        spacePhoto.setVisible(false);
    }

    public void showSpacePhoto(SpacePhoto spacePhoto) {
        Object object = advice$showSpacePhoto.perform((Callable)new SpacePhotoService$callable$showSpacePhoto(this, spacePhoto));
    }

    static /* synthetic */ void advised$showSpacePhoto(SpacePhotoService this_, SpacePhoto spacePhoto) {
        spacePhoto.setVisible(true);
    }

    public List<SpacePhotoSubmission> getPendingUserSubmissions(User user) {
        return user.getSpacePhotoSubmissionSet().stream().filter(s -> s.isPending()).sorted(SpacePhotoSubmission.COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public List<SpacePhotoSubmission> getAcceptedUserSubmissions(User user) {
        return user.getSpacePhotoSubmissionSet().stream().filter(s -> s.isAccepted()).sorted(SpacePhotoSubmission.COMPARATOR_BY_MODIFIED.reversed()).collect(Collectors.toList());
    }

    public List<SpacePhotoSubmission> getRejectedUserSubmissions(User user) {
        return user.getSpacePhotoSubmissionSet().stream().filter(s -> s.isRejected()).sorted(SpacePhotoSubmission.COMPARATOR_BY_MODIFIED.reversed()).collect(Collectors.toList());
    }

    public List<SpacePhotoSubmission> getArchivedSpacePhotoSubmissions(Space space) {
        return space.getSpacePhotoSubmissionArchivedSet().stream().sorted(SpacePhotoSubmission.COMPARATOR_BY_MODIFIED.reversed()).collect(Collectors.toList());
    }
}

