/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.ui.SpaceClassificationBean;
import org.fenixedu.spaces.ui.services.SpaceClassificationService$callable$setCode;
import org.fenixedu.spaces.ui.services.SpaceClassificationService$callable$setIsAllocatable;
import org.fenixedu.spaces.ui.services.SpaceClassificationService$callable$setMetadataSpec;
import org.fenixedu.spaces.ui.services.SpaceClassificationService$callable$setName;
import org.fenixedu.spaces.ui.services.SpaceClassificationService$callable$setParentClassification;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class SpaceClassificationService {
    public static final Advice advice$setMetadataSpec = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setIsAllocatable = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setName = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setParentClassification = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void verifyClassification(SpaceClassificationBean bean2) throws SpaceClassificationException {
        JsonArray jsarray = bean2.getMetadataSpec().getAsJsonArray();
        HashMap<String, Boolean> hasName = new HashMap<String, Boolean>();
        for (JsonElement jsonElement : jsarray) {
            Class<?> typeClass;
            JsonObject jo = jsonElement.getAsJsonObject();
            String name = jo.get("name").getAsString();
            String type = jo.get("type").getAsString();
            try {
                typeClass = Class.forName(type);
            }
            catch (ClassNotFoundException e1) {
                throw new SpaceClassificationException("error", "label.spaceClassification.noSuchClass", type);
            }
            String defaultValue = jo.get("defaultValue").getAsString();
            if (hasName.containsKey(name)) {
                throw new SpaceClassificationException("error", "label.spaceClassification.duplicatedKey", name);
            }
            hasName.put(name, true);
            if (defaultValue.isEmpty()) continue;
            try {
                if (Integer.class.isAssignableFrom(typeClass) && !defaultValue.isEmpty()) {
                    Integer.parseInt(defaultValue);
                    continue;
                }
            }
            catch (Exception e) {
                throw new SpaceClassificationException("error", "label.spaceClassification.typeMismatch", type + " ( " + defaultValue + " --> Number )");
            }
            if (Boolean.class.isAssignableFrom(typeClass) && !defaultValue.isEmpty()) {
                if (Boolean.parseBoolean(defaultValue.trim()) || defaultValue.trim().equalsIgnoreCase("false")) continue;
                throw new SpaceClassificationException("error", "label.spaceClassification.typeMismatch", type + " ( " + defaultValue + " --> Boolean )");
            }
            if (DateTime.class.isAssignableFrom(typeClass) && !defaultValue.isEmpty()) {
                try {
                    DateTime.parse((String)defaultValue.trim(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
                    continue;
                }
                catch (Exception e) {
                    throw new SpaceClassificationException("error", "label.spaceClassification.typeMismatch", type + " ( " + defaultValue + " --> Date )");
                }
            }
            if (String.class.isAssignableFrom(typeClass)) continue;
            throw new SpaceClassificationException("error", "label.spaceClassification.noSuchClass", type);
        }
    }

    public void updateClassification(SpaceClassification classification, SpaceClassificationBean bean2) {
        this.setMetadataSpec(classification, bean2.getMetadataSpec());
        this.setName(classification, bean2.getLocalizedName());
        this.setCode(classification, bean2.getCode());
        this.setParentClassification(classification, bean2.getParent());
        this.setIsAllocatable(classification, bean2.getIsAllocatable());
    }

    public void setMetadataSpec(SpaceClassification spaceClassification, JsonElement jsonElement) {
        Object object = advice$setMetadataSpec.perform((Callable)new SpaceClassificationService$callable$setMetadataSpec(this, spaceClassification, jsonElement));
    }

    static /* synthetic */ void advised$setMetadataSpec(SpaceClassificationService this_, SpaceClassification classification, JsonElement metadata) {
        classification.setMetadataSpec(metadata);
    }

    public void setIsAllocatable(SpaceClassification spaceClassification, boolean bl) {
        Object object = advice$setIsAllocatable.perform((Callable)new SpaceClassificationService$callable$setIsAllocatable(this, spaceClassification, bl));
    }

    static /* synthetic */ void advised$setIsAllocatable(SpaceClassificationService this_, SpaceClassification classification, boolean isAllocatable) {
        classification.setIsAllocatable(isAllocatable);
    }

    public void setName(SpaceClassification spaceClassification, LocalizedString localizedString) {
        Object object = advice$setName.perform((Callable)new SpaceClassificationService$callable$setName(this, spaceClassification, localizedString));
    }

    static /* synthetic */ void advised$setName(SpaceClassificationService this_, SpaceClassification classification, LocalizedString name) {
        classification.setName(name);
    }

    public void setCode(SpaceClassification spaceClassification, String string) {
        Object object = advice$setCode.perform((Callable)new SpaceClassificationService$callable$setCode(this, spaceClassification, string));
    }

    static /* synthetic */ void advised$setCode(SpaceClassificationService this_, SpaceClassification classification, String code) {
        classification.setCode(code);
    }

    public void setParentClassification(SpaceClassification spaceClassification, String string) {
        Object object = advice$setParentClassification.perform((Callable)new SpaceClassificationService$callable$setParentClassification(this, spaceClassification, string));
    }

    static /* synthetic */ void advised$setParentClassification(SpaceClassificationService this_, SpaceClassification classification, String parent) {
        SpaceClassification parentClassification = null;
        if (parent.length() <= 0) {
            if (!classification.isRootClassification()) {
                throw new SpaceClassificationException("error", "label.spaceClassification.mustSelectParent", "");
            }
            classification.setParent(parentClassification);
            return;
        }
        parentClassification = (SpaceClassification)FenixFramework.getDomainObject((String)parent);
        ArrayList<SpaceClassification> listParentClassifications = new ArrayList<SpaceClassification>();
        for (SpaceClassification loopParents = parentClassification; loopParents != null; loopParents = loopParents.getParent()) {
            listParentClassifications.add(loopParents);
            if (!loopParents.equals((Object)classification)) continue;
            throw new SpaceClassificationException("error", "label.spaceClassification.isInParentChain", "");
        }
        List<SpaceClassification> listChildClassifications = classification.getAllChildren();
        if (!Collections.disjoint(listChildClassifications, listParentClassifications)) {
            throw new SpaceClassificationException("error", "label.spaceClassification.isInParentChain", "");
        }
        classification.setParent(parentClassification);
    }

    private static class SpaceClassificationException
    extends DomainException {
        String kind;
        String message;

        protected SpaceClassificationException(String kind, String label, String message) {
            super(Response.Status.INTERNAL_SERVER_ERROR, "resources/FenixEduSpacesResources", label, new String[]{message});
            this.kind = kind;
            this.message = message;
        }

        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            Object finalMessage = this.getLocalizedMessage();
            if (!this.message.isEmpty()) {
                finalMessage = (String)finalMessage + " : " + this.message;
            }
            json.addProperty(this.kind, (String)finalMessage);
            return json;
        }
    }
}

